/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.TlsUtils;

public class ByteQueue {
    private byte[] databuf;
    private int skipped = 0;
    private int available = 0;
    private boolean readOnlyBuf = false;

    public static int nextTwoPow(int n) {
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public ByteQueue() {
        this(0);
    }

    public ByteQueue(int n) {
        this.databuf = n == 0 ? TlsUtils.EMPTY_BYTES : new byte[n];
    }

    public ByteQueue(byte[] byArray, int n, int n2) {
        this.databuf = byArray;
        this.skipped = n;
        this.available = n2;
        this.readOnlyBuf = true;
    }

    public void addData(byte[] byArray, int n, int n2) {
        if (this.readOnlyBuf) {
            throw new IllegalStateException("Cannot add data to read-only buffer");
        }
        if (this.available == 0) {
            if (n2 > this.databuf.length) {
                int n3 = ByteQueue.nextTwoPow(n2 | 0x100);
                this.databuf = new byte[n3];
            }
            this.skipped = 0;
        } else if (this.skipped + this.available + n2 > this.databuf.length) {
            int n4 = ByteQueue.nextTwoPow(this.available + n2);
            if (n4 > this.databuf.length) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.databuf, this.skipped, byArray2, 0, this.available);
                this.databuf = byArray2;
            } else {
                System.arraycopy(this.databuf, this.skipped, this.databuf, 0, this.available);
            }
            this.skipped = 0;
        }
        System.arraycopy(byArray, n, this.databuf, this.skipped + this.available, n2);
        this.available += n2;
    }

    public int available() {
        return this.available;
    }

    public void copyTo(OutputStream outputStream, int n) throws IOException {
        if (n > this.available) {
            throw new IllegalStateException("Cannot copy " + n + " bytes, only got " + this.available);
        }
        outputStream.write(this.databuf, this.skipped, n);
    }

    public void read(byte[] byArray, int n, int n2, int n3) {
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Buffer size of " + byArray.length + " is too small for a read of " + n2 + " bytes");
        }
        if (this.available - n3 < n2) {
            throw new IllegalStateException("Not enough data to read");
        }
        System.arraycopy(this.databuf, this.skipped + n3, byArray, n, n2);
    }

    public void read(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = byteBuffer.remaining();
        if (n3 < n) {
            throw new IllegalArgumentException("Buffer size of " + n3 + " is too small for a read of " + n + " bytes");
        }
        if (this.available - n2 < n) {
            throw new IllegalStateException("Not enough data to read");
        }
        byteBuffer.put(this.databuf, this.skipped + n2, n);
    }

    HandshakeMessageInput readHandshakeMessage(int n) {
        if (n > this.available) {
            throw new IllegalStateException("Cannot read " + n + " bytes, only got " + this.available);
        }
        int n2 = this.skipped;
        this.available -= n;
        this.skipped += n;
        return new HandshakeMessageInput(this.databuf, n2, n);
    }

    public int readInt32() {
        if (this.available < 4) {
            throw new IllegalStateException("Not enough data to read");
        }
        return TlsUtils.readInt32(this.databuf, this.skipped);
    }

    public int readUint16(int n) {
        if (this.available < n + 2) {
            throw new IllegalStateException("Not enough data to read");
        }
        return TlsUtils.readUint16(this.databuf, this.skipped + n);
    }

    public void removeData(int n) {
        if (n > this.available) {
            throw new IllegalStateException("Cannot remove " + n + " bytes, only got " + this.available);
        }
        this.available -= n;
        this.skipped += n;
    }

    public void removeData(byte[] byArray, int n, int n2, int n3) {
        this.read(byArray, n, n2, n3);
        this.removeData(n3 + n2);
    }

    public void removeData(ByteBuffer byteBuffer, int n, int n2) {
        this.read(byteBuffer, n, n2);
        this.removeData(n2 + n);
    }

    public byte[] removeData(int n, int n2) {
        byte[] byArray = new byte[n];
        this.removeData(byArray, 0, n, n2);
        return byArray;
    }

    public void shrink() {
        if (this.available == 0) {
            this.databuf = TlsUtils.EMPTY_BYTES;
            this.skipped = 0;
        } else {
            int n = ByteQueue.nextTwoPow(this.available);
            if (n < this.databuf.length) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.databuf, this.skipped, byArray, 0, this.available);
                this.databuf = byArray;
                this.skipped = 0;
            }
        }
    }
}

