/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CertificateVerify;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.OfferedPsks;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPSK;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    OfferedPsks.BindersConfig clientBinders = null;
    protected ClientHello clientHello = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        tlsClient.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake(false);
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    protected void beginHandshake(boolean bl) throws IOException {
        super.beginHandshake(bl);
        this.sendClientHello();
        this.connection_state = 1;
    }

    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.clientAgreements = null;
        this.clientBinders = null;
        this.clientHello = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handle13HandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.receive13ServerCertificate(handshakeMessageInput);
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 13: {
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(10);
                    }
                    case 5: {
                        this.receive13CertificateRequest(handshakeMessageInput, false);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 7: {
                        this.receive13ServerCertificateVerify(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 8: {
                switch (this.connection_state) {
                    case 4: {
                        this.receive13EncryptedExtensions(handshakeMessageInput);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.skip13ServerCertificate();
                    }
                    case 9: {
                        this.receive13ServerFinished(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)20;
                        byte[] byArray = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        this.recordStream.setIgnoreChangeCipherSpec(false);
                        if (null != this.certificateRequest) {
                            TlsCredentialedSigner tlsCredentialedSigner = TlsUtils.establish13ClientCredentials(this.authentication, this.certificateRequest);
                            Certificate certificate = null;
                            if (null != tlsCredentialedSigner) {
                                certificate = tlsCredentialedSigner.getCertificate();
                            }
                            if (null == certificate) {
                                certificate = Certificate.EMPTY_CHAIN_TLS13;
                            }
                            this.send13CertificateMessage(certificate);
                            this.connection_state = (short)15;
                            if (null != tlsCredentialedSigner) {
                                DigitallySigned digitallySigned = TlsUtils.generate13CertificateVerify(this.tlsClientContext, tlsCredentialedSigner, this.handshakeHash);
                                this.send13CertificateVerifyMessage(digitallySigned);
                                this.connection_state = (short)17;
                            }
                        }
                        this.send13FinishedMessage();
                        this.connection_state = (short)18;
                        TlsUtils.establish13PhaseApplication(this.tlsClientContext, byArray, this.recordStream);
                        this.recordStream.enablePendingCipherWrite();
                        this.recordStream.enablePendingCipherRead(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                this.receive13KeyUpdate(handshakeMessageInput);
                break;
            }
            case 4: {
                this.receive13NewSessionTicket(handshakeMessageInput);
                break;
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        throw new TlsFatalAlert(80);
                    }
                    case 3: {
                        ServerHello serverHello = this.receiveServerHelloMessage(handshakeMessageInput);
                        if (serverHello.isHelloRetryRequest()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.process13ServerHello(serverHello, true);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        this.process13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleHandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            if (securityParameters.isResumedSession()) {
                throw new TlsFatalAlert(80);
            }
            this.handle13HandshakeMessage(s, handshakeMessageInput);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (securityParameters.isResumedSession()) {
            if (s != 20 || this.connection_state != 4) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(handshakeMessageInput);
            handshakeMessageInput.updateHash(this.handshakeHash);
            this.connection_state = (short)20;
            this.sendChangeCipherSpec();
            this.sendFinishedMessage();
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = TlsUtils.receiveServerCertificate(this.tlsClientContext, this.tlsClient, handshakeMessageInput, this.serverExtensions);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 7: {
                        if (securityParameters.getStatusRequestVersion() < 1) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(this.tlsClientContext, handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 18: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 19: {
                        this.processFinishedMessage(handshakeMessageInput);
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        ServerHello serverHello = this.receiveServerHelloMessage(handshakeMessageInput);
                        if (serverHello.isHelloRetryRequest()) {
                            this.process13HelloRetryRequest(serverHello);
                            this.handshakeHash.notifyPRFDetermined();
                            this.handshakeHash.sealHashAlgorithms();
                            TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                            handshakeMessageInput.updateHash(this.handshakeHash);
                            this.connection_state = (short)2;
                            this.send13ClientHelloRetry();
                            this.connection_state = (short)3;
                            break block0;
                        }
                        this.processServerHello(serverHello);
                        this.handshakeHash.notifyPRFDetermined();
                        if (TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
                            this.handshakeHash.sealHashAlgorithms();
                        }
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break block0;
                        this.process13ServerHelloCoda(serverHello, false);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(handshakeMessageInput));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: 
                    case 11: {
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.connection_state = (short)12;
                        TlsCredentials tlsCredentials = null;
                        TlsCredentialedSigner tlsCredentialedSigner = null;
                        Certificate certificate = null;
                        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                        TlsStreamSigner tlsStreamSigner = null;
                        if (this.certificateRequest != null && (tlsCredentials = TlsUtils.establishClientCredentials(this.authentication, this.certificateRequest)) != null) {
                            certificate = tlsCredentials.getCertificate();
                            if (tlsCredentials instanceof TlsCredentialedSigner) {
                                tlsCredentialedSigner = (TlsCredentialedSigner)tlsCredentials;
                                signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(securityParameters.getNegotiatedVersion(), tlsCredentialedSigner);
                                tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
                                if (ProtocolVersion.TLSv12.equals(securityParameters.getNegotiatedVersion())) {
                                    TlsUtils.verifySupportedSignatureAlgorithm(securityParameters.getServerSigAlgs(), signatureAndHashAlgorithm, (short)80);
                                    if (tlsStreamSigner == null) {
                                        TlsUtils.trackHashAlgorithmClient(this.handshakeHash, signatureAndHashAlgorithm);
                                    }
                                }
                                if (tlsStreamSigner != null) {
                                    this.handshakeHash.forceBuffering();
                                }
                            }
                        }
                        this.handshakeHash.sealHashAlgorithms();
                        if (tlsCredentials == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            this.keyExchange.processClientCredentials(tlsCredentials);
                        }
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                            this.connection_state = (short)14;
                        }
                        if (this.certificateRequest != null) {
                            this.sendCertificateMessage(certificate, null);
                            this.connection_state = (short)15;
                        }
                        this.sendClientKeyExchange();
                        this.connection_state = (short)16;
                        boolean bl = TlsUtils.isSSL(this.tlsClientContext);
                        if (bl) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        if (!bl) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
                        if (tlsCredentialedSigner != null) {
                            DigitallySigned digitallySigned = TlsUtils.generateCertificateVerifyClient(this.tlsClientContext, tlsCredentialedSigner, signatureAndHashAlgorithm, tlsStreamSigner, this.handshakeHash);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)17;
                        }
                        this.handshakeHash.stopTracking();
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)18;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)10;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: {
                        this.receiveCertificateRequest(handshakeMessageInput);
                        TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)11;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 18: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
                        this.invalidateSession();
                        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
                        this.receiveNewSessionTicket(handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)19;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(handshakeMessageInput);
                if (!this.isApplicationDataReady()) break;
                this.handleRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector vector) throws IOException {
        this.tlsClient.processServerSupplementalData(vector);
        this.connection_state = (short)6;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void process13HelloRetryRequest(ServerHello serverHello) throws IOException {
        ProtocolVersion protocolVersion = ProtocolVersion.TLSv12;
        this.recordStream.setWriteVersion(protocolVersion);
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            throw new TlsFatalAlert(80);
        }
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        byte[] byArray = serverHello.getSessionID();
        int n = serverHello.getCipherSuite();
        if (!(ProtocolVersion.TLSv12.equals(protocolVersion2) && Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])byArray) && TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), n))) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = serverHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.checkExtensionData13(hashtable, 6, (short)47);
        Object object = hashtable.keys();
        while (object.hasMoreElements()) {
            Integer n2 = (Integer)object.nextElement();
            if (44 == n2 || null != TlsUtils.getExtensionData(this.clientExtensions, n2)) continue;
            throw new TlsFatalAlert(110);
        }
        object = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == object) {
            throw new TlsFatalAlert(109);
        }
        if (!(ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf((ProtocolVersion)object) && ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), (ProtocolVersion)object) && TlsUtils.isValidVersionForCipherSuite(n, (ProtocolVersion)object))) {
            throw new TlsFatalAlert(47);
        }
        if (null != this.clientBinders && !Arrays.contains((short[])this.clientBinders.pskKeyExchangeModes, (short)1)) {
            this.clientBinders = null;
            this.tlsClient.notifySelectedPSK(null);
        }
        int n3 = TlsExtensionsUtils.getKeyShareHelloRetryRequest(hashtable);
        if (!TlsUtils.isValidKeyShareSelection((ProtocolVersion)object, securityParameters.getClientSupportedGroups(), this.clientAgreements, n3)) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsExtensionsUtils.getCookieExtension(hashtable);
        securityParameters.negotiatedVersion = object;
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        securityParameters.resumedSession = false;
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        this.tlsClient.notifySelectedCipherSuite(n);
        this.clientAgreements = null;
        this.retryCookie = byArray2;
        this.retryGroup = n3;
    }

    protected void process13ServerHello(ServerHello serverHello, boolean bl) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = serverHello.getVersion();
        byte[] byArray = serverHello.getSessionID();
        int n = serverHello.getCipherSuite();
        if (!ProtocolVersion.TLSv12.equals(protocolVersion) || !Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])byArray)) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = serverHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.checkExtensionData13(hashtable, 2, (short)47);
        if (bl) {
            object = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
            if (null == object) {
                throw new TlsFatalAlert(109);
            }
            if (!securityParameters.getNegotiatedVersion().equals((ProtocolVersion)object) || securityParameters.getCipherSuite() != n) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), n) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.resumedSession = false;
            securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
            this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
            TlsUtils.negotiatedCipherSuite(securityParameters, n);
            this.tlsClient.notifySelectedCipherSuite(n);
        }
        this.clientHello = null;
        securityParameters.serverRandom = serverHello.getRandom();
        securityParameters.secureRenegotiation = false;
        securityParameters.extendedMasterSecret = true;
        securityParameters.statusRequestVersion = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        object = null;
        int n2 = TlsExtensionsUtils.getPreSharedKeyServerHello(hashtable);
        Object object2 = null;
        if (n2 >= 0) {
            if (null == this.clientBinders || n2 >= this.clientBinders.psks.length) {
                throw new TlsFatalAlert(47);
            }
            object2 = this.clientBinders.psks[n2];
            if (object2.getPRFAlgorithm() != securityParameters.getPRFAlgorithm()) {
                throw new TlsFatalAlert(47);
            }
            object = this.clientBinders.earlySecrets[n2];
            this.selectedPSK13 = true;
        }
        this.tlsClient.notifySelectedPSK((TlsPSK)object2);
        TlsSecret tlsSecret = null;
        object2 = TlsExtensionsUtils.getKeyShareServerHello(hashtable);
        if (null == object2) {
            if (bl || null == object || !Arrays.contains((short[])this.clientBinders.pskKeyExchangeModes, (short)0)) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (null != object && !Arrays.contains((short[])this.clientBinders.pskKeyExchangeModes, (short)1)) {
                throw new TlsFatalAlert(47);
            }
            int n3 = ((KeyShareEntry)object2).getNamedGroup();
            TlsAgreement tlsAgreement = (TlsAgreement)this.clientAgreements.get(Integers.valueOf((int)n3));
            if (null == tlsAgreement) {
                throw new TlsFatalAlert(47);
            }
            tlsAgreement.receivePeerValue(((KeyShareEntry)object2).getKeyExchange());
            tlsSecret = tlsAgreement.calculateSecret();
        }
        this.clientAgreements = null;
        this.clientBinders = null;
        TlsUtils.establish13PhaseSecrets(this.tlsClientContext, (TlsSecret)object, tlsSecret);
        this.invalidateSession();
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
    }

    protected void process13ServerHelloCoda(ServerHello serverHello, boolean bl) throws IOException {
        byte[] byArray = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseHandshake(this.tlsClientContext, byArray, this.recordStream);
        if (!bl) {
            this.recordStream.setIgnoreChangeCipherSpec(true);
            this.sendChangeCipherSpecMessage();
        }
        this.recordStream.enablePendingCipherWrite();
        this.recordStream.enablePendingCipherRead(false);
    }

    protected void processServerHello(ServerHello serverHello) throws IOException {
        Object object;
        Object object2;
        ProtocolVersion protocolVersion;
        Hashtable hashtable = serverHello.getExtensions();
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        ProtocolVersion protocolVersion3 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == protocolVersion3) {
            protocolVersion = protocolVersion2;
        } else {
            if (!ProtocolVersion.TLSv12.equals(protocolVersion2) || !ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion3)) {
                throw new TlsFatalAlert(47);
            }
            protocolVersion = protocolVersion3;
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            if (!protocolVersion.equals(securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), protocolVersion)) {
                throw new TlsFatalAlert(70);
            }
            object2 = protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : protocolVersion;
            this.recordStream.setWriteVersion((ProtocolVersion)object2);
            securityParameters.negotiatedVersion = protocolVersion;
        }
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            this.process13ServerHello(serverHello, false);
            return;
        }
        object2 = this.clientHello.getCipherSuites();
        this.clientHello = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        securityParameters.serverRandom = serverHello.getRandom();
        if (!this.tlsClientContext.getClientVersion().equals(protocolVersion)) {
            TlsUtils.checkDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        byte[] byArray = serverHello.getSessionID();
        securityParameters.sessionID = byArray;
        this.tlsClient.notifySessionID(byArray);
        securityParameters.resumedSession = byArray.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])byArray, (byte[])this.tlsSession.getSessionID());
        int n = serverHello.getCipherSuite();
        if (!TlsUtils.isValidCipherSuiteSelection((int[])object2, n) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        this.tlsClient.notifySelectedCipherSuite(n);
        this.serverExtensions = hashtable;
        if (this.serverExtensions != null) {
            Enumeration enumeration = this.serverExtensions.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                if (((Integer)object).equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, (Integer)object)) {
                    throw new TlsFatalAlert(110);
                }
                if (!securityParameters.isResumedSession()) continue;
            }
        }
        byte[] byArray2 = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo);
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            if (byArray2 == null) {
                throw new TlsFatalAlert(40);
            }
            object = this.tlsClientContext.getSecurityParametersConnection();
            byte[] byArray3 = TlsUtils.concat(((SecurityParameters)object).getLocalVerifyData(), ((SecurityParameters)object).getPeerVerifyData());
            if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])TlsClientProtocol.createRenegotiationInfo(byArray3))) {
                throw new TlsFatalAlert(40);
            }
        } else if (byArray2 == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.serverExtensions);
        boolean bl2 = securityParameters.isResumedSession();
        if (bl ? protocolVersion.isSSL() || !bl2 && !this.tlsClient.shouldUseExtendedMasterSecret() : this.tlsClient.requiresExtendedMasterSecret() || bl2 && !this.tlsClient.allowLegacyResumption()) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = bl;
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable hashtable2 = this.clientExtensions;
        Hashtable hashtable3 = this.serverExtensions;
        if (securityParameters.isResumedSession()) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !protocolVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            hashtable2 = null;
            hashtable3 = this.sessionParameters.readServerExtensions();
        }
        if (hashtable3 != null && !hashtable3.isEmpty()) {
            boolean bl3 = TlsExtensionsUtils.hasEncryptThenMACExtension(hashtable3);
            if (bl3 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl3;
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(hashtable2, hashtable3, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(hashtable3);
            if (!securityParameters.isResumedSession()) {
                if (TlsUtils.hasExpectedEmptyExtensionData(hashtable3, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(hashtable3, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.statusRequestVersion = 1;
                }
                this.expectSessionTicket = TlsUtils.hasExpectedEmptyExtensionData(hashtable3, TlsProtocol.EXT_SessionTicket, (short)47);
            }
        }
        if (hashtable2 != null) {
            this.tlsClient.processServerExtensions(hashtable3);
        }
        this.applyMaxFragmentLengthExtension(securityParameters.getMaxFragmentLength());
        if (securityParameters.isResumedSession()) {
            securityParameters.masterSecret = this.sessionMasterSecret;
            this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
        } else {
            this.invalidateSession();
            this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        }
    }

    protected void receive13CertificateRequest(ByteArrayInputStream byteArrayInputStream, boolean bl) throws IOException {
        if (bl) {
            throw new TlsFatalAlert(80);
        }
        if (this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        if (!certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
            throw new TlsFatalAlert(47);
        }
        this.certificateRequest = certificateRequest;
        this.tlsClientContext.getSecurityParametersHandshake().clientCertificateType = TlsExtensionsUtils.getClientCertificateTypeExtensionServer(this.serverExtensions, (short)0);
        TlsUtils.establishServerSigAlgs(this.tlsClientContext.getSecurityParametersHandshake(), certificateRequest);
    }

    protected void receive13EncryptedExtensions(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Object object;
        byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.serverExtensions = TlsClientProtocol.readExtensionsData13(8, byArray);
        Object object2 = this.serverExtensions.keys();
        while (object2.hasMoreElements()) {
            object = (Integer)object2.nextElement();
            if (null != TlsUtils.getExtensionData(this.clientExtensions, (Integer)object)) continue;
            throw new TlsFatalAlert(110);
        }
        object2 = this.tlsClientContext.getSecurityParametersHandshake();
        object = ((SecurityParameters)object2).getNegotiatedVersion();
        ((SecurityParameters)object2).applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        ((SecurityParameters)object2).applicationProtocolSet = true;
        Hashtable hashtable = this.clientExtensions;
        Hashtable hashtable2 = this.serverExtensions;
        if (((SecurityParameters)object2).isResumedSession()) {
            if (((SecurityParameters)object2).getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !((ProtocolVersion)object).equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            hashtable = null;
            hashtable2 = this.sessionParameters.readServerExtensions();
        }
        ((SecurityParameters)object2).maxFragmentLength = this.processMaxFragmentLengthExtension(hashtable, hashtable2, (short)47);
        ((SecurityParameters)object2).encryptThenMAC = false;
        ((SecurityParameters)object2).truncatedHMac = false;
        ((SecurityParameters)object2).statusRequestVersion = this.clientExtensions.containsKey(TlsExtensionsUtils.EXT_status_request) ? 1 : 0;
        this.expectSessionTicket = false;
        if (null != hashtable) {
            this.tlsClient.processServerExtensions(this.serverExtensions);
        }
        this.applyMaxFragmentLengthExtension(((SecurityParameters)object2).getMaxFragmentLength());
    }

    protected void receive13NewSessionTicket(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (!this.isApplicationDataReady()) {
            throw new TlsFatalAlert(10);
        }
        TlsUtils.readUint32(byteArrayInputStream);
        TlsUtils.readUint32(byteArrayInputStream);
        TlsUtils.readOpaque8(byteArrayInputStream);
        TlsUtils.readOpaque16(byteArrayInputStream);
        TlsUtils.readOpaque16(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void receive13ServerCertificate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        this.authentication = TlsUtils.receive13ServerCertificate(this.tlsClientContext, this.tlsClient, byteArrayInputStream, this.serverExtensions);
        this.handleServerCertificate();
    }

    protected void receive13ServerCertificateVerify(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = this.tlsClientContext.getSecurityParametersHandshake().getPeerCertificate();
        if (null == certificate || certificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        CertificateVerify certificateVerify = CertificateVerify.parse(this.tlsClientContext, byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verify13CertificateVerifyServer(this.tlsClientContext, this.handshakeHash, certificateVerify);
    }

    protected void receive13ServerFinished(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.process13FinishedMessage(byteArrayInputStream);
    }

    protected void receiveCertificateRequest(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (null == this.authentication) {
            throw new TlsFatalAlert(40);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.certificateRequest = TlsUtils.validateCertificateRequest(certificateRequest, this.keyExchange);
        this.tlsClientContext.getSecurityParametersHandshake().clientCertificateType = TlsExtensionsUtils.getClientCertificateTypeExtensionServer(this.serverExtensions, (short)0);
    }

    protected void receiveNewSessionTicket(ByteArrayInputStream byteArrayInputStream) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected ServerHello receiveServerHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return ServerHello.parse(byteArrayInputStream);
    }

    protected void send13ClientHelloRetry() throws IOException {
        Hashtable hashtable = this.clientHello.getExtensions();
        hashtable.remove(TlsExtensionsUtils.EXT_cookie);
        hashtable.remove(TlsExtensionsUtils.EXT_early_data);
        hashtable.remove(TlsExtensionsUtils.EXT_key_share);
        hashtable.remove(TlsExtensionsUtils.EXT_pre_shared_key);
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(hashtable, this.retryCookie);
            this.retryCookie = null;
        }
        if (null != this.clientBinders) {
            this.clientBinders = TlsUtils.addPreSharedKeyToClientHelloRetry(this.tlsClientContext, this.clientBinders, hashtable);
            if (null == this.clientBinders) {
                this.tlsClient.notifySelectedPSK(null);
            }
        }
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        this.clientAgreements = TlsUtils.addKeyShareToClientHelloRetry(this.tlsClientContext, hashtable, this.retryGroup);
        this.recordStream.setIgnoreChangeCipherSpec(true);
        this.sendChangeCipherSpecMessage();
        this.sendClientHelloMessage();
    }

    protected void sendCertificateVerifyMessage(DigitallySigned digitallySigned) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(15);
        digitallySigned.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendClientHello() throws IOException {
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2;
        ProtocolVersion[] protocolVersionArray;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (securityParameters.isRenegotiating()) {
            ProtocolVersion protocolVersion3 = this.tlsClientContext.getClientVersion();
            protocolVersionArray = protocolVersion3.only();
            protocolVersion2 = protocolVersion3;
            protocolVersion = protocolVersion3;
        } else {
            protocolVersionArray = this.tlsClient.getProtocolVersions();
            if (ProtocolVersion.contains(protocolVersionArray, ProtocolVersion.SSLv3)) {
                this.recordStream.setWriteVersion(ProtocolVersion.SSLv3);
            } else {
                this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
            }
            protocolVersion2 = ProtocolVersion.getEarliestTLS(protocolVersionArray);
            protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
            if (!ProtocolVersion.isSupportedTLSVersionClient(protocolVersion)) {
                throw new TlsFatalAlert(80);
            }
            this.tlsClientContext.setClientVersion(protocolVersion);
        }
        this.tlsClientContext.setClientSupportedVersions(protocolVersionArray);
        boolean bl = ProtocolVersion.TLSv12.isEqualOrLaterVersionOf(protocolVersion2);
        boolean bl2 = ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion);
        boolean bl3 = !bl2 && this.tlsClient.shouldUseGMTUnixTime();
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(bl3, this.tlsClientContext);
        this.establishSession(bl ? this.tlsClient.getSessionToResume() : null);
        this.tlsClient.notifySessionToResume(this.tlsSession);
        byte[] byArray = TlsUtils.getSessionID(this.tlsSession);
        boolean bl4 = this.tlsClient.isFallback();
        int[] nArray = this.tlsClient.getCipherSuites();
        if (!(byArray.length <= 0 || this.sessionParameters == null || Arrays.contains((int[])nArray, (int)this.sessionParameters.getCipherSuite()) && 0 == this.sessionParameters.getCompressionAlgorithm())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        ProtocolVersion protocolVersion4 = protocolVersion;
        if (bl2) {
            protocolVersion4 = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, protocolVersionArray);
            if (byArray.length < 1) {
                byArray = this.tlsClientContext.getNonceGenerator().generateNonce(32);
            }
        }
        this.tlsClientContext.setRSAPreMasterSecretVersion(protocolVersion4);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.clientBinders = TlsUtils.addPreSharedKeyToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions, nArray);
        this.clientAgreements = TlsUtils.addKeyShareToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions);
        if (TlsUtils.isExtendedMasterSecretOptionalTLS(protocolVersionArray) && (this.tlsClient.shouldUseExtendedMasterSecret() || null != this.sessionParameters && this.sessionParameters.isExtendedMasterSecret())) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        } else if (!bl2 && this.tlsClient.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(80);
        }
        if (securityParameters.isRenegotiating()) {
            if (!securityParameters.isSecureRenegotiation()) {
                throw new TlsFatalAlert(80);
            }
            SecurityParameters securityParameters2 = this.tlsClientContext.getSecurityParametersConnection();
            this.clientExtensions.put(EXT_RenegotiationInfo, TlsClientProtocol.createRenegotiationInfo(securityParameters2.getLocalVerifyData()));
        } else {
            boolean bl5;
            boolean bl6 = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
            boolean bl7 = bl5 = !Arrays.contains((int[])nArray, (int)255);
            if (bl6 && bl5) {
                nArray = Arrays.append((int[])nArray, (int)255);
            }
        }
        if (bl4 && !Arrays.contains((int[])nArray, (int)22016)) {
            nArray = Arrays.append((int[])nArray, (int)22016);
        }
        int n = null == this.clientBinders ? 0 : this.clientBinders.bindersSize;
        this.clientHello = new ClientHello(protocolVersion4, securityParameters.getClientRandom(), byArray, null, nArray, this.clientExtensions, n);
        this.sendClientHelloMessage();
    }

    protected void sendClientHelloMessage() throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(1);
        this.clientHello.encode(this.tlsClientContext, handshakeMessageOutput);
        handshakeMessageOutput.prepareClientHello(this.handshakeHash, this.clientHello.getBindersSize());
        if (null != this.clientBinders) {
            OfferedPsks.encodeBinders(handshakeMessageOutput, this.tlsClientContext.getCrypto(), this.handshakeHash, this.clientBinders);
        }
        handshakeMessageOutput.sendClientHello(this, this.handshakeHash, this.clientHello.getBindersSize());
    }

    protected void sendClientKeyExchange() throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(16);
        this.keyExchange.generateClientKeyExchange(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void skip13CertificateRequest() throws IOException {
        this.certificateRequest = null;
    }

    protected void skip13ServerCertificate() throws IOException {
        if (!this.selectedPSK13) {
            throw new TlsFatalAlert(10);
        }
        this.authentication = TlsUtils.skip13ServerCertificate(this.tlsClientContext);
    }
}

