/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRawKeyCertificate;
import org.bouncycastle.util.Arrays;

public class BcTlsCertificate
extends BcTlsRawKeyCertificate {
    protected final Certificate certificate;

    public static BcTlsCertificate convert(BcTlsCrypto bcTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        if (tlsCertificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)tlsCertificate;
        }
        return new BcTlsCertificate(bcTlsCrypto, tlsCertificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] byArray) throws IOException {
        try {
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
            return Certificate.getInstance((Object)aSN1Primitive);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TlsFatalAlert(42, (Throwable)illegalArgumentException);
        }
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, byte[] byArray) throws IOException {
        this(bcTlsCrypto, BcTlsCertificate.parseCertificate(byArray));
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, Certificate certificate) {
        super(bcTlsCrypto, certificate.getSubjectPublicKeyInfo());
        this.certificate = certificate;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    public byte[] getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(aSN1ObjectIdentifier)) != null) {
            return Arrays.clone((byte[])extension.getExtnValue().getOctets());
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public ASN1Encodable getSigAlgParams() {
        return this.certificate.getSignatureAlgorithm().getParameters();
    }

    protected boolean supportsKeyUsage(int n) {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        return extensions == null || (keyUsage = KeyUsage.fromExtensions((Extensions)extensions)) == null || ((n2 = keyUsage.getBytes()[0] & 0xFF) & n) == n;
    }

    public void validateKeyUsage(int n) throws IOException {
        if (!this.supportsKeyUsage(n)) {
            throw new TlsFatalAlert(46);
        }
    }
}

