/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;

public class PurgeMessageChannelAction
extends AbstractTestAction {
    private final List<String> channelNames;
    private final List<MessageChannel> channels;
    private final DestinationResolver<MessageChannel> channelResolver;
    private final MessageSelector messageSelector;
    private static final Logger logger = LoggerFactory.getLogger(PurgeMessageChannelAction.class);

    public PurgeMessageChannelAction(Builder builder) {
        super("purge-channel", (AbstractTestActionBuilder)builder);
        this.channelNames = builder.channelNames;
        this.channels = builder.channels;
        this.channelResolver = builder.channelResolver;
        this.messageSelector = builder.messageSelector;
    }

    public void doExecute(TestContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Purging message channels ...");
        }
        for (MessageChannel channel : this.channels) {
            this.purgeChannel(channel);
        }
        for (String channelName : this.channelNames) {
            this.purgeChannel(this.resolveChannelName(channelName));
        }
        logger.info("Purged message channels");
    }

    private void purgeChannel(MessageChannel channel) {
        if (channel instanceof QueueChannel) {
            List messages = ((QueueChannel)channel).purge(this.messageSelector);
            if (logger.isDebugEnabled()) {
                logger.debug("Purged channel " + ((QueueChannel)channel).getComponentName() + " - removed " + messages.size() + " messages");
            }
        }
    }

    protected MessageChannel resolveChannelName(String channelName) {
        return (MessageChannel)this.channelResolver.resolveDestination(channelName);
    }

    public List<String> getChannelNames() {
        return this.channelNames;
    }

    public List<MessageChannel> getChannels() {
        return this.channels;
    }

    public MessageSelector getMessageSelector() {
        return this.messageSelector;
    }

    public DestinationResolver<MessageChannel> getChannelResolver() {
        return this.channelResolver;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<PurgeMessageChannelAction, Builder>
    implements ReferenceResolverAware {
        private final List<String> channelNames = new ArrayList<String>();
        private final List<MessageChannel> channels = new ArrayList<MessageChannel>();
        private BeanFactory beanFactory;
        private DestinationResolver<MessageChannel> channelResolver;
        private MessageSelector messageSelector = new AllAcceptingMessageSelector();
        private ReferenceResolver referenceResolver;

        public static Builder purgeChannels() {
            return new Builder();
        }

        public Builder selector(MessageSelector messageSelector) {
            this.messageSelector = messageSelector;
            return this;
        }

        public Builder channelResolver(ReferenceResolver referenceResolver) {
            this.channelResolver = channelName -> (MessageChannel)referenceResolver.resolve(channelName, MessageChannel.class);
            return this;
        }

        public Builder channelResolver(DestinationResolver<MessageChannel> channelResolver) {
            this.channelResolver = channelResolver;
            return this;
        }

        public Builder channelNames(List<String> channelNames) {
            this.channelNames.addAll(channelNames);
            return this;
        }

        public Builder channelNames(String ... channelNames) {
            return this.channelNames(Arrays.asList(channelNames));
        }

        public Builder channel(String name) {
            this.channelNames.add(name);
            return this;
        }

        public Builder channels(List<MessageChannel> channels) {
            this.channels.addAll(channels);
            return this;
        }

        public Builder channels(MessageChannel ... channels) {
            return this.channels(Arrays.asList(channels));
        }

        public Builder channel(MessageChannel channel) {
            this.channels.add(channel);
            return this;
        }

        public Builder withApplicationContext(ApplicationContext applicationContext) {
            this.beanFactory = applicationContext;
            return this;
        }

        public Builder beanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public PurgeMessageChannelAction build() {
            if (this.channelResolver == null) {
                if (this.beanFactory != null) {
                    this.channelResolver = new BeanFactoryChannelResolver(this.beanFactory);
                } else if (!this.channelNames.isEmpty() && this.referenceResolver != null) {
                    this.channelResolver = channelName -> (MessageChannel)this.referenceResolver.resolve(channelName, MessageChannel.class);
                }
            }
            return new PurgeMessageChannelAction(this);
        }
    }

    public static final class AllAcceptingMessageSelector
    implements MessageSelector {
        public boolean accept(Message<?> message) {
            return false;
        }
    }
}

