/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.channel.selector;

import org.citrusframework.channel.selector.AbstractMessageSelector;
import org.citrusframework.channel.selector.MessageSelectorFactory;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.JsonPathUtils;
import org.citrusframework.util.StringUtils;
import org.springframework.messaging.Message;

public class JsonPathPayloadMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_PREFIX = "jsonPath:";

    public JsonPathPayloadMessageSelector(String expression, String control, TestContext context) {
        super(expression.substring(SELECTOR_PREFIX.length()), control, context);
    }

    public boolean accept(Message<?> message) {
        String payload = this.getPayloadAsString(message);
        if (StringUtils.hasText((String)payload) && !payload.trim().startsWith("{") && !payload.trim().startsWith("[")) {
            return false;
        }
        try {
            return this.evaluate(JsonPathUtils.evaluateAsString((String)payload, (String)this.selectKey));
        }
        catch (CitrusRuntimeException e) {
            return false;
        }
    }

    public static class Factory
    implements MessageSelectorFactory<JsonPathPayloadMessageSelector> {
        @Override
        public boolean supports(String key) {
            return key.startsWith(JsonPathPayloadMessageSelector.SELECTOR_PREFIX);
        }

        @Override
        public JsonPathPayloadMessageSelector create(String key, String value, TestContext context) {
            return new JsonPathPayloadMessageSelector(key, value, context);
        }
    }
}

