/**********************************************************************
Copyright (c) 2010 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
   ...
**********************************************************************/
package org.datanucleus.store.rdbms.datasource;

import org.datanucleus.ClassLoaderResolver;

/**
 * Abstract superclass for data source factory.
 */
public abstract class AbstractDataSourceFactory
{
    /**
     * Convenience method to load the driver.
     * @param dbDriver Datastore driver
     * @param clr Class loader resolver
     */
    protected void loadDriver(String dbDriver, ClassLoaderResolver clr)
    {
        // Load the database driver
        try
        {
            clr.classForName(dbDriver).newInstance();
        }
        catch (Exception e)
        {
            try
            {
                Class.forName(dbDriver).newInstance();
            }
            catch (Exception e2)
            {
                // JDBC driver not found
                throw new DatastoreDriverNotFoundException(dbDriver);
            }
        }
    }
}