/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public final class DatastoreMappingFactory {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    private static Map mappingConstructors = new HashMap();
    private static final Class[] ctr_args_classes = new Class[]{JavaTypeMapping.class, RDBMSStoreManager.class, Column.class};

    private DatastoreMappingFactory() {
    }

    public static DatastoreMapping createMapping(Class mappingClass, JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column column) {
        Object obj = null;
        try {
            Object[] args = new Object[]{mapping, storeMgr, column};
            Constructor ctr = (Constructor)mappingConstructors.get(mappingClass);
            if (ctr == null) {
                ctr = mappingClass.getConstructor(ctr_args_classes);
                mappingConstructors.put(mappingClass, ctr);
            }
            try {
                obj = ctr.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e.getTargetException()), e.getTargetException()).setFatal();
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER.msg("041009", (Object)mappingClass.getName(), (Object)e), (Throwable)e).setFatal();
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new NucleusException(LOCALISER.msg("041007", JavaTypeMapping.class, RDBMSStoreManager.class, Column.class, (Object)mappingClass.getName())).setFatal();
        }
        return obj;
    }
}

