/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.exceptions.ReachableObjectNotCascadedException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.types.SCO;
import org.datanucleus.store.types.SCOContainer;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.wrappers.backed.BackedSCO;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    @Override
    public Class getJavaType() {
        return Map.class;
    }

    @Override
    public void insertPostProcessing(ObjectProvider ownerOP) {
    }

    @Override
    public void postInsert(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        Map value = (Map)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.keySet());
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(ownerOP, null, false, false);
            return;
        }
        if (!this.mmd.isCascadePersist()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007006", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            ApiAdapter api = ec.getApiAdapter();
            Set entries = value.entrySet();
            for (Map.Entry entry : entries) {
                if (api.isPersistable(entry.getKey()) && !api.isPersistent(entry.getKey()) && !api.isDetached(entry.getKey())) {
                    throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || api.isPersistent(entry.getValue()) || api.isDetached(entry.getValue())) continue;
                throw new ReachableObjectNotCascadedException(this.mmd.getFullFieldName(), entry.getValue());
            }
            this.replaceFieldWithWrapper(ownerOP, value, false, false);
        } else {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007007", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            if (value.size() > 0) {
                RDBMSStoreManager storeMgr = this.table.getStoreManager();
                ((MapStore)storeMgr.getBackingStoreForField(ownerOP.getExecutionContext().getClassLoaderResolver(), this.mmd, value.getClass())).putAll(ownerOP, value);
                this.replaceFieldWithWrapper(ownerOP, value, false, false);
                ec.flushInternal(true);
            } else if (this.mmd.getRelationType(ownerOP.getExecutionContext().getClassLoaderResolver()) == RelationType.MANY_TO_MANY_BI) {
                this.replaceFieldWithWrapper(ownerOP, null, false, false);
            } else {
                this.replaceFieldWithWrapper(ownerOP, value, false, false);
            }
        }
    }

    @Override
    public void postUpdate(ObjectProvider ownerOP) {
        ExecutionContext ec = ownerOP.getExecutionContext();
        RDBMSStoreManager storeMgr = this.table.getStoreManager();
        Map value = (Map)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.keySet());
                SCOUtils.validateObjectsForWriting((ExecutionContext)ec, value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(ownerOP, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)value;
            if (ownerOP.getObject() == sco.getOwner() && this.mmd.getName().equals(sco.getFieldName())) {
                ownerOP.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)sco).getBackingStore(), ownerOP);
                return;
            }
            if (sco.getOwner() != null) {
                throw new NucleusException("Owned second-class object was somehow assigned to a field other than its owner's").setFatal();
            }
        }
        if (!this.mmd.isCascadeUpdate()) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007008", (Object[])new Object[]{this.mmd.getFullFieldName()}));
            }
            return;
        }
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)Localiser.msg((String)"007009", (Object[])new Object[]{this.mmd.getFullFieldName()}));
        }
        MapStore store = (MapStore)storeMgr.getBackingStoreForField(ec.getClassLoaderResolver(), this.mmd, value.getClass());
        store.clear(ownerOP);
        store.putAll(ownerOP, value);
        this.replaceFieldWithWrapper(ownerOP, value, false, false);
    }

    @Override
    public void preDelete(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        ownerOP.isLoaded(this.getAbsoluteFieldNumber());
        Map value = (Map)ownerOP.provideField(this.getAbsoluteFieldNumber());
        if (value != null) {
            if (!(value instanceof SCO)) {
                value = (Map)ownerOP.wrapSCOField(this.mmd.getAbsoluteFieldNumber(), (Object)value, false, false, true);
            }
            value.clear();
            ownerOP.getExecutionContext().flushOperationsForBackingStore(((BackedSCO)value).getBackingStore(), ownerOP);
        }
    }
}

