/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKListStore
extends AbstractListStore {
    private final int ownerFieldNumber;
    private String updateFkStmt;
    private String clearNullifyStmt;
    private String removeAtNullifyStmt;
    private String setStmt;
    private String unsetStmt;

    public FKListStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
        this.setOwner(mmd);
        CollectionMetaData colmd = mmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056001", (Object[])new Object[]{mmd.getFullFieldName()}));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(Localiser.msg((String)"056003", (Object[])new Object[]{element_class.getName(), mmd.getFullFieldName()}));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo.length > 1) {
            throw new NucleusUserException(Localiser.msg((String)"056031", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName()}));
        }
        if (this.elementInfo.length == 0) {
            throw new NucleusUserException(Localiser.msg((String)"056075", (Object[])new Object[]{this.ownerMemberMetaData.getFullFieldName(), this.elementType}));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = mmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(mappedByFieldName);
            if (eofmd == null) {
                throw new NucleusUserException(Localiser.msg((String)"056024", (Object[])new Object[]{mmd.getFullFieldName(), mappedByFieldName, element_class.getName()}));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(Localiser.msg((String)"056025", (Object[])new Object[]{mmd.getFullFieldName(), eofmd.getFullFieldName(), eofmd.getTypeName(), mmd.getAbstractClassMetaData().getFullClassName()}));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(Localiser.msg((String)"056029", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType, ownerFieldName}));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(Localiser.msg((String)"056026", (Object[])new Object[]{ownerFieldName, this.elementType, eofmd.getTypeName(), mmd.getClassName()}));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(Localiser.msg((String)"056030", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType}));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 4);
        if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(Localiser.msg((String)"056041", (Object[])new Object[]{mmd.getAbstractClassMetaData().getFullClassName(), mmd.getName(), this.elementType}));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = mmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (mmd.getMappedBy() != null && this.ownerMapping.getTable() != this.containerTable) {
            this.containerTable = this.ownerMapping.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(ObjectProvider op, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(op, element, -1);
        Object oldElement = this.get(op, index);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                String unsetStmt = this.getUnsetStmt();
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, unsetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    if (this.orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, unsetStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
                String setStmt = this.getSetStmt(element);
                try (PreparedStatement ps2 = sqlControl.getStatementForUpdate(mconn, setStmt, false);){
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps2, jdbcPosition, this);
                    if (this.orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps2, index, jdbcPosition, this.orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps2, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps2, element, jdbcPosition, this.elementMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, setStmt, ps2, true);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056015", (Object[])new Object[]{this.setStmt}), (Throwable)e);
        }
        boolean dependent = this.getOwnerMemberMetaData().getCollection().isDependentElement();
        if (this.getOwnerMemberMetaData().isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && allowDependentField && oldElement != null) {
            op.getExecutionContext().deleteObjectInternal(oldElement);
        }
        return oldElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(ObjectProvider op, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        ExecutionContext ec = op.getExecutionContext();
        JavaTypeMapping ownerMapping = this.getOwnerMapping();
        JavaTypeMapping orderMapping = this.getOrderMapping();
        JavaTypeMapping elementMapping = this.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = this.getElementInfo();
        JavaTypeMapping relationDiscriminatorMapping = this.getRelationDiscriminatorMapping();
        AbstractMemberMetaData ownerMemberMetaData = this.getOwnerMemberMetaData();
        String updateFkStmt = this.getUpdateFkStmt(element);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (elementInfo.length > 1) {
                        this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    }
                    if (owner == null) {
                        if (ownerMemberMetaData != null) {
                            ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, ownerMapping), null, op, ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            ownerMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, ownerMapping), null);
                        }
                        jdbcPosition += ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    }
                    if (orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, orderMapping);
                    }
                    if (relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, elementMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056027", (Object[])new Object[]{updateFkStmt}), (Throwable)e);
        }
        return retval;
    }

    @Override
    public void update(ObjectProvider op, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(op);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(op);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(op, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.equals(coll)) {
            return;
        }
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internalAdd(ObjectProvider op, int startAt, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(op) : size;
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(op, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                int shift = c.size();
                ExecutionContext ec = op.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    for (int i = currentListSize - 1; i >= startAt; --i) {
                        this.internalShift(op, mconn, true, i, shift, false);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056009", (Object[])new Object[]{e.getMessage()}), e.getCause());
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            for (Object element : c) {
                this.updateElementFk(op, element, op.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    @Override
    protected boolean internalRemove(ObjectProvider op, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(op, element);
            if (index == -1) {
                return false;
            }
            this.internalRemoveAt(op, index, size);
        } else if (this.ownerMapping.isNullable()) {
            ExecutionContext ec = op.getExecutionContext();
            ObjectProvider elementSM = ec.findObjectProvider(element);
            if (this.relationType == RelationType.ONE_TO_MANY_BI) {
                elementSM.replaceFieldMakeDirty(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null);
                if (op.getExecutionContext().isFlushing()) {
                    elementSM.flush();
                }
            } else {
                this.updateElementFk(op, element, null, -1);
            }
        } else {
            op.getExecutionContext().deleteObjectInternal(element);
        }
        return true;
    }

    protected void manageRemovalOfElement(ObjectProvider ownerOP, Object element) {
    }

    @Override
    protected void internalRemoveAt(ObjectProvider op, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        boolean nullify = false;
        if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056043"));
            nullify = true;
        } else {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056042"));
        }
        String stmt = nullify ? this.getRemoveAtNullifyStmt() : this.getRemoveAtStmt();
        this.internalRemoveAt(op, index, stmt, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(ObjectProvider op) {
        boolean deleteElements = false;
        ExecutionContext ec = op.getExecutionContext();
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056036"));
            deleteElements = false;
        } else if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)Localiser.msg((String)"056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            Iterator elementsIter = this.iterator(op);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                        ObjectProvider objSM = ec.findObjectProvider(element);
                        objSM.flush();
                        continue;
                    }
                    ec.deleteObjectInternal(element);
                }
            }
        } else {
            String clearNullifyStmt = this.getClearNullifyStmt();
            try {
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                SQLController sqlControl = this.storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        if (this.getRelationDiscriminatorMapping() != null) {
                            BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                        sqlControl.executeStatementUpdate(ec, mconn, clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{clearNullifyStmt}), (Throwable)e);
            }
        }
    }

    protected boolean validateElementForWriting(final ObjectProvider op, Object element, final int index) {
        final Object newOwner = op.getObject();
        boolean inserted = super.validateElementForWriting(op.getExecutionContext(), element, new FieldValues(){

            public void fetchFields(ObjectProvider esm) {
                AbstractClassMetaData[] managingCmds;
                boolean isPersistentInterface = FKListStore.this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(FKListStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.storeMgr.getNucleusContext().getMetaDataManager().getImplementationNameForPersistentInterface(FKListStore.this.elementType), FKListStore.this.clr) : FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.elementType, FKListStore.this.clr);
                if (elementTable == null && (managingCmds = FKListStore.this.storeMgr.getClassesManagingTableForClass(FKListStore.this.emd, FKListStore.this.clr)) != null && managingCmds.length > 0) {
                    for (int i = 0; i < managingCmds.length; ++i) {
                        Class tblCls = FKListStore.this.clr.classForName(managingCmds[i].getFullClassName());
                        if (!tblCls.isAssignableFrom(esm.getObject().getClass())) continue;
                        elementTable = FKListStore.this.storeMgr.getDatastoreClass(managingCmds[i].getFullClassName(), FKListStore.this.clr);
                        break;
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setAssociatedValue((Object)externalFKMapping, op.getObject());
                    }
                    if (FKListStore.this.relationDiscriminatorMapping != null) {
                        esm.setAssociatedValue((Object)FKListStore.this.relationDiscriminatorMapping, (Object)FKListStore.this.relationDiscriminatorValue);
                    }
                    if (FKListStore.this.orderMapping != null && index >= 0) {
                        if (FKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && FKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = FKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || FKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)Long.valueOf(index) : (Number)index;
                            esm.replaceFieldMakeDirty(FKListStore.this.orderMapping.getMemberMetaData().getAbsoluteFieldNumber(), (Object)indexValue);
                        } else {
                            esm.setAssociatedValue((Object)FKListStore.this.orderMapping, (Object)index);
                        }
                    }
                }
                if (FKListStore.this.ownerFieldNumber >= 0) {
                    Object currentOwner = esm.provideField(FKListStore.this.ownerFieldNumber);
                    if (currentOwner == null) {
                        NucleusLogger.PERSISTENCE.info((Object)Localiser.msg((String)"056037", (Object[])new Object[]{op.getObjectAsPrintable(), FKListStore.this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)esm.getObject())}));
                        esm.replaceFieldMakeDirty(FKListStore.this.ownerFieldNumber, newOwner);
                    } else if (currentOwner != newOwner && op.getReferencedPC() == null) {
                        throw new NucleusUserException(Localiser.msg((String)"056038", (Object[])new Object[]{op.getObjectAsPrintable(), FKListStore.this.ownerMemberMetaData.getFullFieldName(), StringUtils.toJVMIDString((Object)esm.getObject()), StringUtils.toJVMIDString((Object)currentOwner)}));
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider op2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ListIterator listIterator(ObjectProvider op, int startIdx, int endIdx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateFkStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getUpdateFkStatementString(element);
        }
        if (this.updateFkStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                this.updateFkStmt = this.getUpdateFkStatementString(element);
            }
        }
        return this.updateFkStmt;
    }

    private String getUpdateFkStatementString(Object element) {
        int i;
        StringBuilder stmt = new StringBuilder("UPDATE ");
        if (this.elementInfo.length > 1) {
            stmt.append("?");
        } else {
            stmt.append(this.containerTable.toString());
        }
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append("=");
            stmt.append(((AbstractDatastoreMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        if (this.orderMapping != null) {
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((AbstractDatastoreMapping)this.orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append("=");
                stmt.append(((AbstractDatastoreMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, null, true);
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.containerTable.toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + "=NULL");
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString() + "=-1");
                    }
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.clearNullifyStmt = stmt.toString();
            }
        }
        return this.clearNullifyStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSetStmt(Object element) {
        if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
            return this.getSetStatementString(element);
        }
        if (this.setStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                this.setStmt = this.getSetStatementString(element);
            }
        }
        return this.setStmt;
    }

    private String getSetStatementString(Object element) {
        int i;
        StringBuilder stmt = new StringBuilder("UPDATE ");
        stmt.append(this.containerTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((AbstractDatastoreMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        if (this.orderMapping != null) {
            for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((AbstractDatastoreMapping)this.orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        if (this.relationDiscriminatorMapping != null) {
            for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((AbstractDatastoreMapping)this.relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.isElementsAreSerialised(), null, true);
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUnsetStmt() {
        if (this.unsetStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                stmt.append(this.containerTable.toString());
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(",");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append("=NULL");
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",");
                        stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=-1");
                    }
                }
                if (this.relationDiscriminatorMapping != null) {
                    for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(",");
                        stmt.append(this.relationDiscriminatorMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append(" = NULL");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.unsetStmt = stmt.toString();
            }
        }
        return this.unsetStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoveAtNullifyStmt() {
        if (this.removeAtNullifyStmt == null) {
            FKListStore fKListStore = this;
            synchronized (fKListStore) {
                int i;
                StringBuilder stmt = new StringBuilder("UPDATE ");
                if (this.elementInfo.length > 1) {
                    stmt.append("?");
                } else {
                    stmt.append(this.containerTable.toString());
                }
                stmt.append(" SET ");
                for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                    if (i > 0) {
                        stmt.append(", ");
                    }
                    stmt.append(this.ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                    stmt.append("=NULL");
                }
                if (this.orderMapping != null) {
                    for (i = 0; i < this.orderMapping.getNumberOfDatastoreMappings(); ++i) {
                        stmt.append(", ");
                        stmt.append(this.orderMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
                        stmt.append("=-1");
                    }
                }
                stmt.append(" WHERE ");
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
                if (this.relationDiscriminatorMapping != null) {
                    BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
                }
                this.removeAtNullifyStmt = stmt.toString();
            }
        }
        return this.removeAtNullifyStmt;
    }

    public IteratorStatement getIteratorStatement(ClassLoaderResolver clr, FetchPlan fp, boolean addRestrictionOnOwner, int startIdx, int endIdx) {
        SQLExpression[] orderExprs;
        SQLStatement sqlStmt = null;
        StatementClassMapping stmtClassMapping = new StatementClassMapping();
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        if (this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getCollection().getElementType();
            if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null).getStatement();
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement();
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, stmtClassMapping, fp, sqlStmt.getPrimaryTable(), this.emd, 0);
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, elementCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                stmtClassMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
                SQLStatement subStmt = stmtGen.getStatement();
                if (sqlStmt == null) {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, stmtClassMapping, fp, subStmt.getPrimaryTable(), this.emd, 0);
                } else {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, fp, subStmt.getPrimaryTable(), this.emd, 0);
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                sqlStmt.union(subStmt);
            }
        }
        if (addRestrictionOnOwner) {
            SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
            SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
            SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
            sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        }
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.indexedList) {
            SQLExpression indexVal;
            SQLExpression indexExpr;
            boolean needsOrdering = true;
            if (startIdx == -1 && endIdx == -1) {
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
            } else if (startIdx >= 0 && endIdx == startIdx) {
                needsOrdering = false;
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                sqlStmt.whereAnd(indexExpr.eq(indexVal), true);
            } else {
                if (startIdx >= 0) {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                } else {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                }
                if (endIdx >= 0) {
                    SQLExpression indexExpr2 = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    SQLExpression indexVal2 = exprFactory.newLiteral(sqlStmt, this.orderMapping, endIdx);
                    sqlStmt.whereAnd(indexExpr2.lt(indexVal2), true);
                }
            }
            if (needsOrdering) {
                SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
                orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
                sqlStmt.setOrdering(orderExprs, descendingOrder);
            }
        } else {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            orderExprs = new SQLExpression[orderComponents.length];
            boolean[] orderDirs = new boolean[orderComponents.length];
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getMemberMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                orderDirs[i] = !orderComponents[i].isForward();
                SQLTable fieldSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), fieldMapping);
                orderExprs[i] = exprFactory.newExpression(sqlStmt, fieldSqlTbl, fieldMapping);
            }
            sqlStmt.setOrdering(orderExprs, orderDirs);
        }
        return new IteratorStatement(this, sqlStmt, stmtClassMapping);
    }
}

