/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.mapper;

import java.util.Arrays;
import java.util.List;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.records.writer.RecordWriter;
import org.datavec.api.split.InputSplit;
import org.datavec.api.split.partition.NumberOfRecordsPartitioner;
import org.datavec.api.split.partition.Partitioner;
import org.datavec.api.writable.Writable;

public class RecordMapper {
    private RecordReader recordReader;
    private RecordWriter recordWriter;
    private InputSplit inputUrl;
    private InputSplit[] splitPerReader;
    private RecordReader[] readersToConcat;
    private InputSplit outputUrl;
    private boolean callInitRecordReader;
    private boolean callInitRecordWriter;
    private boolean callInitPartitioner;
    private Configuration configuration;
    private Configuration[] configurationsPerReader;
    private Partitioner partitioner;
    private int batchSize;

    public void copy() throws Exception {
        if (this.callInitRecordReader) {
            if (this.recordReader != null) {
                this.recordReader.initialize(this.configuration, this.inputUrl);
            } else {
                if (this.readersToConcat == null || this.splitPerReader == null) {
                    throw new IllegalArgumentException("No readers or input  splits found.");
                }
                if (this.readersToConcat.length != this.splitPerReader.length) {
                    throw new IllegalArgumentException("One input split must be specified per record reader");
                }
                for (int i = 0; i < this.readersToConcat.length; ++i) {
                    if (this.readersToConcat[i] == null) {
                        throw new IllegalStateException("Reader at record " + i + " was null!");
                    }
                    if (this.splitPerReader[i] == null) {
                        throw new IllegalStateException("Split at " + i + " is null!");
                    }
                    if (this.configurationsPerReader != null) {
                        this.readersToConcat[i].initialize(this.configurationsPerReader[i], this.splitPerReader[i]);
                        continue;
                    }
                    this.readersToConcat[i].initialize(this.configuration, this.splitPerReader[i]);
                }
            }
        }
        if (this.callInitPartitioner) {
            this.partitioner.init(this.configuration, this.outputUrl);
        }
        if (this.callInitRecordWriter) {
            this.recordWriter.initialize(this.configuration, this.outputUrl, this.partitioner);
        }
        if (this.recordReader != null) {
            this.write(this.recordReader, true);
        } else if (this.readersToConcat != null) {
            for (RecordReader recordReader : this.readersToConcat) {
                this.write(recordReader, false);
            }
            this.recordWriter.close();
        }
    }

    private void write(RecordReader recordReader, boolean closeWriter) throws Exception {
        if (this.batchSize > 0 && recordReader.batchesSupported() && this.recordWriter.supportsBatch()) {
            while (recordReader.hasNext()) {
                List<List<Writable>> next = recordReader.next(this.batchSize);
                if (this.partitioner.needsNewPartition()) {
                    this.partitioner.currentOutputStream().flush();
                    this.partitioner.currentOutputStream().close();
                    this.partitioner.openNewStream();
                }
                this.partitioner.updatePartitionInfo(this.recordWriter.writeBatch(next));
            }
            this.partitioner.currentOutputStream().flush();
            recordReader.close();
            if (closeWriter) {
                this.partitioner.currentOutputStream().close();
                this.recordWriter.close();
            }
        } else {
            while (recordReader.hasNext()) {
                List<Writable> next = recordReader.next();
                this.partitioner.updatePartitionInfo(this.recordWriter.write(next));
                if (!this.partitioner.needsNewPartition()) continue;
                this.partitioner.openNewStream();
            }
        }
    }

    private static boolean $default$callInitRecordReader() {
        return true;
    }

    private static boolean $default$callInitRecordWriter() {
        return true;
    }

    private static boolean $default$callInitPartitioner() {
        return true;
    }

    private static Configuration $default$configuration() {
        return new Configuration();
    }

    private static Partitioner $default$partitioner() {
        return new NumberOfRecordsPartitioner();
    }

    RecordMapper(RecordReader recordReader, RecordWriter recordWriter, InputSplit inputUrl, InputSplit[] splitPerReader, RecordReader[] readersToConcat, InputSplit outputUrl, boolean callInitRecordReader, boolean callInitRecordWriter, boolean callInitPartitioner, Configuration configuration, Configuration[] configurationsPerReader, Partitioner partitioner, int batchSize) {
        this.recordReader = recordReader;
        this.recordWriter = recordWriter;
        this.inputUrl = inputUrl;
        this.splitPerReader = splitPerReader;
        this.readersToConcat = readersToConcat;
        this.outputUrl = outputUrl;
        this.callInitRecordReader = callInitRecordReader;
        this.callInitRecordWriter = callInitRecordWriter;
        this.callInitPartitioner = callInitPartitioner;
        this.configuration = configuration;
        this.configurationsPerReader = configurationsPerReader;
        this.partitioner = partitioner;
        this.batchSize = batchSize;
    }

    public static RecordMapperBuilder builder() {
        return new RecordMapperBuilder();
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public static class RecordMapperBuilder {
        private RecordReader recordReader;
        private RecordWriter recordWriter;
        private InputSplit inputUrl;
        private InputSplit[] splitPerReader;
        private RecordReader[] readersToConcat;
        private InputSplit outputUrl;
        private boolean callInitRecordReader$set;
        private boolean callInitRecordReader;
        private boolean callInitRecordWriter$set;
        private boolean callInitRecordWriter;
        private boolean callInitPartitioner$set;
        private boolean callInitPartitioner;
        private boolean configuration$set;
        private Configuration configuration;
        private Configuration[] configurationsPerReader;
        private boolean partitioner$set;
        private Partitioner partitioner;
        private int batchSize;

        RecordMapperBuilder() {
        }

        public RecordMapperBuilder recordReader(RecordReader recordReader) {
            this.recordReader = recordReader;
            return this;
        }

        public RecordMapperBuilder recordWriter(RecordWriter recordWriter) {
            this.recordWriter = recordWriter;
            return this;
        }

        public RecordMapperBuilder inputUrl(InputSplit inputUrl) {
            this.inputUrl = inputUrl;
            return this;
        }

        public RecordMapperBuilder splitPerReader(InputSplit[] splitPerReader) {
            this.splitPerReader = splitPerReader;
            return this;
        }

        public RecordMapperBuilder readersToConcat(RecordReader[] readersToConcat) {
            this.readersToConcat = readersToConcat;
            return this;
        }

        public RecordMapperBuilder outputUrl(InputSplit outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public RecordMapperBuilder callInitRecordReader(boolean callInitRecordReader) {
            this.callInitRecordReader = callInitRecordReader;
            this.callInitRecordReader$set = true;
            return this;
        }

        public RecordMapperBuilder callInitRecordWriter(boolean callInitRecordWriter) {
            this.callInitRecordWriter = callInitRecordWriter;
            this.callInitRecordWriter$set = true;
            return this;
        }

        public RecordMapperBuilder callInitPartitioner(boolean callInitPartitioner) {
            this.callInitPartitioner = callInitPartitioner;
            this.callInitPartitioner$set = true;
            return this;
        }

        public RecordMapperBuilder configuration(Configuration configuration) {
            this.configuration = configuration;
            this.configuration$set = true;
            return this;
        }

        public RecordMapperBuilder configurationsPerReader(Configuration[] configurationsPerReader) {
            this.configurationsPerReader = configurationsPerReader;
            return this;
        }

        public RecordMapperBuilder partitioner(Partitioner partitioner) {
            this.partitioner = partitioner;
            this.partitioner$set = true;
            return this;
        }

        public RecordMapperBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public RecordMapper build() {
            boolean callInitRecordReader = this.callInitRecordReader;
            if (!this.callInitRecordReader$set) {
                callInitRecordReader = RecordMapper.$default$callInitRecordReader();
            }
            boolean callInitRecordWriter = this.callInitRecordWriter;
            if (!this.callInitRecordWriter$set) {
                callInitRecordWriter = RecordMapper.$default$callInitRecordWriter();
            }
            boolean callInitPartitioner = this.callInitPartitioner;
            if (!this.callInitPartitioner$set) {
                callInitPartitioner = RecordMapper.$default$callInitPartitioner();
            }
            Configuration configuration = this.configuration;
            if (!this.configuration$set) {
                configuration = RecordMapper.$default$configuration();
            }
            Partitioner partitioner = this.partitioner;
            if (!this.partitioner$set) {
                partitioner = RecordMapper.$default$partitioner();
            }
            return new RecordMapper(this.recordReader, this.recordWriter, this.inputUrl, this.splitPerReader, this.readersToConcat, this.outputUrl, callInitRecordReader, callInitRecordWriter, callInitPartitioner, configuration, this.configurationsPerReader, partitioner, this.batchSize);
        }

        public String toString() {
            return "RecordMapper.RecordMapperBuilder(recordReader=" + this.recordReader + ", recordWriter=" + this.recordWriter + ", inputUrl=" + this.inputUrl + ", splitPerReader=" + Arrays.deepToString(this.splitPerReader) + ", readersToConcat=" + Arrays.deepToString(this.readersToConcat) + ", outputUrl=" + this.outputUrl + ", callInitRecordReader=" + this.callInitRecordReader + ", callInitRecordWriter=" + this.callInitRecordWriter + ", callInitPartitioner=" + this.callInitPartitioner + ", configuration=" + this.configuration + ", configurationsPerReader=" + Arrays.deepToString(this.configurationsPerReader) + ", partitioner=" + this.partitioner + ", batchSize=" + this.batchSize + ")";
        }
    }
}

