/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.doubletransform;

import org.datavec.api.transform.transform.doubletransform.BaseDoubleTransform;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class SubtractMeanNormalizer
extends BaseDoubleTransform {
    private final double mean;

    public SubtractMeanNormalizer(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mean") double mean) {
        super(columnName);
        this.mean = mean;
    }

    @Override
    public Writable map(Writable writable) {
        return new DoubleWritable(writable.toDouble() - this.mean);
    }

    @Override
    public String toString() {
        return "SubstractMeanNormalizer(mean=" + this.mean + ")";
    }

    @Override
    public Object map(Object input) {
        Number n = (Number)input;
        return n.doubleValue() - this.mean;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubtractMeanNormalizer)) {
            return false;
        }
        SubtractMeanNormalizer other = (SubtractMeanNormalizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getMean(), other.getMean()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubtractMeanNormalizer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        return result;
    }
}

