/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.floattransform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.FloatMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseColumnsMathOpTransform;
import org.datavec.api.writable.FloatWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FloatColumnsMathOpTransform
extends BaseColumnsMathOpTransform {
    public FloatColumnsMathOpTransform(@JsonProperty(value="newColumnName") String newColumnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="columns") List<String> columns) {
        this(newColumnName, mathOp, columns.toArray(new String[columns.size()]));
    }

    public FloatColumnsMathOpTransform(String newColumnName, MathOp mathOp, String ... columns) {
        super(newColumnName, mathOp, columns);
    }

    @Override
    protected ColumnMetaData derivedColumnMetaData(String newColumnName, Schema inputSchema) {
        return new FloatMetaData(newColumnName);
    }

    @Override
    protected Writable doOp(Writable ... input) {
        switch (this.mathOp) {
            case Add: {
                Float sum = Float.valueOf(0.0f);
                for (Writable w : input) {
                    sum = Float.valueOf(sum.floatValue() + w.toFloat());
                }
                return new FloatWritable(sum.floatValue());
            }
            case Subtract: {
                return new FloatWritable(input[0].toFloat() - input[1].toFloat());
            }
            case Multiply: {
                float product = 1.0f;
                for (Writable w : input) {
                    product *= w.toFloat();
                }
                return new FloatWritable(product);
            }
            case Divide: {
                return new FloatWritable(input[0].toFloat() / input[1].toFloat());
            }
            case Modulus: {
                return new FloatWritable(input[0].toFloat() % input[1].toFloat());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public String toString() {
        return "FloatColumnsMathOpTransform(newColumnName=\"" + this.newColumnName + "\",mathOp=" + (Object)((Object)this.mathOp) + ",columns=" + Arrays.toString(this.columns) + ")";
    }

    @Override
    public Object map(Object input) {
        List row = (List)input;
        switch (this.mathOp) {
            case Add: {
                float sum = 0.0f;
                for (Float w : row) {
                    sum += w.floatValue();
                }
                return Float.valueOf(sum);
            }
            case Subtract: {
                return Float.valueOf(((Float)row.get(0)).floatValue() - ((Float)row.get(1)).floatValue());
            }
            case Multiply: {
                float product = 1.0f;
                for (Float w : row) {
                    product *= w.floatValue();
                }
                return Float.valueOf(product);
            }
            case Divide: {
                return Float.valueOf(((Float)row.get(0)).floatValue() / ((Float)row.get(1)).floatValue());
            }
            case Modulus: {
                return Float.valueOf(((Float)row.get(0)).floatValue() % ((Float)row.get(1)).floatValue());
            }
        }
        throw new RuntimeException("Invalid mathOp: " + (Object)((Object)this.mathOp));
    }

    @Override
    public Object mapSequence(Object sequence) {
        List seq = (List)sequence;
        ArrayList<Float> ret = new ArrayList<Float>();
        for (List step : seq) {
            ret.add((Float)this.map((Object)step));
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatColumnsMathOpTransform)) {
            return false;
        }
        FloatColumnsMathOpTransform other = (FloatColumnsMathOpTransform)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FloatColumnsMathOpTransform;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

