/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.columns;

import com.tdunning.math.stats.TDigest;
import java.util.Arrays;
import org.datavec.api.transform.analysis.columns.ColumnAnalysis;
import org.datavec.api.transform.analysis.json.TDigestDeserializer;
import org.datavec.api.transform.analysis.json.TDigestSerializer;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

public abstract class NumericalColumnAnalysis
implements ColumnAnalysis {
    protected double mean;
    protected double sampleStdev;
    protected double sampleVariance;
    protected long countZero;
    protected long countNegative;
    protected long countPositive;
    protected long countMinValue;
    protected long countMaxValue;
    protected long countTotal;
    protected double[] histogramBuckets;
    protected long[] histogramBucketCounts;
    @JsonSerialize(using=TDigestSerializer.class)
    @JsonDeserialize(using=TDigestDeserializer.class)
    protected TDigest digest;

    protected NumericalColumnAnalysis(Builder builder) {
        this.mean = builder.mean;
        this.sampleStdev = builder.sampleStdev;
        this.sampleVariance = builder.sampleVariance;
        this.countZero = builder.countZero;
        this.countNegative = builder.countNegative;
        this.countPositive = builder.countPositive;
        this.countMinValue = builder.countMinValue;
        this.countMaxValue = builder.countMaxValue;
        this.countTotal = builder.countTotal;
        this.histogramBuckets = builder.histogramBuckets;
        this.histogramBucketCounts = builder.histogramBucketCounts;
        this.digest = builder.digest;
    }

    protected NumericalColumnAnalysis() {
    }

    public String toString() {
        String q = "";
        if (this.digest != null) {
            StringBuilder quantiles = new StringBuilder(", quantiles=[");
            double[] printReports = new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999};
            for (int i = 0; i < printReports.length; ++i) {
                quantiles.append(printReports[i]).append(" -> ").append(this.digest.quantile(printReports[i]));
                if (i >= printReports.length - 1) continue;
                quantiles.append(",");
            }
            quantiles.append("]");
            q = quantiles.toString();
        }
        return "mean=" + this.mean + ",sampleStDev=" + this.sampleStdev + ",sampleVariance=" + this.sampleVariance + ",countZero=" + this.countZero + ",countNegative=" + this.countNegative + ",countPositive=" + this.countPositive + ",countMinValue=" + this.countMinValue + ",countMaxValue=" + this.countMaxValue + ",count=" + this.countTotal + q;
    }

    public abstract double getMinDouble();

    public abstract double getMaxDouble();

    public double getMean() {
        return this.mean;
    }

    public double getSampleStdev() {
        return this.sampleStdev;
    }

    public double getSampleVariance() {
        return this.sampleVariance;
    }

    public long getCountZero() {
        return this.countZero;
    }

    public long getCountNegative() {
        return this.countNegative;
    }

    public long getCountPositive() {
        return this.countPositive;
    }

    public long getCountMinValue() {
        return this.countMinValue;
    }

    public long getCountMaxValue() {
        return this.countMaxValue;
    }

    @Override
    public long getCountTotal() {
        return this.countTotal;
    }

    public double[] getHistogramBuckets() {
        return this.histogramBuckets;
    }

    public long[] getHistogramBucketCounts() {
        return this.histogramBucketCounts;
    }

    public TDigest getDigest() {
        return this.digest;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setSampleStdev(double sampleStdev) {
        this.sampleStdev = sampleStdev;
    }

    public void setSampleVariance(double sampleVariance) {
        this.sampleVariance = sampleVariance;
    }

    public void setCountZero(long countZero) {
        this.countZero = countZero;
    }

    public void setCountNegative(long countNegative) {
        this.countNegative = countNegative;
    }

    public void setCountPositive(long countPositive) {
        this.countPositive = countPositive;
    }

    public void setCountMinValue(long countMinValue) {
        this.countMinValue = countMinValue;
    }

    public void setCountMaxValue(long countMaxValue) {
        this.countMaxValue = countMaxValue;
    }

    public void setCountTotal(long countTotal) {
        this.countTotal = countTotal;
    }

    public void setHistogramBuckets(double[] histogramBuckets) {
        this.histogramBuckets = histogramBuckets;
    }

    public void setHistogramBucketCounts(long[] histogramBucketCounts) {
        this.histogramBucketCounts = histogramBucketCounts;
    }

    public void setDigest(TDigest digest) {
        this.digest = digest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumericalColumnAnalysis)) {
            return false;
        }
        NumericalColumnAnalysis other = (NumericalColumnAnalysis)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMean(), other.getMean()) != 0) {
            return false;
        }
        if (Double.compare(this.getSampleStdev(), other.getSampleStdev()) != 0) {
            return false;
        }
        if (Double.compare(this.getSampleVariance(), other.getSampleVariance()) != 0) {
            return false;
        }
        if (this.getCountZero() != other.getCountZero()) {
            return false;
        }
        if (this.getCountNegative() != other.getCountNegative()) {
            return false;
        }
        if (this.getCountPositive() != other.getCountPositive()) {
            return false;
        }
        if (this.getCountMinValue() != other.getCountMinValue()) {
            return false;
        }
        if (this.getCountMaxValue() != other.getCountMaxValue()) {
            return false;
        }
        if (this.getCountTotal() != other.getCountTotal()) {
            return false;
        }
        if (!Arrays.equals(this.getHistogramBuckets(), other.getHistogramBuckets())) {
            return false;
        }
        return Arrays.equals(this.getHistogramBucketCounts(), other.getHistogramBucketCounts());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NumericalColumnAnalysis;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $mean = Double.doubleToLongBits(this.getMean());
        result = result * 59 + (int)($mean >>> 32 ^ $mean);
        long $sampleStdev = Double.doubleToLongBits(this.getSampleStdev());
        result = result * 59 + (int)($sampleStdev >>> 32 ^ $sampleStdev);
        long $sampleVariance = Double.doubleToLongBits(this.getSampleVariance());
        result = result * 59 + (int)($sampleVariance >>> 32 ^ $sampleVariance);
        long $countZero = this.getCountZero();
        result = result * 59 + (int)($countZero >>> 32 ^ $countZero);
        long $countNegative = this.getCountNegative();
        result = result * 59 + (int)($countNegative >>> 32 ^ $countNegative);
        long $countPositive = this.getCountPositive();
        result = result * 59 + (int)($countPositive >>> 32 ^ $countPositive);
        long $countMinValue = this.getCountMinValue();
        result = result * 59 + (int)($countMinValue >>> 32 ^ $countMinValue);
        long $countMaxValue = this.getCountMaxValue();
        result = result * 59 + (int)($countMaxValue >>> 32 ^ $countMaxValue);
        long $countTotal = this.getCountTotal();
        result = result * 59 + (int)($countTotal >>> 32 ^ $countTotal);
        result = result * 59 + Arrays.hashCode(this.getHistogramBuckets());
        result = result * 59 + Arrays.hashCode(this.getHistogramBucketCounts());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected double mean;
        protected double sampleStdev;
        protected double sampleVariance;
        protected long countZero;
        protected long countNegative;
        protected long countPositive;
        protected long countMinValue;
        protected long countMaxValue;
        protected long countTotal;
        protected double[] histogramBuckets;
        protected long[] histogramBucketCounts;
        protected TDigest digest;

        public T mean(double mean) {
            this.mean = mean;
            return (T)this;
        }

        public T sampleStdev(double sampleStdev) {
            this.sampleStdev = sampleStdev;
            return (T)this;
        }

        public T sampleVariance(double sampleVariance) {
            this.sampleVariance = sampleVariance;
            return (T)this;
        }

        public T countZero(long countZero) {
            this.countZero = countZero;
            return (T)this;
        }

        public T countNegative(long countNegative) {
            this.countNegative = countNegative;
            return (T)this;
        }

        public T countPositive(long countPositive) {
            this.countPositive = countPositive;
            return (T)this;
        }

        public T countMinValue(long countMinValue) {
            this.countMinValue = countMinValue;
            return (T)this;
        }

        public T countMaxValue(long countMaxValue) {
            this.countMaxValue = countMaxValue;
            return (T)this;
        }

        public T countTotal(long countTotal) {
            this.countTotal = countTotal;
            return (T)this;
        }

        public T histogramBuckets(double[] histogramBuckets) {
            this.histogramBuckets = histogramBuckets;
            return (T)this;
        }

        public T histogramBucketCounts(long[] histogramBucketCounts) {
            this.histogramBucketCounts = histogramBucketCounts;
            return (T)this;
        }

        public T digest(TDigest digest) {
            this.digest = digest;
            return (T)this;
        }
    }
}

