/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"inputSchema", "columnsToKeepIdx", "indicesToKeep"})
public class RemoveAllColumnsExceptForTransform
extends BaseTransform
implements ColumnOp {
    private int[] columnsToKeepIdx;
    private String[] columnsToKeep;
    private Set<Integer> indicesToKeep;

    public RemoveAllColumnsExceptForTransform(String ... columnsToKeep) {
        this.columnsToKeep = columnsToKeep;
    }

    @Override
    public void setInputSchema(Schema schema) {
        super.setInputSchema(schema);
        this.indicesToKeep = new HashSet<Integer>();
        int i = 0;
        this.columnsToKeepIdx = new int[this.columnsToKeep.length];
        for (String s : this.columnsToKeep) {
            int idx = schema.getIndexOfColumn(s);
            if (idx < 0) {
                throw new RuntimeException("Column \"" + s + "\" not found");
            }
            this.columnsToKeepIdx[i++] = idx;
            this.indicesToKeep.add(idx);
        }
    }

    @Override
    public Schema transform(Schema schema) {
        List<String> origNames = schema.getColumnNames();
        List<ColumnMetaData> origMeta = schema.getColumnMetaData();
        HashSet keepSet = new HashSet();
        Collections.addAll(keepSet, this.columnsToKeep);
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(this.columnsToKeep.length);
        Iterator<String> namesIter = origNames.iterator();
        Iterator<ColumnMetaData> metaIter = origMeta.iterator();
        while (namesIter.hasNext()) {
            String n = namesIter.next();
            ColumnMetaData t = metaIter.next();
            if (!keepSet.contains(n)) continue;
            newMeta.add(t);
        }
        return schema.newSchema(newMeta);
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        ArrayList<Writable> outList = new ArrayList<Writable>(this.columnsToKeep.length);
        int i = 0;
        for (Writable w : writables) {
            if (!this.indicesToKeep.contains(i++)) continue;
            outList.add(w);
        }
        return outList;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Unable to map. Please treat this as a special operation. This should be handled by your implementation.");
    }

    @Override
    public String toString() {
        return "RemoveAllColumnsExceptForTransform(" + Arrays.toString(this.columnsToKeep) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveAllColumnsExceptForTransform o2 = (RemoveAllColumnsExceptForTransform)o;
        return Arrays.equals(this.columnsToKeep, o2.columnsToKeep);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.columnsToKeep);
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.columnsToKeep;
    }

    @Override
    public String[] columnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public int[] getColumnsToKeepIdx() {
        return this.columnsToKeepIdx;
    }

    public String[] getColumnsToKeep() {
        return this.columnsToKeep;
    }

    public Set<Integer> getIndicesToKeep() {
        return this.indicesToKeep;
    }

    public void setColumnsToKeepIdx(int[] columnsToKeepIdx) {
        this.columnsToKeepIdx = columnsToKeepIdx;
    }

    public void setColumnsToKeep(String[] columnsToKeep) {
        this.columnsToKeep = columnsToKeep;
    }

    public void setIndicesToKeep(Set<Integer> indicesToKeep) {
        this.indicesToKeep = indicesToKeep;
    }
}

