/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import javax.naming.Context;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.XStreamDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.camel.component.DroolsPolicy;
import org.drools.command.Command;
import org.drools.command.runtime.BatchExecutionCommandImpl;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.common.InternalFactHandle;
import org.drools.pipeline.camel.Person;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.help.BatchExecutionHelper;
import org.drools.runtime.rule.FactHandle;
import org.junit.Test;

public class CamelEndpointWithMarshallersTest
extends DroolsCamelTestSupport {
    private String handle;

    @Test
    public void testSimple() {
    }

    @Test
    public void testSessionInsert() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup=\"ksession1\">\n";
        cmd = cmd + "  <insert out-identifier=\"salaboy\">\n";
        cmd = cmd + "      <org.drools.pipeline.camel.Person>\n";
        cmd = cmd + "         <name>salaboy</name>\n";
        cmd = cmd + "      </org.drools.pipeline.camel.Person>\n";
        cmd = cmd + "   </insert>\n";
        cmd = cmd + "   <fire-all-rules/>\n";
        cmd = cmd + "</batch-execution>\n";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        Person person = (Person)result.getValue("salaboy");
        CamelEndpointWithMarshallersTest.assertEquals((String)"salaboy", (String)person.getName());
        String expectedXml = "";
        expectedXml = expectedXml + "<?xml version='1.0' encoding='UTF-8'?><execution-results>";
        expectedXml = expectedXml + "<result identifier=\"salaboy\">";
        expectedXml = expectedXml + "<org.drools.pipeline.camel.Person>";
        expectedXml = expectedXml + "<name>salaboy</name>";
        expectedXml = expectedXml + "</org.drools.pipeline.camel.Person>";
        expectedXml = expectedXml + "</result>";
        expectedXml = expectedXml + "<fact-handle identifier=\"salaboy\" external-form=\"" + ((InternalFactHandle)result.getFactHandle("salaboy")).toExternalForm() + "\"/>";
        expectedXml = expectedXml + "</execution-results>";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testJSonSessionInsert() throws Exception {
        String inXml = "";
        inXml = inXml + "{\"batch-execution\":{\"commands\":[";
        inXml = inXml + "{\"insert\":{\"lookup\":\"ksession1\", ";
        inXml = inXml + "             \"object\":{\"org.drools.pipeline.camel.Person\":{\"name\":\"salaboy\"}}, \"out-identifier\":\"salaboy\" } }";
        inXml = inXml + ", {\"fire-all-rules\":\"\"}";
        inXml = inXml + "]}}";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session-json", (Object)inXml));
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newJSonMarshaller().fromXML(outXml);
        Person person = (Person)result.getValue("salaboy");
        CamelEndpointWithMarshallersTest.assertEquals((String)"salaboy", (String)person.getName());
    }

    @Test
    public void testNoSessionInsert() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup=\"ksession1\">\n";
        cmd = cmd + "<insert out-identifier=\"salaboy\">\n";
        cmd = cmd + "<org.drools.pipeline.camel.Person>\n";
        cmd = cmd + "<name>salaboy</name>\n";
        cmd = cmd + "</org.drools.pipeline.camel.Person>\n";
        cmd = cmd + "</insert>\n";
        cmd = cmd + "<fire-all-rules/>\n";
        cmd = cmd + "</batch-execution>\n";
        String outXml = new String((byte[])this.template.requestBody("direct:test-no-session", (Object)cmd));
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        Person person = (Person)result.getValue("salaboy");
        CamelEndpointWithMarshallersTest.assertEquals((String)"salaboy", (String)person.getName());
        String expectedXml = "";
        expectedXml = expectedXml + "<?xml version='1.0' encoding='UTF-8'?><execution-results>";
        expectedXml = expectedXml + "<result identifier=\"salaboy\">";
        expectedXml = expectedXml + "<org.drools.pipeline.camel.Person>";
        expectedXml = expectedXml + "<name>salaboy</name>";
        expectedXml = expectedXml + "</org.drools.pipeline.camel.Person>";
        expectedXml = expectedXml + "</result>";
        expectedXml = expectedXml + "<fact-handle identifier=\"salaboy\" external-form=\"" + ((InternalFactHandle)result.getFactHandle("salaboy")).toExternalForm() + "\"/>";
        expectedXml = expectedXml + "</execution-results>";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testNoSessionInsertCustomXstream() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup=\"ksession1\">\n";
        cmd = cmd + "<insert out-identifier=\"salaboy\">\n";
        cmd = cmd + "<org.drools.pipeline.camel.Person name=\"salaboy\">\n";
        cmd = cmd + "</org.drools.pipeline.camel.Person>\n";
        cmd = cmd + "</insert>\n";
        cmd = cmd + "<fire-all-rules/>\n";
        cmd = cmd + "</batch-execution>\n";
        String outXml = new String((byte[])this.template.requestBody("direct:test-no-session-custom", (Object)cmd));
        XStream xstream = BatchExecutionHelper.newXStreamMarshaller();
        PersonConverter converter = new PersonConverter();
        xstream.registerConverter((Converter)converter);
        ExecutionResults result = (ExecutionResults)xstream.fromXML(outXml);
        Person person = (Person)result.getValue("salaboy");
        CamelEndpointWithMarshallersTest.assertEquals((String)"salaboy", (String)person.getName());
        String expectedXml = "";
        expectedXml = expectedXml + "<?xml version='1.0' encoding='UTF-8'?><execution-results>";
        expectedXml = expectedXml + "<result identifier=\"salaboy\">";
        expectedXml = expectedXml + "<org.drools.pipeline.camel.Person name=\"salaboy\"/>";
        expectedXml = expectedXml + "</result>";
        expectedXml = expectedXml + "<fact-handle identifier=\"salaboy\" external-form=\"" + ((InternalFactHandle)result.getFactHandle("salaboy")).toExternalForm() + "\"/>";
        expectedXml = expectedXml + "</execution-results>";
        this.assertXMLEqual(expectedXml, outXml);
    }

    @Test
    public void testSessionGetObject() throws Exception {
        String cmd = "";
        cmd = cmd + "<batch-execution lookup=\"ksession1\">\n";
        cmd = cmd + "<get-object out-identifier=\"rider\" fact-handle=\"" + this.handle + "\"/>\n";
        cmd = cmd + "</batch-execution>\n";
        String outXml = new String((byte[])this.template.requestBody("direct:test-with-session", (Object)cmd));
        ExecutionResults result = (ExecutionResults)BatchExecutionHelper.newXStreamMarshaller().fromXML(outXml);
        Person person = (Person)result.getValue("rider");
        CamelEndpointWithMarshallersTest.assertEquals((String)"Hadrian", (String)person.getName());
        String expectedXml = "";
        expectedXml = expectedXml + "<?xml version='1.0' encoding='UTF-8'?><execution-results>";
        expectedXml = expectedXml + "<result identifier=\"rider\">";
        expectedXml = expectedXml + "<org.drools.pipeline.camel.Person>";
        expectedXml = expectedXml + "<name>Hadrian</name>";
        expectedXml = expectedXml + "</org.drools.pipeline.camel.Person>";
        expectedXml = expectedXml + "</result>";
        expectedXml = expectedXml + "</execution-results>";
        this.assertXMLEqual(expectedXml, outXml);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                XStreamDataFormat xstreamDataFormat = new XStreamDataFormat();
                xstreamDataFormat.setConverters(Arrays.asList(PersonConverter.class.getName()));
                HashMap<String, XStreamDataFormat> dataFormats = new HashMap<String, XStreamDataFormat>();
                dataFormats.put("custom-xstream", xstreamDataFormat);
                this.getContext().setDataFormats(dataFormats);
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new DroolsPolicy()).unmarshal("xstream")).to("drools:node/ksession1")).marshal("xstream");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session-json").policy((Policy)new DroolsPolicy()).unmarshal("json")).to("drools:node/ksession1")).marshal("json");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-no-session").policy((Policy)new DroolsPolicy()).unmarshal("xstream")).to("drools:node")).marshal("xstream");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-no-session-custom").policy((Policy)new DroolsPolicy()).unmarshal("custom-xstream")).to("drools:node")).marshal("custom-xstream");
            }
        };
    }

    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        StatefulKnowledgeSession ksession = this.registerKnowledgeRuntime("ksession1", null);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }

    public static class PersonConverter
    implements Converter {
        public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
            Person p = (Person)object;
            writer.addAttribute("name", p.getName());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Person p = new Person(reader.getAttribute("name"));
            return p;
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(Person.class);
        }
    }
}

