/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.common.UpdateContext;
import org.drools.core.definitions.rule.impl.QueryImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNodeLeftTuple;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.Sink;
import org.drools.core.reteoo.SubnetworkTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.consequence.Activation;
import org.drools.core.util.AbstractBaseLinkedListNode;

public class QueryElementNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory<QueryElementNodeMemory> {
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    protected QueryElement queryElement;
    private boolean tupleMemoryEnabled;
    protected boolean openQuery;
    private boolean dataDriven;
    private QueryArgument[] argsTemplate;

    public QueryElementNode() {
    }

    public QueryElementNode(int id, LeftTupleSource tupleSource, QueryElement queryElement, boolean tupleMemoryEnabled, boolean openQuery, BuildContext context) {
        super(id, context);
        this.setLeftTupleSource(tupleSource);
        this.setObjectCount(this.leftInput.getObjectCount() + 1);
        this.queryElement = queryElement;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.openQuery = openQuery;
        this.dataDriven = context != null && context.getRule().isDataDriven();
        this.initMasks(context, tupleSource);
        this.argsTemplate = this.initArgsTemplate(context);
        this.hashcode = this.calculateHashCode();
    }

    private QueryArgument[] initArgsTemplate(BuildContext context) {
        ClassLoader classLoader = context.getRuleBase().getRootClassLoader();
        QueryArgument[] originalArgs = this.queryElement.getArguments();
        QueryArgument[] args = new QueryArgument[originalArgs.length];
        for (int i = 0; i < originalArgs.length; ++i) {
            args[i] = originalArgs[i] == null ? QueryArgument.NULL : originalArgs[i].normalize(classLoader);
        }
        return args;
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    @Override
    public short getType() {
        return 165;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    public InternalFactHandle createFactHandle(PropagationContext context, ReteEvaluator reteEvaluator, LeftTuple leftTuple) {
        InternalFactHandle handle = null;
        if (context.getReaderContext() != null) {
            handle = context.getReaderContext().createQueryHandle(leftTuple, reteEvaluator, this.getId());
        }
        if (handle == null) {
            handle = reteEvaluator.createFactHandle(null, null, null);
        }
        return handle;
    }

    public DroolsQuery createDroolsQuery(LeftTuple leftTuple, InternalFactHandle handle, StackEntry stackEntry, List<PathMemory> pmems, QueryElementNodeMemory qmem, LeftTupleSink sink, ReteEvaluator reteEvaluator) {
        Object object;
        UnificationNodeViewChangedEventListener collector = this.createCollector(leftTuple, this.queryElement.getVariableIndexes(), this.tupleMemoryEnabled);
        boolean executeAsOpenQuery = this.openQuery;
        if (executeAsOpenQuery && (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            executeAsOpenQuery = false;
        }
        DroolsQuery queryObject = new DroolsQuery(this.queryElement.getQueryName(), this.getActualArguments(leftTuple, reteEvaluator), collector, executeAsOpenQuery, stackEntry, pmems, qmem != null ? qmem.getResultLeftTuples() : null, qmem, sink);
        collector.setFactHandle(handle);
        handle.setObject(queryObject);
        leftTuple.setContextObject(handle);
        return queryObject;
    }

    public Object[] getActualArguments(LeftTuple leftTuple, ReteEvaluator reteEvaluator) {
        Object[] args = new Object[this.argsTemplate.length];
        for (int i = 0; i < this.argsTemplate.length; ++i) {
            args[i] = this.argsTemplate[i].getValue(reteEvaluator, leftTuple);
        }
        return args;
    }

    protected UnificationNodeViewChangedEventListener createCollector(LeftTuple leftTuple, int[] varIndexes, boolean tupleMemoryEnabled) {
        return new UnificationNodeViewChangedEventListener(leftTuple, varIndexes, this, tupleMemoryEnabled);
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(factHandle, this, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, Sink sink) {
        return new QueryElementNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, Sink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, Sink sink) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, Sink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.openQuery ? 1231 : 1237);
        result = 31 * result + (this.queryElement == null ? 0 : this.queryElement.hashCode());
        result = 31 * result + (this.leftInput == null ? 0 : this.leftInput.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QueryElementNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        QueryElementNode other = (QueryElementNode)object;
        if (this.leftInput.getId() != other.leftInput.getId()) {
            return false;
        }
        if (this.openQuery != other.openQuery) {
            return false;
        }
        if (!this.openQuery && this.dataDriven != other.dataDriven) {
            return false;
        }
        return !(this.queryElement == null ? other.queryElement != null : !this.queryElement.equals(other.queryElement));
    }

    @Override
    public QueryElementNodeMemory createMemory(RuleBaseConfiguration config, ReteEvaluator reteEvaluator) {
        return new QueryElementNodeMemory(this);
    }

    @Override
    public ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        QueryElementNodeLeftTuple peer = new QueryElementNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ", " + this.queryElement.getQueryName() + ")]";
    }

    @Override
    public void doAttach(BuildContext context) {
        super.doAttach(context);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    protected boolean doRemove(RuleRemovalContext context, ReteooBuilder builder) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
            return true;
        }
        return false;
    }

    public static class QueryElementNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements SegmentNodeMemory {
        private QueryElementNode node;
        private SegmentMemory smem;
        private SegmentMemory querySegmentMemory;
        private TupleSets<LeftTuple> resultLeftTuples;
        private long nodePosMaskBit;

        public QueryElementNodeMemory(QueryElementNode node) {
            this.node = node;
            this.resultLeftTuples = node.getSinkPropagator().size() > 1 ? new QueryTupleSets() : new TupleSetsImpl();
        }

        public QueryElementNode getNode() {
            return this.node;
        }

        @Override
        public short getNodeType() {
            return 165;
        }

        @Override
        public void setSegmentMemory(SegmentMemory smem) {
            this.smem = smem;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.smem;
        }

        public SegmentMemory getQuerySegmentMemory() {
            return this.querySegmentMemory;
        }

        public void setQuerySegmentMemory(SegmentMemory querySegmentMemory) {
            this.querySegmentMemory = querySegmentMemory;
        }

        public TupleSets<LeftTuple> getResultLeftTuples() {
            return this.resultLeftTuples;
        }

        public void correctMemoryOnSinksChanged(TerminalNode removingTN) {
            if (this.resultLeftTuples instanceof QueryTupleSets) {
                if (!SegmentUtilities.isTipNode(this.node, removingTN)) {
                    TupleSetsImpl<LeftTuple> newTupleSets = new TupleSetsImpl<LeftTuple>();
                    this.resultLeftTuples.addTo(newTupleSets);
                    this.resultLeftTuples = newTupleSets;
                }
            } else if (SegmentUtilities.isTipNode(this.node, removingTN)) {
                QueryTupleSets newTupleSets = new QueryTupleSets();
                this.resultLeftTuples.addTo(newTupleSets);
                this.resultLeftTuples = newTupleSets;
            }
        }

        @Override
        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }

        @Override
        public void setNodePosMaskBit(long segmentPos) {
            this.nodePosMaskBit = segmentPos;
        }

        @Override
        public void setNodeDirtyWithoutNotify() {
            this.smem.updateDirtyNodeMask(this.nodePosMaskBit);
        }

        @Override
        public void setNodeCleanWithoutNotify() {
            this.smem.updateCleanNodeMask(this.nodePosMaskBit);
        }

        @Override
        public void reset() {
            this.resultLeftTuples.resetAll();
        }

        public static class QueryTupleSets
        extends TupleSetsImpl<LeftTuple> {
            @Override
            protected LeftTuple getPreviousTuple(LeftTuple tuple) {
                return tuple.getRightParentPrevious();
            }

            @Override
            protected void setPreviousTuple(LeftTuple tuple, LeftTuple stagedPrevious) {
                tuple.setRightParentPrevious(stagedPrevious);
            }

            @Override
            protected LeftTuple getNextTuple(LeftTuple tuple) {
                return tuple.getRightParentNext();
            }

            @Override
            protected void setNextTuple(LeftTuple tuple, LeftTuple stagedNext) {
                tuple.setRightParentNext(stagedNext);
            }

            @Override
            protected void setStagedType(LeftTuple tuple, short type) {
                tuple.setStagedTypeForQueries(type);
            }

            @Override
            protected short getStagedType(LeftTuple tuple) {
                return tuple.getStagedTypeForQueries();
            }

            @Override
            public void addTo(TupleSets<LeftTuple> tupleSets) {
                this.addAllInsertsTo(tupleSets);
                this.addAllDeletesTo(tupleSets);
                this.addAllUpdatesTo(tupleSets);
            }

            private void addAllInsertsTo(TupleSets<LeftTuple> tupleSets) {
                LeftTuple leftTuple = (LeftTuple)this.getInsertFirst();
                while (leftTuple != null) {
                    LeftTuple next = this.getNextTuple(leftTuple);
                    this.clear(leftTuple);
                    tupleSets.addInsert(leftTuple);
                    leftTuple = next;
                }
                this.setInsertFirst(null);
            }

            private void addAllUpdatesTo(TupleSets<LeftTuple> tupleSets) {
                LeftTuple leftTuple = (LeftTuple)this.getUpdateFirst();
                while (leftTuple != null) {
                    LeftTuple next = this.getNextTuple(leftTuple);
                    this.clear(leftTuple);
                    tupleSets.addUpdate(leftTuple);
                    leftTuple = next;
                }
                this.setUpdateFirst(null);
            }

            private void addAllDeletesTo(TupleSets<LeftTuple> tupleSets) {
                LeftTuple leftTuple = (LeftTuple)this.getDeleteFirst();
                while (leftTuple != null) {
                    LeftTuple next = this.getNextTuple(leftTuple);
                    this.clear(leftTuple);
                    tupleSets.addDelete(leftTuple);
                    leftTuple = next;
                }
                this.setDeleteFirst(null);
            }

            private void clear(LeftTuple leftTuple) {
                this.setStagedType(leftTuple, (short)0);
                this.setPreviousTuple(leftTuple, (LeftTuple)null);
                this.setNextTuple(leftTuple, (LeftTuple)null);
            }
        }
    }

    public static class UnificationNodeViewChangedEventListener
    implements InternalViewChangedEventListener {
        protected LeftTuple leftTuple;
        protected QueryElementNode node;
        protected InternalFactHandle factHandle;
        protected int[] variables;
        protected boolean tupleMemoryEnabled;

        public UnificationNodeViewChangedEventListener(LeftTuple leftTuple, int[] variables, QueryElementNode node, boolean tupleMemoryEnabled) {
            this.leftTuple = leftTuple;
            this.variables = variables;
            this.node = node;
            this.tupleMemoryEnabled = tupleMemoryEnabled;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public void setVariables(int[] variables) {
            this.variables = variables;
        }

        @Override
        public void rowAdded(RuleImpl rule, LeftTuple resultLeftTuple, ReteEvaluator reteEvaluator) {
            QueryTerminalNode queryTerminalNode = (QueryTerminalNode)resultLeftTuple.getTupleSink();
            QueryImpl query = queryTerminalNode.getQuery();
            Declaration[] decls = queryTerminalNode.getRequiredDeclarations();
            DroolsQuery dquery = (DroolsQuery)this.factHandle.getObject();
            Object[] objects = new Object[this.determineResultSize(query, dquery)];
            for (int variable : this.variables) {
                Declaration decl = decls[variable];
                objects[variable] = decl.getValue(reteEvaluator, resultLeftTuple);
            }
            QueryElementFactHandle resultHandle = this.createQueryResultHandle(this.leftTuple.findMostRecentPropagationContext(), reteEvaluator, objects);
            RightTuple rightTuple = this.createResultRightTuple(resultHandle, resultLeftTuple, dquery.isOpen());
            if (query.processAbduction((Activation)((Object)resultLeftTuple), dquery, objects, reteEvaluator)) {
                LeftTupleSink sink = dquery.getLeftTupleSink();
                LeftTuple childLeftTuple = sink.createLeftTuple(this.leftTuple, rightTuple, (Sink)sink);
                boolean stagedInsertWasEmpty = dquery.getResultLeftTupleSets().addInsert(childLeftTuple);
                if (stagedInsertWasEmpty) {
                    dquery.getQueryNodeMemory().setNodeDirtyWithoutNotify();
                }
            }
        }

        private int determineResultSize(QueryImpl query, DroolsQuery dquery) {
            int size = dquery.getElements().length;
            if (query.isReturnBound()) {
                ++size;
            }
            return size;
        }

        protected RightTuple createResultRightTuple(QueryElementFactHandle resultHandle, LeftTuple resultLeftTuple, boolean open) {
            RightTupleImpl rightTuple = new RightTupleImpl(resultHandle);
            if (open) {
                rightTuple.setBlocked(resultLeftTuple);
                resultLeftTuple.setContextObject(rightTuple);
            }
            rightTuple.setPropagationContext(resultLeftTuple.getPropagationContext());
            return rightTuple;
        }

        protected QueryElementFactHandle createQueryResultHandle(PropagationContext context, ReteEvaluator reteEvaluator, Object[] objects) {
            QueryElementFactHandle handle = null;
            if (context.getReaderContext() != null) {
                handle = context.getReaderContext().createQueryResultHandle(this.leftTuple, objects, this.node.getId());
            }
            if (handle == null) {
                handle = new QueryElementFactHandle(objects, reteEvaluator.getFactHandleFactory().getNextId(), reteEvaluator.getFactHandleFactory().getNextRecency());
            }
            return handle;
        }

        @Override
        public void rowRemoved(RuleImpl rule, LeftTuple resultLeftTuple, ReteEvaluator reteEvaluator) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getContextObject();
            rightTuple.setBlocked(null);
            resultLeftTuple.setContextObject(null);
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            TupleSets<LeftTuple> leftTuples = query.getResultLeftTupleSets();
            LeftTuple childLeftTuple = rightTuple.getFirstChild();
            if (childLeftTuple.isStagedOnRight()) {
                ((SubnetworkTuple)childLeftTuple).moveStagingFromRightToLeft();
            } else {
                short stagedTypeForQueries = childLeftTuple.getStagedTypeForQueries();
                if (stagedTypeForQueries == 1) {
                    leftTuples.removeInsert(childLeftTuple);
                    return;
                }
                if (stagedTypeForQueries == 2) {
                    leftTuples.removeUpdate(childLeftTuple);
                }
            }
            leftTuples.addDelete(childLeftTuple);
        }

        @Override
        public void rowUpdated(RuleImpl rule, LeftTuple resultLeftTuple, ReteEvaluator reteEvaluator) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getContextObject();
            if (rightTuple.getMemory() != null) {
                return;
            }
            rightTuple.setBlocked(null);
            resultLeftTuple.setContextObject(null);
            QueryTerminalNode queryTerminalNode = (QueryTerminalNode)resultLeftTuple.getTupleSink();
            Declaration[] decls = queryTerminalNode.getRequiredDeclarations();
            InternalFactHandle rootHandle = resultLeftTuple.get(0);
            DroolsQuery dquery = (DroolsQuery)rootHandle.getObject();
            Object[] objects = new Object[dquery.getElements().length];
            for (int variable : this.variables) {
                Declaration decl = decls[variable];
                objects[variable] = decl.getValue(reteEvaluator, resultLeftTuple);
            }
            QueryElementFactHandle handle = (QueryElementFactHandle)rightTuple.getFactHandle();
            handle.setRecency(reteEvaluator.getFactHandleFactory().getNextRecency());
            handle.setObject(objects);
            if (dquery.isOpen()) {
                rightTuple.setBlocked(resultLeftTuple);
                resultLeftTuple.setContextObject(rightTuple);
            }
            TupleSets<LeftTuple> leftTuples = dquery.getResultLeftTupleSets();
            LeftTuple childLeftTuple = rightTuple.getFirstChild();
            short stagedTypeForQueries = childLeftTuple.getStagedTypeForQueries();
            if (stagedTypeForQueries == 1) {
                leftTuples.removeInsert(childLeftTuple);
            } else if (stagedTypeForQueries == 2) {
                leftTuples.removeUpdate(childLeftTuple);
            }
            leftTuples.addUpdate(childLeftTuple);
        }

        public List<?> getResults() {
            throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support the getResults() method.");
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }
    }
}

