/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.consequence;

import java.io.Serializable;
import java.security.AccessController;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.rule.accessor.CompiledInvoker;
import org.drools.core.rule.accessor.Invoker;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.kie.internal.security.KiePolicyHelper;

public interface Consequence
extends Invoker {
    public String getName();

    public void evaluate(KnowledgeHelper var1, ReteEvaluator var2) throws Exception;

    public static class SafeConsequence
    implements Consequence,
    Serializable {
        private static final long serialVersionUID = -8109957972163261899L;
        private final Consequence delegate;

        public SafeConsequence(Consequence delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void evaluate(KnowledgeHelper knowledgeHelper, ReteEvaluator reteEvaluator) throws Exception {
            AccessController.doPrivileged(() -> {
                this.delegate.evaluate(knowledgeHelper, reteEvaluator);
                return null;
            }, KiePolicyHelper.getAccessContext());
        }

        @Override
        public boolean wrapsCompiledInvoker() {
            return this.delegate instanceof CompiledInvoker;
        }
    }
}

