/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.drools.verifier.PatternSolver;
import org.drools.verifier.RuleSolver;
import org.drools.verifier.components.OperatorDescr;
import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.PatternPossibility;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePossibility;
import org.drools.verifier.components.VerifierComponent;
import org.drools.verifier.components.VerifierRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Solvers {
    private RuleSolver ruleSolver = null;
    private PatternSolver patternSolver = null;
    private List<PatternPossibility> patternPossibilities = new ArrayList<PatternPossibility>();
    private List<RulePossibility> rulePossibilities = new ArrayList<RulePossibility>();

    Solvers() {
    }

    public void startRuleSolver(VerifierRule rule) {
        this.ruleSolver = new RuleSolver(rule);
    }

    public void endRuleSolver() {
        this.createRulePossibilities();
        this.ruleSolver = null;
    }

    public void startPatternSolver(Pattern pattern) {
        this.patternSolver = new PatternSolver(pattern);
        this.patternSolver.getPattern().setPatternNot(this.ruleSolver.isChildNot());
    }

    public void endPatternSolver() {
        this.createPatternPossibilities();
        this.patternSolver = null;
    }

    public void startForall() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildForall(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildForall(true);
        }
    }

    public void endForall() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildForall(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildForall(false);
        }
    }

    public void startExists() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildExists(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildExists(true);
        }
    }

    public void endExists() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildExists(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildExists(false);
        }
    }

    public void startNot() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildNot(true);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildNot(true);
        }
    }

    public void endNot() {
        if (this.patternSolver != null) {
            this.patternSolver.setChildNot(false);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.setChildNot(false);
        }
    }

    public void startOperator(OperatorDescr.Type type) {
        if (this.patternSolver != null) {
            this.patternSolver.addOperator(type);
        } else if (this.ruleSolver != null) {
            this.ruleSolver.addOperator(type);
        }
    }

    public void endOperator() {
        if (this.patternSolver != null) {
            this.patternSolver.end();
        } else if (this.ruleSolver != null) {
            this.ruleSolver.end();
        }
    }

    public void addRestriction(Restriction restriction) {
        this.patternSolver.add(restriction);
    }

    private void createPatternPossibilities() {
        for (Set<VerifierComponent> list : this.patternSolver.getPossibilityLists()) {
            PatternPossibility possibility = new PatternPossibility();
            possibility.setRuleId(this.ruleSolver.getRule().getId());
            possibility.setRuleName(this.ruleSolver.getRule().getRuleName());
            possibility.setRuleId(this.ruleSolver.getRule().getId());
            possibility.setPatternId(this.patternSolver.getPattern().getId());
            for (VerifierComponent descr : list) {
                possibility.add((Restriction)descr);
            }
            this.ruleSolver.add(possibility);
            this.patternPossibilities.add(possibility);
        }
    }

    private void createRulePossibilities() {
        for (Set<VerifierComponent> list : this.ruleSolver.getPossibilityLists()) {
            RulePossibility possibility = new RulePossibility();
            possibility.setRuleId(this.ruleSolver.getRule().getId());
            possibility.setRuleName(this.ruleSolver.getRule().getRuleName());
            possibility.setRuleId(this.ruleSolver.getRule().getId());
            for (VerifierComponent descr : list) {
                PatternPossibility patternPossibility = (PatternPossibility)descr;
                possibility.add(patternPossibility);
            }
            this.rulePossibilities.add(possibility);
        }
    }

    public List<PatternPossibility> getPatternPossibilities() {
        return this.patternPossibilities;
    }

    public void setPatternPossibilities(List<PatternPossibility> patternPossibilities) {
        this.patternPossibilities = patternPossibilities;
    }

    public List<RulePossibility> getRulePossibilities() {
        return this.rulePossibilities;
    }

    public void setRulePossibilities(List<RulePossibility> rulePossibilities) {
        this.rulePossibilities = rulePossibilities;
    }

    public PatternSolver getPatternSolver() {
        return this.patternSolver;
    }

    public RuleSolver getRuleSolver() {
        return this.ruleSolver;
    }
}

