/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimeoutCompleteListener
implements Response.CompleteListener,
Runnable {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Scheduler.Task> task = new AtomicReference();
    private final Request request;

    public TimeoutCompleteListener(Request request) {
        this.request = request;
    }

    @Override
    public void onComplete(Result result) {
        Scheduler.Task task = this.task.getAndSet(null);
        if (task != null) {
            boolean cancelled = task.cancel();
            LOG.debug("Cancelled (successfully: {}) timeout task {}", new Object[]{cancelled, task});
        }
    }

    public boolean schedule(Scheduler scheduler) {
        long timeout = this.request.getTimeout();
        Scheduler.Task task = scheduler.schedule((Runnable)this, timeout, TimeUnit.MILLISECONDS);
        if (this.task.getAndSet(task) != null) {
            throw new IllegalStateException();
        }
        LOG.debug("Scheduled timeout task {} in {} ms", new Object[]{task, timeout});
        return true;
    }

    @Override
    public void run() {
        this.request.abort(new TimeoutException("Total timeout elapsed"));
    }
}

