/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.spi;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

public class DelegatingThreadPool
extends ContainerLifeCycle
implements ThreadPool {
    private static final Logger LOG = Log.getLogger(DelegatingThreadPool.class);
    private Executor _executor;

    public DelegatingThreadPool(Executor executor) {
        this._executor = executor;
        this.addBean(this._executor);
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this.updateBean(this._executor, executor);
        this._executor = executor;
    }

    public void execute(Runnable job) {
        this._executor.execute(job);
    }

    public int getIdleThreads() {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            return ((ThreadPool)executor).getIdleThreads();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            return tpe.getPoolSize() - tpe.getActiveCount();
        }
        return -1;
    }

    public int getThreads() {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            return ((ThreadPool)executor).getThreads();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            return tpe.getPoolSize();
        }
        return -1;
    }

    public boolean isLowOnThreads() {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            return ((ThreadPool)executor).isLowOnThreads();
        }
        if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            return tpe.getPoolSize() == tpe.getMaximumPoolSize() && tpe.getQueue().size() >= tpe.getPoolSize() - tpe.getActiveCount();
        }
        return false;
    }

    public void join() throws InterruptedException {
        Executor executor = this._executor;
        if (executor instanceof ThreadPool) {
            ((ThreadPool)executor).join();
        } else if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        } else {
            throw new IllegalStateException();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (!(this._executor instanceof LifeCycle) && this._executor instanceof ExecutorService) {
            ((ExecutorService)this._executor).shutdownNow();
        }
    }
}

