/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util.language;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.rdf4j.model.util.language.IanaLanguageTag;
import org.eclipse.rdf4j.model.util.language.Iso3166;
import org.eclipse.rdf4j.model.util.language.Iso639;
import org.eclipse.rdf4j.model.util.language.LanguageTagCodes;
import org.eclipse.rdf4j.model.util.language.LanguageTagSyntaxException;

public class LanguageTag
implements LanguageTagCodes {
    String[] subtags;
    private int tagType;

    public LanguageTag(String tag) throws LanguageTagSyntaxException {
        int subT;
        String lc = tag.toLowerCase();
        ArrayList<String> subtagList = new ArrayList<String>();
        while ((subT = lc.indexOf(45)) != -1) {
            subtagList.add(lc.substring(0, subT));
            lc = lc.substring(subT + 1);
        }
        subtagList.add(lc);
        this.subtags = new String[subtagList.size()];
        subtagList.toArray(this.subtags);
        int lg = this.subtags[0].length();
        if (lg == 0 || lg > 8) {
            throw new LanguageTagSyntaxException("Primary subtag must be between 1 and 8 alpha characters: " + tag);
        }
        for (int j = 0; j < lg; ++j) {
            char ch = this.subtags[0].charAt(j);
            if ('a' <= ch && ch <= 'z') continue;
            throw new LanguageTagSyntaxException("Primary subtag must be between 1 and 8 alpha characters: " + tag);
        }
        for (int i = 1; i < this.subtags.length; ++i) {
            lg = this.subtags[i].length();
            if (lg == 0 || lg > 8) {
                throw new LanguageTagSyntaxException("Subtag " + (i + 1) + " must be between 1 and 8 alphanumeric characters: " + tag);
            }
            for (int j = 0; j < lg; ++j) {
                char ch = this.subtags[i].charAt(j);
                if ('a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9') continue;
                throw new LanguageTagSyntaxException("Subtag " + (i + 1) + " must be between 1 and 8 alphanumeric characters: " + tag);
            }
        }
        this.tagType = this.getTagType();
        if (this.tagType == 32768) {
            throw new LanguageTagSyntaxException(this.getErrorMessage());
        }
    }

    private int getTagType() {
        int rslt;
        IanaLanguageTag iana = null;
        iana = this instanceof IanaLanguageTag ? (IanaLanguageTag)this : IanaLanguageTag.find(this);
        Iso639 lang = Iso639.find(this.subtags[0]);
        int n = rslt = iana == null ? 0 : iana.classification;
        if (iana != null && iana.subtags.length < this.subtags.length) {
            rslt |= 0x80;
        }
        switch (this.subtags[0].length()) {
            case 1: {
                switch (this.subtags[0].charAt(0)) {
                    case 'x': {
                        return 2;
                    }
                    case 'i': {
                        return iana != null ? rslt : 32768;
                    }
                }
                return 32768;
            }
            case 2: {
                if (lang == null) {
                    return 32768;
                }
                rslt |= lang.classification;
                break;
            }
            case 3: {
                if (lang == null) {
                    return 32768;
                }
                if (lang.twoCharCode != null) {
                    return 32768;
                }
                if (!lang.terminologyCode.equals(this.subtags[0])) {
                    return 32768;
                }
                rslt |= lang.classification;
                break;
            }
            default: {
                return 32768;
            }
        }
        if (this.subtags.length == 1) {
            return rslt;
        }
        switch (this.subtags[1].length()) {
            case 1: {
                return 32768;
            }
            case 2: {
                if (Iso3166.find(this.subtags[1]) == null) {
                    return 32768;
                }
                rslt |= 0x10;
                break;
            }
            default: {
                if (iana != null) break;
                rslt |= 0x80;
            }
        }
        if (this.subtags.length > 2 && iana == null) {
            rslt |= 0x80;
        }
        return rslt;
    }

    private String getErrorMessage() {
        switch (this.subtags[0].length()) {
            case 1: {
                switch (this.subtags[0].charAt(0)) {
                    case 'x': {
                        return null;
                    }
                    case 'i': {
                        if (this instanceof IanaLanguageTag || IanaLanguageTag.find(this) != null) {
                            return null;
                        }
                        return this.toString() + " not found in IANA langauge registry.";
                    }
                }
                return "Only 'x' and 'i' single character primary language subtags are defined in RFC3066.";
            }
            case 2: {
                if (Iso639.find(this.subtags[0]) != null) break;
                return "ISO-639 does not define language: '" + this.subtags[0] + "'.";
            }
            case 3: {
                Iso639 lang = Iso639.find(this.subtags[0]);
                if (lang == null) {
                    return "ISO-639 does not define language: '" + this.subtags[0] + "'.";
                }
                if (lang.twoCharCode != null) {
                    return "RFC 3066 section 2.3 mandates the use of '" + lang.twoCharCode + "' instead of '" + this.subtags[0] + "'.";
                }
                if (lang.terminologyCode.equals(this.subtags[0])) break;
                return "RFC 3066 section 2.3 mandates the use of '" + lang.terminologyCode + "' instead of '" + this.subtags[0] + "'.";
            }
            default: {
                return "No primary language subtags of length greater than 3 are currently defined.";
            }
        }
        if (this.subtags.length == 1) {
            return null;
        }
        switch (this.subtags[1].length()) {
            case 1: {
                return "Second language subtags of length 1 are prohibited by RFC3066.";
            }
            case 2: {
                if (Iso3166.find(this.subtags[1]) != null) break;
                return "Country code, '" + this.subtags[1] + "', not found in ISO 3166.";
            }
        }
        return null;
    }

    public boolean hasLanguage() {
        boolean result = (this.tagType & 1) == 1 && (this.tagType & 0x400) != 1024 && (this.tagType & 0x200) != 512 && (this.tagType & 0x800) != 2048;
        return result;
    }

    public Iso639 getLanguage() {
        Iso639 result = null;
        if (this.hasLanguage()) {
            result = Iso639.find(this.subtags[0]);
        }
        return result;
    }

    public boolean hasCountry() {
        boolean result = (this.tagType & 0x10) == 16;
        return result;
    }

    public Iso3166 getCountry() {
        Iso3166 result = null;
        if (this.hasCountry()) {
            result = Iso3166.find(this.subtags[1]);
        }
        return result;
    }

    public boolean hasVariant() {
        boolean result = (this.tagType & 0x80) == 128;
        return result;
    }

    public String getVariant() {
        String result = null;
        if (this.hasVariant()) {
            result = this.hasCountry() ? this.subtags[2] : this.subtags[1];
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String subtag : this.subtags) {
            result.append(subtag);
            result.append('-');
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public Locale toLocale() {
        Locale result = null;
        Iso639 iso639Language = this.getLanguage();
        Iso3166 iso3166Country = this.getCountry();
        String variant = this.getVariant();
        if (iso639Language != null) {
            String language = iso639Language.twoCharCode.toLowerCase();
            if (iso3166Country != null) {
                String country = iso3166Country.code.toUpperCase();
                result = variant != null ? new Locale(language, country, variant) : new Locale(language, country);
            } else {
                result = new Locale(language);
            }
        }
        return result;
    }
}

