/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.maven;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.transformer.AppOption;
import org.eclipse.transformer.TransformOptions;
import org.eclipse.transformer.jakarta.JakartaTransform;
import org.eclipse.transformer.maven.configuration.TransformerRules;

public class TransformerMojoOptions
implements TransformOptions {
    private final TransformerRules rules;
    private final Map<String, String> optionDefaults;
    private final Function<String, URL> ruleLoader;

    public TransformerMojoOptions(TransformerRules rules) {
        this.rules = Objects.requireNonNull(rules);
        if (rules.isJakartaDefaults()) {
            this.optionDefaults = JakartaTransform.getOptionDefaults();
            this.ruleLoader = JakartaTransform.getRuleLoader();
        } else {
            this.optionDefaults = Collections.emptyMap();
            this.ruleLoader = this.getClass()::getResource;
        }
    }

    private static List<String> condition(List<String> values) {
        if (values == null) {
            return null;
        }
        ListIterator<String> iterator = values.listIterator();
        while (iterator.hasNext()) {
            String value = StringUtils.trim((String)iterator.next());
            if (StringUtils.isBlank((String)value) || Objects.equals("-", value)) {
                iterator.remove();
                continue;
            }
            iterator.set(value);
        }
        return values;
    }

    public List<String> getOptionValues(AppOption option) {
        List<String> values;
        switch (option) {
            case RULES_BUNDLES: {
                values = this.rules.getBundles();
                break;
            }
            case RULES_DIRECT: {
                values = this.rules.getDirects();
                break;
            }
            case RULES_IMMEDIATE_DATA: {
                values = this.rules.getImmediates();
                break;
            }
            case RULES_MASTER_TEXT: {
                values = this.rules.getTexts();
                break;
            }
            case RULES_PER_CLASS_CONSTANT: {
                values = this.rules.getPerClassConstants();
                break;
            }
            case RULES_RENAMES: {
                values = this.rules.getRenames();
                break;
            }
            case RULES_SELECTIONS: {
                values = this.rules.getSelections();
                break;
            }
            case RULES_VERSIONS: {
                values = this.rules.getVersions();
                break;
            }
            default: {
                values = null;
            }
        }
        return TransformerMojoOptions.condition(values);
    }

    public boolean hasOption(AppOption option) {
        boolean has;
        switch (option) {
            case OVERWRITE: {
                has = this.rules.isOverwrite();
                break;
            }
            case INVERT: {
                has = this.rules.isInvert();
                break;
            }
            case WIDEN_ARCHIVE_NESTING: {
                has = this.rules.isWiden();
                break;
            }
            default: {
                has = super.hasOption(option);
            }
        }
        return has;
    }

    public String getDefaultValue(AppOption option) {
        String longTag = option.getLongTag();
        String defaultValue = this.optionDefaults.get(longTag);
        if (defaultValue == null) {
            String shortTag = option.getShortTag();
            defaultValue = this.optionDefaults.get(shortTag);
        }
        return defaultValue;
    }

    public Function<String, URL> getRuleLoader() {
        return this.ruleLoader;
    }
}

