/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.formatting;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.formatting.BasicFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.formatting.FormattingData;
import org.eclipse.xtext.xbase.formatting.FormattingPreferenceValues;
import org.eclipse.xtext.xbase.formatting.NewLineData;
import org.eclipse.xtext.xbase.formatting.TextReplacement;
import org.eclipse.xtext.xbase.formatting.WhitespaceData;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattableDocument {
    private static final Logger log = Logger.getLogger(FormattableDocument.class);
    private final FormattingPreferenceValues _cfg;
    private final String _document;
    private final TreeMap<Integer, FormattingData> _formattings;
    private Throwable _rootTrace = null;
    private boolean _conflictOccurred = false;

    public FormattingPreferenceValues getCfg() {
        return this._cfg;
    }

    public String getDocument() {
        return this._document;
    }

    public TreeMap<Integer, FormattingData> getFormattings() {
        return this._formattings;
    }

    public Throwable getRootTrace() {
        return this._rootTrace;
    }

    public void setRootTrace(Throwable rootTrace) {
        this._rootTrace = rootTrace;
    }

    public boolean isConflictOccurred() {
        return this._conflictOccurred;
    }

    public void setConflictOccurred(boolean conflictOccurred) {
        this._conflictOccurred = conflictOccurred;
    }

    public FormattableDocument(FormattingPreferenceValues cfg, String document) {
        this._cfg = cfg;
        this._document = document;
        TreeMap _treeMap = new TreeMap();
        this._formattings = _treeMap;
    }

    public FormattableDocument(FormattableDocument fmt) {
        String _document;
        FormattingPreferenceValues _cfg;
        this._cfg = _cfg = fmt.getCfg();
        this._document = _document = fmt.getDocument();
        TreeMap<Integer, FormattingData> _formattings = fmt.getFormattings();
        TreeMap<Integer, FormattingData> _treeMap = new TreeMap<Integer, FormattingData>((SortedMap<Integer, FormattingData>)_formattings);
        this._formattings = _treeMap;
    }

    public boolean isDebugConflicts() {
        Throwable _rootTrace = this.getRootTrace();
        boolean _notEquals = !Objects.equal((Object)_rootTrace, null);
        return _notEquals;
    }

    protected FormattingData addFormatting(FormattingData data) {
        boolean _notEquals;
        FormattingData _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)data, null);
        if (_notEquals) {
            boolean _notEquals_1;
            FormattingData _merge;
            boolean _greaterThan;
            boolean _lessThan;
            FormattingData _xblockexpression = null;
            int _length = data.getLength();
            boolean bl2 = _lessThan = _length < 0;
            if (_lessThan) {
                Pair<String, String> text = this.getTextAround(data);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"lenght of text-edit can not be negative:");
                _builder.newLine();
                _builder.append((Object)"--------------------------------- document snippet ------------------------------");
                _builder.newLine();
                String _key = (String)text.getKey();
                _builder.append((Object)_key, "");
                _builder.append((Object)"[[[!!]]]");
                String _value = (String)text.getValue();
                _builder.append((Object)_value, "");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"---------------------------------------------------------------------------------");
                _builder.newLine();
                log.error((Object)_builder);
                IllegalStateException _illegalStateException = new IllegalStateException("Length of text edit can not be negative");
                throw _illegalStateException;
            }
            int _length_1 = data.getLength();
            boolean bl3 = _greaterThan = _length_1 > 0;
            if (_greaterThan) {
                boolean _not;
                int _length_2;
                int _offset_1;
                int _plus;
                int _offset;
                String _document = this.getDocument();
                String oldText = _document.substring(_offset = data.getOffset(), _plus = (_offset_1 = data.getOffset()) + (_length_2 = data.getLength()));
                boolean _isWhitespace = this.isWhitespace(oldText);
                boolean bl4 = _not = !_isWhitespace;
                if (_not) {
                    Pair<String, String> text_1 = this.getTextAround(data);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Can not edit non-whitespace:");
                    _builder_1.newLine();
                    _builder_1.append((Object)"------------------------------- document snippet --------------------------------");
                    _builder_1.newLine();
                    String _key_1 = (String)text_1.getKey();
                    _builder_1.append((Object)_key_1, "");
                    _builder_1.append((Object)"[[[");
                    _builder_1.append((Object)oldText, "");
                    _builder_1.append((Object)"]]]");
                    String _value_1 = (String)text_1.getValue();
                    _builder_1.append((Object)_value_1, "");
                    _builder_1.newLineIfNotEmpty();
                    _builder_1.append((Object)"---------------------------------------------------------------------------------");
                    _builder_1.newLine();
                    log.error((Object)_builder_1);
                    IllegalStateException _illegalStateException_1 = new IllegalStateException("Can non format non-whitespace: " + oldText);
                    throw _illegalStateException_1;
                }
            }
            TreeMap<Integer, FormattingData> _formattings = this.getFormattings();
            int _offset_2 = data.getOffset();
            FormattingData old = _formattings.get(_offset_2);
            FormattingData _xifexpression_1 = null;
            boolean _equals = Objects.equal((Object)old, null);
            _xifexpression_1 = _equals ? data : (_merge = this.merge(old, data));
            FormattingData newData = _xifexpression_1;
            FormattingData _xifexpression_2 = null;
            boolean bl5 = _notEquals_1 = !Objects.equal((Object)newData, null);
            if (_notEquals_1) {
                FormattingData _put;
                TreeMap<Integer, FormattingData> _formattings_1 = this.getFormattings();
                int _offset_3 = data.getOffset();
                _xifexpression_2 = _put = _formattings_1.put(_offset_3, newData);
            }
            _xifexpression = _xblockexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    protected FormattingData merge(FormattingData data1, FormattingData data2) {
        boolean _notEquals;
        NewLineData _xblockexpression = null;
        FormattingData old = null;
        int increaseIndentationChange = 0;
        int decreaseIndentationChange = 0;
        int indentationChange = 0;
        boolean _isEmpty = data2.isEmpty();
        if (_isEmpty) {
            int _plus;
            int _indentationChange = data1.getIndentationChange();
            int _indentationChange_1 = data2.getIndentationChange();
            indentationChange = _plus = _indentationChange + _indentationChange_1;
            old = data1;
        } else {
            boolean _isEmpty_1 = data1.isEmpty();
            if (_isEmpty_1) {
                int _plus_1;
                int _indentationChange_2 = data2.getIndentationChange();
                int _indentationChange_3 = data1.getIndentationChange();
                indentationChange = _plus_1 = _indentationChange_2 + _indentationChange_3;
                old = data2;
            }
        }
        NewLineData _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal(old, null);
        if (_notEquals) {
            Throwable _trace;
            int _length;
            int _offset;
            NewLineData _xblockexpression_1 = null;
            if (indentationChange > 0) {
                increaseIndentationChange = indentationChange;
            } else {
                decreaseIndentationChange = indentationChange;
            }
            FormattingData _switchResult = null;
            boolean _matched = false;
            if (!_matched && old instanceof NewLineData) {
                NewLineData _newLineData;
                _matched = true;
                _offset = ((NewLineData)old).getOffset();
                _length = ((NewLineData)old).getLength();
                _trace = ((NewLineData)old).getTrace();
                Integer _newLines = ((NewLineData)old).getNewLines();
                _switchResult = _newLineData = new NewLineData(_offset, _length, increaseIndentationChange, decreaseIndentationChange, _trace, _newLines);
            }
            if (!_matched && old instanceof WhitespaceData) {
                _matched = true;
                _offset = ((WhitespaceData)old).getOffset();
                _length = ((WhitespaceData)old).getLength();
                _trace = ((WhitespaceData)old).getTrace();
                String _space = ((WhitespaceData)old).getSpace();
                WhitespaceData _whitespaceData = new WhitespaceData(_offset, _length, increaseIndentationChange, decreaseIndentationChange, _trace, _space);
                _switchResult = _whitespaceData;
            }
            _xifexpression = _xblockexpression_1 = _switchResult;
        } else {
            NewLineData _xblockexpression_2 = null;
            this.setConflictOccurred(true);
            boolean _isDebugConflicts = this.isDebugConflicts();
            if (_isDebugConflicts) {
                this.reportConflict(data1, data2);
            }
            _xifexpression = _xblockexpression_2 = null;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Pair<String, String> getTextAround(FormattingData data1) {
        Pair _mappedTo;
        Pair _xblockexpression = null;
        IntegerRange _upTo = new IntegerRange(0, 5);
        int _offset = data1.getOffset();
        Functions.Function2<Integer, Integer, Integer> _function = new Functions.Function2<Integer, Integer, Integer>(){

            public Integer apply(Integer last, Integer i) {
                int _xifexpression = 0;
                if (last > 0) {
                    int _lastIndexOf;
                    String _document = FormattableDocument.this.getDocument();
                    _xifexpression = _lastIndexOf = _document.lastIndexOf("\n", last - 1);
                } else {
                    _xifexpression = -1;
                }
                return _xifexpression;
            }
        };
        Integer back = (Integer)IterableExtensions.fold((Iterable)_upTo, (Object)_offset, (Functions.Function2)_function);
        IntegerRange _upTo_1 = new IntegerRange(0, 5);
        int _offset_1 = data1.getOffset();
        Functions.Function2<Integer, Integer, Integer> _function_1 = new Functions.Function2<Integer, Integer, Integer>(){

            public Integer apply(Integer last, Integer i) {
                int _xifexpression = 0;
                if (last > 0) {
                    int _indexOf;
                    String _document = FormattableDocument.this.getDocument();
                    _xifexpression = _indexOf = _document.indexOf("\n", last + 1);
                } else {
                    _xifexpression = -1;
                }
                return _xifexpression;
            }
        };
        Integer forward = (Integer)IterableExtensions.fold((Iterable)_upTo_1, (Object)_offset_1, (Functions.Function2)_function_1);
        Integer _xifexpression = null;
        _xifexpression = back >= 0 ? back : Integer.valueOf(0);
        Integer fiveLinesBackOffset = _xifexpression;
        Integer _xifexpression_1 = null;
        if (forward >= 0) {
            _xifexpression_1 = forward;
        } else {
            String _document = this.getDocument();
            int _length = _document.length();
            _xifexpression_1 = _length;
        }
        Integer fiveLinesForwardOffset = _xifexpression_1;
        String _document_1 = this.getDocument();
        int _offset_2 = data1.getOffset();
        String prefix = _document_1.substring(fiveLinesBackOffset, _offset_2);
        String _document_2 = this.getDocument();
        int _offset_3 = data1.getOffset();
        int _length_1 = data1.getLength();
        int _plus = _offset_3 + _length_1;
        String postfix = _document_2.substring(_plus, fiveLinesForwardOffset);
        _xblockexpression = _mappedTo = Pair.of((Object)prefix, (Object)postfix);
        return _xblockexpression;
    }

    protected void reportConflict(FormattingData data1, FormattingData data2) {
        Pair<String, String> text = this.getTextAround(data1);
        Throwable _rootTrace = this.getRootTrace();
        StackTraceElement[] _stackTrace = _rootTrace.getStackTrace();
        int _size = ((List)Conversions.doWrapArray((Object)_stackTrace)).size();
        int traceStart = _size - 1;
        Throwable _trace = data1.getTrace();
        StackTraceElement[] fullTrace1 = _trace.getStackTrace();
        int _size_1 = ((List)Conversions.doWrapArray((Object)fullTrace1)).size();
        int _minus = _size_1 - traceStart;
        List _subList = ((List)Conversions.doWrapArray((Object)fullTrace1)).subList(0, _minus);
        String shortTrace1 = IterableExtensions.join(_subList, (CharSequence)"\n");
        Throwable _trace_1 = data2.getTrace();
        StackTraceElement[] fullTrace2 = _trace_1.getStackTrace();
        int _size_2 = ((List)Conversions.doWrapArray((Object)fullTrace2)).size();
        int _minus_1 = _size_2 - traceStart;
        List _subList_1 = ((List)Conversions.doWrapArray((Object)fullTrace2)).subList(0, _minus_1);
        String shortTrace2 = IterableExtensions.join(_subList_1, (CharSequence)"\n");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"Conflicting TextEdits during formatting:");
        _builder.newLine();
        _builder.append((Object)"------------------------------- document snippet --------------------------------");
        _builder.newLine();
        String _key = (String)text.getKey();
        _builder.append((Object)_key, "");
        _builder.append((Object)"[!!!]");
        String _value = (String)text.getValue();
        _builder.append((Object)_value, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"---------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"TextEdit1: ");
        String _string = data1.toString();
        String _replaceAll = _string.replaceAll("\\n\\s*", " ");
        _builder.append((Object)_replaceAll, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"TextEdit2: ");
        String _string_1 = data2.toString();
        String _replaceAll_1 = _string_1.replaceAll("\\n\\s*", " ");
        _builder.append((Object)_replaceAll_1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"---------------------------------- Trace 1 --------------------------------------");
        _builder.newLine();
        _builder.append((Object)shortTrace1, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"---------------------------------- Trace 2 --------------------------------------");
        _builder.newLine();
        _builder.append((Object)shortTrace2, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"---------------------------------------------------------------------------------");
        _builder.newLine();
        log.error((Object)_builder);
    }

    public FormattingData operator_add(FormattingData data) {
        FormattingData _addFormatting = this.addFormatting(data);
        return _addFormatting;
    }

    public void operator_add(Iterable<FormattingData> data) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(data, null);
        if (_notEquals) {
            Procedures.Procedure1<FormattingData> _function = new Procedures.Procedure1<FormattingData>(){

                public void apply(FormattingData it) {
                    FormattableDocument.this.addFormatting(it);
                }
            };
            IterableExtensions.forEach(data, (Procedures.Procedure1)_function);
        }
    }

    public void operator_add(Functions.Function1<? super FormattableDocument, ? extends Iterable<FormattingData>> data) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal(data, null);
        if (_notEquals) {
            Iterable _apply = (Iterable)data.apply((Object)this);
            this.operator_add(_apply);
        }
    }

    public List<TextReplacement> renderToEdits() {
        String _document = this.getDocument();
        int _length = _document.length();
        List<TextReplacement> _renderToEdits = this.renderToEdits(0, _length);
        return _renderToEdits;
    }

    public List<TextReplacement> renderToEdits(int offset, int length) {
        ArrayList _xblockexpression = null;
        ArrayList replacements = CollectionLiterals.newArrayList((Object[])new TextReplacement[0]);
        int oldOffset = offset;
        int indentation = 0;
        TreeMap<Integer, FormattingData> _formattings = this.getFormattings();
        Collection<FormattingData> _values = _formattings.values();
        for (FormattingData f : _values) {
            int _plus_2;
            boolean _greaterEqualsThan;
            int _plus;
            int _indentationChange = f.getIndentationChange();
            indentation = _plus = indentation + _indentationChange;
            boolean _and = false;
            int _offset = f.getOffset();
            boolean bl = _greaterEqualsThan = _offset >= offset;
            if (!_greaterEqualsThan) {
                _and = false;
            } else {
                int _length;
                int _offset_1 = f.getOffset();
                int _plus_1 = _offset_1 + (_length = f.getLength());
                boolean _lessEqualsThan = _plus_1 <= offset + length;
                boolean bl2 = _and = _greaterEqualsThan && _lessEqualsThan;
            }
            if (!_and) continue;
            int _offset_2 = f.getOffset();
            int textlength = _offset_2 - oldOffset;
            boolean _matched = false;
            if (!_matched && f instanceof WhitespaceData) {
                boolean _notEquals;
                _matched = true;
                String _space = ((WhitespaceData)f).getSpace();
                boolean bl3 = _notEquals = !Objects.equal((Object)_space, null);
                if (_notEquals) {
                    String replacement = ((WhitespaceData)f).getSpace();
                    int _offset_3 = ((WhitespaceData)f).getOffset();
                    int _length_1 = ((WhitespaceData)f).getLength();
                    TextReplacement _textReplacement = new TextReplacement(_offset_3, _length_1, replacement);
                    replacements.add(_textReplacement);
                }
            }
            if (!_matched && f instanceof NewLineData) {
                int _decreaseIndentationChange;
                int _multiply;
                boolean _equals;
                _matched = true;
                int _xifexpression = 0;
                int _increaseIndentationChange = ((NewLineData)f).getIncreaseIndentationChange();
                boolean bl4 = _equals = _increaseIndentationChange == (_multiply = (_decreaseIndentationChange = ((NewLineData)f).getDecreaseIndentationChange()) * -1);
                if (_equals) {
                    int _plus_22;
                    int _increaseIndentationChange_1 = ((NewLineData)f).getIncreaseIndentationChange();
                    _xifexpression = _plus_22 = indentation + _increaseIndentationChange_1;
                } else {
                    _xifexpression = indentation;
                }
                int computedIndentation = _xifexpression;
                Integer _newLines = ((NewLineData)f).getNewLines();
                String _wrap = this.getWrap(_newLines);
                String _indentation = this.getIndentation(computedIndentation);
                String replacement = String.valueOf(_wrap) + _indentation;
                int _offset_3 = ((NewLineData)f).getOffset();
                int _length_1 = ((NewLineData)f).getLength();
                TextReplacement _textReplacement = new TextReplacement(_offset_3, _length_1, replacement);
                replacements.add(_textReplacement);
            }
            int _length_1 = f.getLength();
            oldOffset = _plus_2 = textlength + _length_1;
        }
        _xblockexpression = replacements;
        return _xblockexpression;
    }

    public String renderToString() {
        String _document = this.getDocument();
        int _length = _document.length();
        String _renderToString = this.renderToString(0, _length);
        return _renderToString;
    }

    public String renderToString(final int offset, int length) {
        String _string;
        StringBuilder _stringBuilder;
        String _xblockexpression = null;
        List<TextReplacement> edits = this.renderToEdits(offset, length);
        int lastOffset = offset;
        StringBuilder newDocument = _stringBuilder = new StringBuilder();
        Functions.Function1<TextReplacement, Integer> _function = new Functions.Function1<TextReplacement, Integer>(){

            public Integer apply(TextReplacement it) {
                return offset;
            }
        };
        List _sortBy = IterableExtensions.sortBy(edits, (Functions.Function1)_function);
        for (TextReplacement edit : _sortBy) {
            int _plus;
            String _document = this.getDocument();
            int _offset = edit.getOffset();
            String text = _document.substring(lastOffset, _offset);
            newDocument.append(text);
            String _text = edit.getText();
            newDocument.append(_text);
            int _offset_1 = edit.getOffset();
            int _length = edit.getLength();
            lastOffset = _plus = _offset_1 + _length;
        }
        String _document = this.getDocument();
        String text = _document.substring(lastOffset, offset + length);
        newDocument.append(text);
        _xblockexpression = _string = newDocument.toString();
        return _xblockexpression;
    }

    protected boolean isWhitespace(final String doc) {
        int _length = doc.length();
        int _minus = _length - 1;
        IntegerRange _upTo = new IntegerRange(0, _minus);
        Functions.Function1<Integer, Boolean> _function = new Functions.Function1<Integer, Boolean>(){

            public Boolean apply(Integer it) {
                char _charAt = doc.charAt(it);
                boolean _isWhitespace = Character.isWhitespace(_charAt);
                return _isWhitespace;
            }
        };
        boolean _forall = IterableExtensions.forall((Iterable)_upTo, (Functions.Function1)_function);
        return _forall;
    }

    public int lineLengthBefore(int offset) {
        int _plus_4;
        int lastOffset;
        int _xblockexpression = 0;
        int currentIndentation = 0;
        FormattingData lastWrap = null;
        int lastIndentation = 0;
        TreeMap<Integer, FormattingData> _formattings = this.getFormattings();
        Collection<FormattingData> _values = _formattings.values();
        for (FormattingData f : _values) {
            int _plus;
            boolean _lessThan;
            int _offset = f.getOffset();
            boolean bl = _lessThan = _offset < offset;
            if (!_lessThan) continue;
            int _indentationChange = f.getIndentationChange();
            currentIndentation = _plus = currentIndentation + _indentationChange;
            if (!(f instanceof NewLineData)) continue;
            lastWrap = (NewLineData)f;
            lastIndentation = currentIndentation;
        }
        int _offset_1 = lastWrap.getOffset();
        int _length = lastWrap.getLength();
        int lineStart = lastOffset = _offset_1 + _length;
        TreeMap<Integer, FormattingData> _formattings_1 = this.getFormattings();
        int _offset_2 = lastWrap.getOffset();
        int _plus_1 = _offset_2 + 1;
        SortedMap<Integer, FormattingData> _subMap = _formattings_1.subMap(_plus_1, offset);
        Collection<FormattingData> _values_1 = _subMap.values();
        for (FormattingData f_1 : _values_1) {
            int _plus_2;
            int _offset_3;
            String _document = this.getDocument();
            String text = _document.substring(lastOffset, _offset_3 = f_1.getOffset());
            int index = text.lastIndexOf("\n");
            if (index >= 0) {
                lineStart = index + lastOffset;
                currentIndentation = 0;
            }
            int _offset_4 = f_1.getOffset();
            int _length_1 = f_1.getLength();
            lastOffset = _plus_2 = _offset_4 + _length_1;
        }
        int lengthDiff = 0;
        TreeMap<Integer, FormattingData> _formattings_2 = this.getFormattings();
        int _offset_3 = lastWrap.getOffset();
        int _plus_2 = _offset_3 + 1;
        SortedMap<Integer, FormattingData> _subMap_1 = _formattings_2.subMap(_plus_2, offset);
        Collection<FormattingData> _values_2 = _subMap_1.values();
        for (FormattingData f_2 : _values_2) {
            int _minus;
            int _length_1;
            if (!(f_2 instanceof WhitespaceData)) continue;
            String space = ((WhitespaceData)f_2).getSpace();
            int _xifexpression = 0;
            boolean _equals = Objects.equal((Object)space, null);
            _xifexpression = _equals ? 0 : (_length_1 = space.length());
            int length = _xifexpression;
            int _length_2 = ((WhitespaceData)f_2).getLength();
            lengthDiff = _minus = lengthDiff + length - _length_2;
        }
        int _indentationLenght = this.getIndentationLenght(currentIndentation);
        int _plus_3 = offset - lineStart + _indentationLenght;
        _xblockexpression = _plus_4 = _plus_3 + lengthDiff;
        return _xblockexpression;
    }

    public String lookahead(int offset, int length, Procedures.Procedure1<? super FormattableDocument> format) {
        String _renderToString;
        FormattableDocument _formattableDocument;
        String _xblockexpression = null;
        FormattableDocument lookahead = _formattableDocument = new FormattableDocument(this);
        format.apply((Object)lookahead);
        _xblockexpression = _renderToString = lookahead.renderToString(offset, length);
        return _xblockexpression;
    }

    public boolean fitsIntoLine(int offset, int length, Procedures.Procedure1<? super FormattableDocument> format) {
        FormattingPreferenceValues _cfg;
        int _get;
        int _length;
        String lookahead = this.lookahead(offset, length, format);
        boolean _contains = lookahead.contains("\n");
        if (_contains) {
            return false;
        }
        int _lineLengthBefore = this.lineLengthBefore(offset);
        int line = _lineLengthBefore + (_length = lookahead.length());
        return line <= (_get = (_cfg = this.getCfg()).get(BasicFormatterPreferenceKeys.maxLineWidth));
    }

    public String toString() {
        String _string;
        StringBuilder _stringBuilder;
        String _xblockexpression = null;
        int lastOffset = 0;
        StringBuilder debugTrace = _stringBuilder = new StringBuilder();
        List<TextReplacement> _renderToEdits = this.renderToEdits();
        for (TextReplacement edit : _renderToEdits) {
            int _plus_1;
            String _document = this.getDocument();
            int _offset = edit.getOffset();
            String text = _document.substring(lastOffset, _offset);
            debugTrace.append(text);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"[");
            String _document_1 = this.getDocument();
            int _offset_1 = edit.getOffset();
            int _offset_2 = edit.getOffset();
            int _length = edit.getLength();
            int _plus = _offset_2 + _length;
            String _substring = _document_1.substring(_offset_1, _plus);
            _builder.append((Object)_substring, "");
            _builder.append((Object)"|");
            String _text = edit.getText();
            _builder.append((Object)_text, "");
            _builder.append((Object)"]");
            debugTrace.append((CharSequence)_builder);
            int _offset_3 = edit.getOffset();
            int _length_1 = edit.getLength();
            lastOffset = _plus_1 = _offset_3 + _length_1;
        }
        String _document = this.getDocument();
        String _document_1 = this.getDocument();
        int _length = _document_1.length();
        String text = _document.substring(lastOffset, _length);
        debugTrace.append(text);
        _xblockexpression = _string = debugTrace.toString();
        return _xblockexpression;
    }

    public String getIndentation(int levels) {
        String _xifexpression = null;
        if (levels > 0) {
            String _join;
            String _xblockexpression = null;
            FormattingPreferenceValues _cfg = this.getCfg();
            final String indent = _cfg.get(BasicFormatterPreferenceKeys.indentation);
            IntegerRange _upTo = new IntegerRange(0, levels - 1);
            Functions.Function1<Integer, String> _function = new Functions.Function1<Integer, String>(){

                public String apply(Integer it) {
                    return indent;
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_upTo, (Functions.Function1)_function);
            _xifexpression = _xblockexpression = (_join = IterableExtensions.join((Iterable)_map));
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    public int getIndentationLenght(int levels) {
        FormattingPreferenceValues _cfg = this.getCfg();
        int _get = _cfg.get(BasicFormatterPreferenceKeys.indentationLength);
        int _multiply = levels * _get;
        return _multiply;
    }

    public String getWrap(int levels) {
        String _xifexpression = null;
        if (levels > 0) {
            String _join;
            String _xblockexpression = null;
            FormattingPreferenceValues _cfg = this.getCfg();
            final String sep = _cfg.get(BasicFormatterPreferenceKeys.lineSeparator);
            IntegerRange _upTo = new IntegerRange(0, levels - 1);
            Functions.Function1<Integer, String> _function = new Functions.Function1<Integer, String>(){

                public String apply(Integer it) {
                    return sep;
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_upTo, (Functions.Function1)_function);
            _xifexpression = _xblockexpression = (_join = IterableExtensions.join((Iterable)_map));
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }
}

