/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.arguments.AssignmentFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.IFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.ReorderedFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.ReorderedVarArgFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.StandardFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.arguments.VarArgFeatureCallArguments;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionArgumentFactory {
    public IFeatureCallArguments createExpressionArguments(XExpression expression, AbstractLinkingCandidate<?> candidate) {
        JvmIdentifiableElement feature = candidate.getFeature();
        if (feature instanceof JvmExecutable) {
            JvmExecutable executable = (JvmExecutable)feature;
            return this.createArgumentsForExecutable(executable.isVarArgs(), candidate.getArguments(), (List<JvmFormalParameter>)executable.getParameters(), candidate.hasReceiver(), candidate.getState().getConverter());
        }
        if (expression instanceof XAssignment) {
            XAssignment assignment = (XAssignment)expression;
            LightweightTypeReference featureType = candidate.getActualType(candidate.getFeature(), true);
            return new AssignmentFeatureCallArguments(assignment.getValue(), featureType);
        }
        return new StandardFeatureCallArguments(candidate.getArguments(), Collections.<JvmFormalParameter>emptyList(), candidate.hasReceiver(), candidate.getState().getConverter());
    }

    protected IFeatureCallArguments createArgumentsForExecutable(boolean varArgs, List<XExpression> arguments, List<JvmFormalParameter> parameters, boolean hasReceiver, OwnedConverter converter) {
        if (!varArgs) {
            if (this.requiresReordering(arguments, parameters.size())) {
                ArrayList copiedArgumentList = Lists.newArrayList(arguments);
                ArrayList copiedParameterList = Lists.newArrayList(parameters);
                ArrayList shiftedArgumentList = Lists.newArrayListWithCapacity((int)2);
                ArrayList shiftedParameterList = Lists.newArrayListWithCapacity((int)2);
                this.reorder(varArgs, copiedArgumentList, copiedParameterList, shiftedArgumentList, shiftedParameterList);
                return new ReorderedFeatureCallArguments(copiedArgumentList, copiedParameterList, shiftedArgumentList, shiftedParameterList, hasReceiver, converter);
            }
            return new StandardFeatureCallArguments(arguments, parameters, hasReceiver, converter);
        }
        if (this.requiresReordering(arguments, parameters.size())) {
            ArrayList copiedArgumentList = Lists.newArrayList(arguments);
            ArrayList copiedParameterList = Lists.newArrayList(parameters);
            ArrayList shiftedArgumentList = Lists.newArrayListWithCapacity((int)2);
            ArrayList shiftedParameterList = Lists.newArrayListWithCapacity((int)2);
            this.reorder(varArgs, copiedArgumentList, copiedParameterList, shiftedArgumentList, shiftedParameterList);
            return new ReorderedVarArgFeatureCallArguments(copiedArgumentList, copiedParameterList, shiftedArgumentList, shiftedParameterList, hasReceiver, converter);
        }
        return new VarArgFeatureCallArguments(arguments, parameters, hasReceiver, converter);
    }

    protected void reorder(boolean varArgs, List<XExpression> copiedArgumentList, List<JvmFormalParameter> copiedParameterList, List<XExpression> shiftedArgumentList, List<JvmFormalParameter> shiftedParameterList) {
        int max = Math.min(copiedArgumentList.size(), copiedParameterList.size());
        if (varArgs && copiedArgumentList.size() >= copiedParameterList.size()) {
            --max;
        }
        int i = 0;
        while (i < max) {
            XExpression expression = copiedArgumentList.get(i);
            if (expression instanceof XClosure) {
                shiftedArgumentList.add(expression);
                shiftedParameterList.add(copiedParameterList.get(i));
            }
            ++i;
        }
        copiedArgumentList.removeAll(shiftedArgumentList);
        copiedParameterList.removeAll(shiftedParameterList);
    }

    protected boolean requiresReordering(List<XExpression> arguments, int parameterCount) {
        boolean lambdaSeen = false;
        int i = 0;
        while (i < arguments.size() && i < parameterCount) {
            if (arguments.get(i) instanceof XClosure) {
                lambdaSeen = true;
            } else if (lambdaSeen) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

