/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.validation.NotResolvedFeatureException;

public class ConstantExpressionValidator {
    @Inject
    @Extension
    private TypeReferences _typeReferences;
    @Inject
    @Extension
    private Primitives _primitives;
    @Inject
    @Extension
    private XExpressionHelper _xExpressionHelper;
    @Inject
    @Extension
    private ILogicalContainerProvider _iLogicalContainerProvider;

    protected boolean _isConstant(XExpression expression) {
        return false;
    }

    protected boolean _isConstant(XStringLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XTypeLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XNumberLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XBooleanLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XCastedExpression expression) {
        boolean _or = false;
        JvmTypeReference _type = expression.getType();
        boolean _isPrimitive = this._primitives.isPrimitive(_type);
        if (_isPrimitive) {
            _or = true;
        } else {
            boolean _is;
            JvmTypeReference _type_1 = expression.getType();
            _or = _is = this._typeReferences.is(_type_1, String.class);
        }
        return _or;
    }

    protected boolean _isConstant(XAbstractFeatureCall expression) {
        boolean _eIsProxy;
        JvmIdentifiableElement _feature;
        JvmIdentifiableElement feature = _feature = expression.getFeature();
        boolean _matched = false;
        if (!_matched && feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            return true;
        }
        if (!_matched && feature instanceof JvmField) {
            boolean _isFinal;
            _matched = true;
            boolean _isSetConstant = ((JvmField)feature).isSetConstant();
            if (_isSetConstant) {
                return ((JvmField)feature).isConstant();
            }
            boolean _and = false;
            boolean _isStatic = ((JvmField)feature).isStatic();
            _and = !_isStatic ? false : (_isFinal = ((JvmField)feature).isFinal());
            boolean potentiallyConstant = _and;
            if (potentiallyConstant) {
                Resource _eResource = ((JvmField)feature).eResource();
                if (_eResource instanceof TypeResource) {
                    return true;
                }
                XExpression _associatedExpression = this._iLogicalContainerProvider.getAssociatedExpression(feature);
                return this.isConstantExpression(_associatedExpression);
            }
            return false;
        }
        if (!_matched && feature instanceof JvmOperation) {
            Functions.Function1<JvmBooleanAnnotationValue, Boolean> _function;
            _matched = true;
            JvmAnnotationReference annotationReference = this._xExpressionHelper.findInlineAnnotation(expression);
            boolean _equals = Objects.equal((Object)annotationReference, null);
            if (_equals) {
                return false;
            }
            EList _values = annotationReference.getValues();
            Iterable _filter = Iterables.filter((Iterable)_values, JvmBooleanAnnotationValue.class);
            boolean _exists = IterableExtensions.exists((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<JvmBooleanAnnotationValue, Boolean>(){

                public Boolean apply(JvmBooleanAnnotationValue it) {
                    boolean _and = false;
                    String _valueName = it.getValueName();
                    boolean _equals = Objects.equal((Object)_valueName, (Object)"constantExpression");
                    if (!_equals) {
                        _and = false;
                    } else {
                        boolean _booleanValue;
                        EList _values = it.getValues();
                        Boolean _head = (Boolean)IterableExtensions.head((Iterable)_values);
                        _and = _booleanValue = _head.booleanValue();
                    }
                    return _and;
                }
            }));
            if (_exists) {
                boolean _xifexpression = false;
                XExpression _actualReceiver = expression.getActualReceiver();
                boolean _equals_1 = Objects.equal((Object)_actualReceiver, null);
                if (_equals_1) {
                    _xifexpression = true;
                } else {
                    XExpression _actualReceiver_1 = expression.getActualReceiver();
                    _xifexpression = this.isConstant(_actualReceiver_1);
                }
                boolean receiverConstant = _xifexpression;
                boolean _and = false;
                if (!receiverConstant) {
                    _and = false;
                } else {
                    boolean _forall;
                    EList<XExpression> _actualArguments = expression.getActualArguments();
                    Functions.Function1<XExpression, Boolean> _function_1 = new Functions.Function1<XExpression, Boolean>(){

                        public Boolean apply(XExpression it) {
                            return ConstantExpressionValidator.this.isConstant(it);
                        }
                    };
                    _and = _forall = IterableExtensions.forall(_actualArguments, (Functions.Function1)_function_1);
                }
                return _and;
            }
        }
        if (!_matched && feature instanceof XVariableDeclaration) {
            boolean _not;
            _matched = true;
            boolean _and = false;
            boolean _isWriteable = ((XVariableDeclaration)feature).isWriteable();
            boolean bl = _not = !_isWriteable;
            if (!_not) {
                _and = false;
            } else {
                boolean _isConstantExpression;
                XExpression _right = ((XVariableDeclaration)feature).getRight();
                _and = _isConstantExpression = this.isConstantExpression(_right);
            }
            return _and;
        }
        if (!_matched && feature instanceof XSwitchExpression) {
            _matched = true;
            XExpression _switch = ((XSwitchExpression)feature).getSwitch();
            return this.isConstantExpression(_switch);
        }
        if (!_matched && feature instanceof EObject && (_eIsProxy = feature.eIsProxy())) {
            _matched = true;
            throw new NotResolvedFeatureException();
        }
        return false;
    }

    protected boolean _isConstantExpression(Void it) {
        return false;
    }

    protected boolean _isConstantExpression(XExpression it) {
        return this.isConstant(it);
    }

    protected boolean _isConstantExpression(XAbstractFeatureCall it) {
        boolean _switchResult = false;
        JvmIdentifiableElement _feature = it.getFeature();
        boolean _matched = false;
        if (!_matched && _feature instanceof JvmEnumerationLiteral) {
            _matched = true;
            _switchResult = false;
        }
        if (!_matched) {
            _switchResult = this.isConstant(it);
        }
        return _switchResult;
    }

    public boolean isConstant(XExpression expression) {
        if (expression instanceof XAbstractFeatureCall) {
            return this._isConstant((XAbstractFeatureCall)expression);
        }
        if (expression instanceof XBooleanLiteral) {
            return this._isConstant((XBooleanLiteral)expression);
        }
        if (expression instanceof XCastedExpression) {
            return this._isConstant((XCastedExpression)expression);
        }
        if (expression instanceof XNumberLiteral) {
            return this._isConstant((XNumberLiteral)expression);
        }
        if (expression instanceof XStringLiteral) {
            return this._isConstant((XStringLiteral)expression);
        }
        if (expression instanceof XTypeLiteral) {
            return this._isConstant((XTypeLiteral)expression);
        }
        if (expression != null) {
            return this._isConstant(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }

    public boolean isConstantExpression(XExpression it) {
        if (it instanceof XAbstractFeatureCall) {
            return this._isConstantExpression((XAbstractFeatureCall)it);
        }
        if (it != null) {
            return this._isConstantExpression(it);
        }
        if (it == null) {
            return this._isConstantExpression((Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

