/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractNestedFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorScopes;
import org.eclipse.xtext.xbase.scoping.batch.ExpressionBucket;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithCapturedLocalElements;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithContext;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithDynamicExtensions;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithLocalElements;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithNestedTypes;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithStaticTypes;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeSessionWithoutLocalElements;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopes;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.ITypeImporter;
import org.eclipse.xtext.xbase.scoping.batch.InstanceFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.batch.TypeImporter;
import org.eclipse.xtext.xbase.scoping.batch.TypeScopes;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedFeatures;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureScopeSession
implements IFeatureScopeSession {
    @Override
    public IScope getScope(EObject context, EReference reference, IResolvedTypes types) {
        if (this.getFeatureScopes().isFeatureCallScope(reference)) {
            return this.createFeatureCallScope(context, reference, types);
        }
        if (this.getConstructorScopes().isConstructorCallScope(reference)) {
            return this.createConstructorScope(context, reference, types);
        }
        if (this.getTypeScopes().isTypeScope(reference)) {
            return this.createTypeScope(context, reference, types);
        }
        return this.getDefaultScopeProvider().getScope(context, reference);
    }

    @Override
    public IFeatureScopeSession addTypesToStaticScope(List<? extends JvmType> staticFeatureProviders, List<? extends JvmType> extensionProviders) {
        if (staticFeatureProviders.isEmpty() && extensionProviders.isEmpty()) {
            return this;
        }
        FeatureScopeSessionWithStaticTypes result = new FeatureScopeSessionWithStaticTypes(this, staticFeatureProviders, extensionProviders, this.getResolvedFeaturesProvider());
        return result;
    }

    @Override
    public IFeatureScopeSession addImports(ITypeImporter.Client importer) {
        return new TypeImporter().process(this, importer);
    }

    protected abstract IResolvedFeatures.Provider getResolvedFeaturesProvider();

    protected abstract FeatureScopes getFeatureScopes();

    protected abstract ConstructorScopes getConstructorScopes();

    protected abstract TypeScopes getTypeScopes();

    protected abstract IScopeProvider getDefaultScopeProvider();

    protected abstract int getId();

    @Override
    public IFeatureScopeSession addToExtensionScope(Map<XExpression, LightweightTypeReference> extensionProviders) {
        if (extensionProviders.isEmpty()) {
            return this;
        }
        FeatureScopeSessionWithDynamicExtensions result = new FeatureScopeSessionWithDynamicExtensions(this, extensionProviders, this.getResolvedFeaturesProvider());
        return result;
    }

    @Override
    public IFeatureScopeSession addNestedTypesToScope(JvmDeclaredType type) {
        return new FeatureScopeSessionWithNestedTypes(this, type);
    }

    @Override
    public List<JvmDeclaredType> getEnclosingTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<JvmDeclaredType> getNestedTypeDeclarators() {
        return Collections.emptyList();
    }

    @Override
    public IFeatureScopeSession getNextCaptureLayer() {
        return null;
    }

    @Override
    public IFeatureScopeSession toInstanceContext() {
        return new InstanceFeatureScopeSession(this);
    }

    @Override
    public IFeatureScopeSession toConstructorContext() {
        return new ConstructorFeatureScopeSession(this);
    }

    @Override
    public IFeatureScopeSession dropLocalElements() {
        return new FeatureScopeSessionWithoutLocalElements(this);
    }

    @Override
    public IFeatureScopeSession captureLocalElements() {
        return new FeatureScopeSessionWithCapturedLocalElements(this);
    }

    @Override
    public IFeatureScopeSession addLocalElement(QualifiedName name, JvmIdentifiableElement element, ITypeReferenceOwner owner) {
        IFeatureScopeSession result = this.addLocalElements(Collections.singletonMap(name, element), owner);
        return result;
    }

    @Override
    public IFeatureScopeSession addLocalElements(Map<QualifiedName, JvmIdentifiableElement> elements, ITypeReferenceOwner owner) {
        if (elements.isEmpty()) {
            return this;
        }
        AbstractNestedFeatureScopeSession result = this.tryCreateNestedSessionWithVisibilityContext(elements, owner, IFeatureNames.THIS);
        if (result != null) {
            return result;
        }
        result = this.tryCreateNestedSessionWithVisibilityContext(elements, owner, IFeatureNames.SELF);
        if (result != null) {
            return result;
        }
        result = new FeatureScopeSessionWithLocalElements(this, elements);
        return result;
    }

    protected AbstractNestedFeatureScopeSession tryCreateNestedSessionWithVisibilityContext(Map<QualifiedName, JvmIdentifiableElement> elements, ITypeReferenceOwner owner, QualifiedName thisName) {
        JvmIdentifiableElement associatedWithThis;
        if (elements.containsKey(thisName) && (associatedWithThis = elements.get(thisName)) instanceof JvmType) {
            IEObjectDescription thisDescription;
            if (IFeatureNames.SELF.equals((Object)thisName) && (thisDescription = this.getLocalElement(IFeatureNames.THIS)) != null && thisDescription.getEObjectOrProxy() instanceof JvmDeclaredType) {
                JvmDeclaredType thisType = (JvmDeclaredType)thisDescription.getEObjectOrProxy();
                ParameterizedTypeReference context = new ParameterizedTypeReference(owner, (JvmType)associatedWithThis);
                FeatureScopeSessionWithContext contextSession = new FeatureScopeSessionWithContext(this, context, thisType.getPackageName());
                FeatureScopeSessionWithLocalElements result = new FeatureScopeSessionWithLocalElements(contextSession, elements);
                return result;
            }
            ParameterizedTypeReference context = new ParameterizedTypeReference(owner, (JvmType)associatedWithThis);
            FeatureScopeSessionWithContext contextSession = new FeatureScopeSessionWithContext(this, context);
            FeatureScopeSessionWithLocalElements result = new FeatureScopeSessionWithLocalElements(contextSession, elements);
            return result;
        }
        return null;
    }

    protected IScope createFeatureCallScope(EObject context, EReference reference, IResolvedTypes resolvedTypes) {
        return this.getFeatureScopes().createFeatureCallScope(context, reference, this, resolvedTypes);
    }

    protected IScope createConstructorScope(EObject context, EReference reference, IResolvedTypes resolvedTypes) {
        return this.getConstructorScopes().createConstructorScope(context, reference, this, resolvedTypes);
    }

    protected IScope createTypeScope(EObject context, EReference reference, IResolvedTypes resolvedTypes) {
        return this.getTypeScopes().createTypeScope(context, reference, this, resolvedTypes);
    }

    @Override
    public Collection<IEObjectDescription> getLocalElements() {
        ArrayList result = Lists.newArrayListWithCapacity((int)3);
        this.addLocalElements(result);
        return result;
    }

    protected void addLocalElements(List<IEObjectDescription> result) {
    }

    @Override
    public List<TypeBucket> getStaticallyImportedTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<TypeBucket> getStaticallyImportedExtensionTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<ExpressionBucket> getExtensionProviders() {
        return Collections.emptyList();
    }

    protected void addExtensionProviders(List<ExpressionBucket> result) {
    }
}

