/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorDescription;
import org.eclipse.xtext.xbase.scoping.batch.ConstructorTypeScopeWrapper;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeScopes;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;

public class ConstructorScopes {
    public static final int CONSTRUCTOR_BUCKET = 1;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private TypeScopes typeScopes;

    public IScope createConstructorScope(EObject context, EReference reference, IFeatureScopeSession session, IResolvedTypes resolvedTypes) {
        if (!(context instanceof XConstructorCall)) {
            return IScope.NULLSCOPE;
        }
        IScope delegateScope = this.typeScopes.createTypeScope(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, session, resolvedTypes);
        ConstructorTypeScopeWrapper result = new ConstructorTypeScopeWrapper(context, session, delegateScope);
        return result;
    }

    protected IScope createAnonymousClassConstructorScope(final JvmGenericType anonymousType, EObject context, IFeatureScopeSession session) {
        IVisibilityHelper protectedIsVisible = new IVisibilityHelper(){

            public boolean isVisible(JvmMember member) {
                return member.getVisibility() != JvmVisibility.PRIVATE;
            }
        };
        return new ConstructorTypeScopeWrapper(context, protectedIsVisible, IScope.NULLSCOPE){

            @Override
            public Iterable<IEObjectDescription> getElements(EObject object) {
                throw new UnsupportedOperationException("TODO implement as necessary");
            }

            @Override
            public Iterable<IEObjectDescription> getElements(QualifiedName name) {
                JvmTypeReference superType = (JvmTypeReference)anonymousType.getSuperTypes().get(0);
                if (superType == null) {
                    return Collections.emptyList();
                }
                JvmType type = superType.getType();
                if (type == null) {
                    return Collections.emptyList();
                }
                QualifiedName typeName = ConstructorScopes.this.qualifiedNameConverter.toQualifiedName(type.getQualifiedName('.'));
                if (typeName.getSegmentCount() > name.getSegmentCount()) {
                    typeName = typeName.skipFirst(typeName.getSegmentCount() - name.getSegmentCount());
                }
                if (!typeName.equals((Object)name)) {
                    if (name.getSegmentCount() == 1 && name.getFirstSegment().indexOf(36) > 0) {
                        QualifiedName splitted = QualifiedName.create((List)Strings.split((String)name.getFirstSegment(), (char)'$'));
                        typeName = ConstructorScopes.this.qualifiedNameConverter.toQualifiedName(type.getQualifiedName('.'));
                        if (typeName.getSegmentCount() > splitted.getSegmentCount()) {
                            typeName = typeName.skipFirst(typeName.getSegmentCount() - splitted.getSegmentCount());
                        }
                        if (!typeName.equals((Object)splitted)) {
                            return Collections.emptyList();
                        }
                    } else {
                        return Collections.emptyList();
                    }
                }
                IEObjectDescription typeDescription = EObjectDescription.create((QualifiedName)name, (EObject)anonymousType);
                return this.createFeatureDescriptions(Collections.singletonList(typeDescription));
            }

            @Override
            protected ConstructorDescription createConstructorDescription(IEObjectDescription typeDescription, JvmConstructor constructor, boolean visible) {
                return ConstructorScopes.this.createAnonmousClassConstructorDescription(typeDescription.getName(), constructor, visible);
            }
        };
    }

    protected ConstructorDescription createAnonmousClassConstructorDescription(QualifiedName name, JvmConstructor constructor, boolean visible) {
        ConstructorDescription result = new ConstructorDescription(name, constructor, 1, visible, true);
        return result;
    }

    public boolean isConstructorCallScope(EReference reference) {
        return reference == XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR;
    }
}

