/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.junit4.TemporaryFolder;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.compiler.ElementIssueProvider;
import org.eclipse.xtext.xbase.compiler.OnTheFlyJavaCompiler;
import org.eclipse.xtext.xbase.compiler.RegisteringFileSystemAccess;
import org.eclipse.xtext.xbase.file.ProjectConfig;
import org.eclipse.xtext.xbase.file.RuntimeWorkspaceConfigProvider;
import org.eclipse.xtext.xbase.file.SimpleWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

public class CompilationTestHelper {
    public static final String PROJECT_NAME = "myProject";
    @Inject
    private TemporaryFolder temporaryFolder;
    @Inject
    private OnTheFlyJavaCompiler javaCompiler;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private FileExtensionProvider extensionProvider;
    @Inject
    private IOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private Provider<Result> resultProvider;
    private RuntimeWorkspaceConfigProvider configProvider;

    @Inject
    private void setWorkspaceConfig(RuntimeWorkspaceConfigProvider configProvider) {
        this.configProvider = configProvider;
        this.configureFreshWorkspace();
    }

    public void configureFreshWorkspace() {
        File tempDir = this.createFreshTempDir();
        SimpleWorkspaceConfig config = new SimpleWorkspaceConfig(tempDir.getAbsolutePath());
        ProjectConfig projectConfig = new ProjectConfig(PROJECT_NAME);
        OutputConfiguration outputConfig = null;
        for (OutputConfiguration outputConfiguration : this.getOutputConfigurations()) {
            if (!outputConfiguration.getName().equals("DEFAULT_OUTPUT")) continue;
            outputConfig = outputConfiguration;
            break;
        }
        if (outputConfig == null) {
            throw new IllegalStateException("No default output configuration could be found!");
        }
        if (!outputConfig.isUseOutputPerSourceFolder()) {
            String string = outputConfig.getOutputDirectory("src");
            projectConfig.addSourceFolderMapping("src", string);
        } else {
            for (String string : outputConfig.getSourceFolders()) {
                String out = outputConfig.getOutputDirectory(string);
                projectConfig.addSourceFolderMapping(string, out);
            }
        }
        config.addProjectConfig(projectConfig);
        this.configProvider.setWorkspaceConfig(config);
    }

    protected String getSourceFolderPath() {
        return "/myProject/src";
    }

    protected File createFreshTempDir() {
        try {
            return this.temporaryFolder.newFolder();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setJavaCompilerClassPath(Class<?> ... classes) {
        this.javaCompiler.clearClassPath();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            this.javaCompiler.addClassPathOfClass(clazz);
            ++n2;
        }
    }

    public void assertCompilesTo(CharSequence source, final CharSequence expected) throws IOException {
        final boolean[] called = new boolean[1];
        this.compile(source, new IAcceptor<Result>(){

            public void accept(Result r) {
                Assert.assertEquals((Object)expected.toString(), (Object)r.getSingleGeneratedCode());
                called[0] = true;
            }
        });
        Assert.assertTrue((String)("Nothing was generated but the expectation was :\n" + expected), (boolean)called[0]);
    }

    public void compile(CharSequence source, IAcceptor<Result> acceptor) throws IOException {
        String fileName = "MyFile." + this.extensionProvider.getPrimaryFileExtension();
        this.compile(this.resourceSet(new Pair((Object)fileName, (Object)source)), acceptor);
    }

    public void compile(Iterable<? extends CharSequence> sources, IAcceptor<Result> acceptor) throws IOException {
        int index = 0;
        ArrayList pairs = Lists.newArrayList();
        for (CharSequence charSequence : sources) {
            String fileName = "MyFile" + ++index + "." + this.extensionProvider.getPrimaryFileExtension();
            pairs.add(new Pair((Object)fileName, (Object)charSequence));
        }
        this.compile(this.resourceSet((Pair[])Conversions.unwrapArray((Object)pairs, Pair.class)), acceptor);
    }

    public void compile(ResourceSet resourceSet, IAcceptor<Result> acceptor) {
        try {
            ArrayList resourcesToCheck = Lists.newArrayList((Iterable)resourceSet.getResources());
            Result result = (Result)this.resultProvider.get();
            result.setJavaCompiler(this.javaCompiler);
            result.setCheckMode(this.getCheckMode());
            result.setResources(resourcesToCheck);
            result.setResourceSet(resourceSet);
            result.setOutputConfigurations(this.getOutputConfigurations());
            result.doGenerate();
            acceptor.accept((Object)result);
        }
        catch (Exception e) {
            Exceptions.throwUncheckedException((Throwable)e);
        }
    }

    protected CheckMode getCheckMode() {
        return CheckMode.NORMAL_AND_FAST;
    }

    protected Iterable<? extends OutputConfiguration> getOutputConfigurations() {
        return this.outputConfigurationProvider.getOutputConfigurations();
    }

    public ResourceSet resourceSet(Pair<String, ? extends CharSequence> ... resources) throws IOException {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        Pair<String, ? extends CharSequence>[] pairArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, ? extends CharSequence> entry = pairArray[n2];
            URI uri = this.copyToWorkspace(String.valueOf(this.getSourceFolderPath()) + "/" + (String)entry.getKey(), (CharSequence)entry.getValue());
            Resource resource = result.createResource(uri);
            if (resource == null) {
                throw new IllegalStateException("Couldn't create resource for URI " + uri + ". Resource.Factory not registered?");
            }
            resource.load((Map)Maps.newHashMap());
            ++n2;
        }
        return result;
    }

    public URI copyToWorkspace(String workspacefilePath, CharSequence contents) {
        File workspaceRoot = new File(this.configProvider.getWorkspaceConfig().getAbsoluteFileSystemPath());
        File fullPath = new File(String.valueOf(workspaceRoot.getAbsolutePath()) + "/" + workspacefilePath);
        if (fullPath.exists()) {
            fullPath.delete();
        } else {
            this.mkDir(fullPath.getParentFile());
        }
        URI uri = URI.createFileURI((String)fullPath.getAbsolutePath());
        Files.writeStringIntoFile((String)uri.toFileString(), (String)contents.toString());
        return uri;
    }

    private void mkDir(File file) {
        if (!file.getParentFile().exists()) {
            this.mkDir(file.getParentFile());
        }
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public ResourceSet unLoadedResourceSet(Pair<String, ? extends CharSequence> ... resources) throws IOException {
        XtextResourceSet result = (XtextResourceSet)this.resourceSetProvider.get();
        Pair<String, ? extends CharSequence>[] pairArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<String, ? extends CharSequence> entry = pairArray[n2];
            URI uri = this.copyToWorkspace(String.valueOf(this.getSourceFolderPath()) + "/" + (String)entry.getKey(), (CharSequence)entry.getValue());
            Resource resource = result.createResource(uri);
            if (resource == null) {
                throw new IllegalStateException("Couldn't create resource for URI " + uri + ". Resource.Factory not registered?");
            }
            ++n2;
        }
        return result;
    }

    public static class Result {
        @Inject
        private IResourceServiceProvider.Registry serviceRegistry;
        @Inject
        private Provider<RegisteringFileSystemAccess> fileSystemAccessProvider;
        @Inject
        private ElementIssueProvider.Factory elementIssueProviderFactory;
        private OnTheFlyJavaCompiler javaCompiler;
        private ResourceSet resourceSet;
        private List<Resource> sources;
        private Map<String, OutputConfiguration> outputConfigurations;
        private CheckMode checkMode;
        private ClassLoader classLoader;
        private Map<String, Class<?>> compiledClasses;
        private Map<String, String> generatedCode;
        private RegisteringFileSystemAccess access;
        private ResourceDescriptionsData index;
        private List<Issue> allErrorsAndWarnings;

        protected void setResourceSet(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        protected void setCheckMode(CheckMode checkMode) {
            this.checkMode = checkMode;
        }

        protected void setResources(List<Resource> sources) {
            this.sources = sources;
        }

        protected void setJavaCompiler(OnTheFlyJavaCompiler javaCompiler) {
            this.javaCompiler = javaCompiler;
        }

        protected void setOutputConfigurations(Iterable<? extends OutputConfiguration> outputConfiguration) {
            this.outputConfigurations = Maps.newHashMap();
            for (OutputConfiguration outputConfiguration2 : outputConfiguration) {
                this.outputConfigurations.put(outputConfiguration2.getName(), outputConfiguration2);
            }
        }

        public List<Issue> getErrorsAndWarnings() {
            this.doValidation();
            return this.allErrorsAndWarnings;
        }

        public Map<String, Class<?>> getCompiledClasses() {
            this.doCompile();
            return this.compiledClasses;
        }

        public ClassLoader getClassLoader() {
            this.doCompile();
            return this.classLoader;
        }

        public Map<String, String> getGeneratedCode() {
            this.doGenerate();
            return this.generatedCode;
        }

        public String getGeneratedCode(String typeName) {
            return this.getGeneratedCode().get(typeName);
        }

        public String getSingleGeneratedCode() {
            this.doGenerate();
            if (this.access.getTextFiles().size() == 1) {
                return this.access.getTextFiles().iterator().next().getContents().toString();
            }
            String separator = System.getProperty("line.separator");
            if (separator == null) {
                separator = "\n";
            }
            ArrayList files = Lists.newArrayList(this.access.getTextFiles());
            Collections.sort(files, new Comparator<RegisteringFileSystemAccess.GeneratedFile>(){

                @Override
                public int compare(RegisteringFileSystemAccess.GeneratedFile o1, RegisteringFileSystemAccess.GeneratedFile o2) {
                    return o1.getPath().toString().compareTo(o2.getPath().toString());
                }
            });
            StringBuilder result = new StringBuilder("MULTIPLE FILES WERE GENERATED" + separator + separator);
            int i = 1;
            for (RegisteringFileSystemAccess.GeneratedFile file : files) {
                result.append("File " + i + " : " + file.getPath().toString() + separator + separator);
                result.append(file.getContents()).append(separator);
                ++i;
            }
            return result.toString();
        }

        public ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        public Class<?> getCompiledClass() {
            return (Class)IterableExtensions.head(this.getCompiledClasses().values());
        }

        public Class<?> getCompiledClass(String className) {
            return this.getCompiledClasses().get(className);
        }

        public Map<String, CharSequence> getAllGeneratedResources() {
            this.doGenerate();
            HashMap result = Maps.newHashMap();
            for (RegisteringFileSystemAccess.GeneratedFile f : this.access.getTextFiles()) {
                result.put(f.getPath().toString(), f.getContents());
            }
            return result;
        }

        protected void doIndex() {
            if (this.index == null) {
                ArrayList descriptions = Lists.newArrayList();
                for (Resource resource : this.sources) {
                    IResourceServiceProvider serviceProvider = this.serviceRegistry.getResourceServiceProvider(resource.getURI());
                    IResourceDescription description = serviceProvider.getResourceDescriptionManager().getResourceDescription(resource);
                    descriptions.add(description);
                }
                this.index = new ResourceDescriptionsData((Iterable)descriptions);
                ResourceDescriptionsData.ResourceSetAdapter.installResourceDescriptionsData((ResourceSet)this.resourceSet, (ResourceDescriptionsData)this.index);
            }
        }

        protected void doLinking() {
            this.doIndex();
            for (Resource resource : this.sources) {
                EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)CancelIndicator.NullImpl);
            }
        }

        protected void doValidation() {
            if (this.allErrorsAndWarnings == null) {
                this.doLinking();
                this.allErrorsAndWarnings = Lists.newArrayList();
                for (Resource resource : this.sources) {
                    if (!(resource instanceof XtextResource)) continue;
                    XtextResource xtextResource = (XtextResource)resource;
                    List issues = xtextResource.getResourceServiceProvider().getResourceValidator().validate((Resource)xtextResource, this.checkMode, CancelIndicator.NullImpl);
                    for (Issue issue : issues) {
                        this.allErrorsAndWarnings.add(issue);
                    }
                }
            }
        }

        protected void doGenerate() {
            if (this.access == null) {
                this.doValidation();
                this.access = (RegisteringFileSystemAccess)((Object)this.fileSystemAccessProvider.get());
                this.access.setOutputConfigurations(this.outputConfigurations);
                this.access.setCurrentSource("src");
                this.access.setProjectName(CompilationTestHelper.PROJECT_NAME);
                for (Resource resource : this.sources) {
                    XtextResource xtextResource;
                    IGenerator generator;
                    if (!(resource instanceof XtextResource) || (generator = (IGenerator)(xtextResource = (XtextResource)resource).getResourceServiceProvider().get(IGenerator.class)) == null) continue;
                    try {
                        this.elementIssueProviderFactory.attachData((Resource)xtextResource);
                        generator.doGenerate((Resource)xtextResource, (IFileSystemAccess)this.access);
                    }
                    finally {
                        this.elementIssueProviderFactory.detachData((Resource)xtextResource);
                    }
                }
                this.generatedCode = Maps.newHashMap();
                for (RegisteringFileSystemAccess.GeneratedFile e : this.access.getTextFiles()) {
                    if (e.getJavaClassName() == null) continue;
                    this.generatedCode.put(e.getJavaClassName(), e.getContents().toString());
                }
            }
        }

        protected void doCompile() {
            if (this.compiledClasses == null || this.classLoader == null) {
                this.doGenerate();
                try {
                    org.eclipse.xtext.util.Pair<ClassLoader, Map<String, Class<?>>> compilationResult = this.javaCompiler.internalCompileToClasses(this.getGeneratedCode());
                    this.classLoader = (ClassLoader)compilationResult.getFirst();
                    this.compiledClasses = (Map)compilationResult.getSecond();
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }
}

