/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.FeatureStoreServices;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"FeatureStore"}, description="The API for accessing the store of all features")
@RestController
@RequestMapping(value={"/api/ff4j/store"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0017J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0017J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0017J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0017J\b\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/FeatureStoreResource;", "", "featureStoreService", "Lorg/ff4j/services/FeatureStoreServices;", "(Lorg/ff4j/services/FeatureStoreServices;)V", "getFeatureStoreService", "()Lorg/ff4j/services/FeatureStoreServices;", "clearCachedFeatureStore", "Lorg/springframework/http/ResponseEntity;", "deleteAllFeatures", "getAllFeatures", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "getAllGroups", "Lorg/ff4j/services/domain/GroupDescApiBean;", "getFeatureStore", "Lorg/ff4j/services/domain/FeatureStoreApiBean;", "getFeaturesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "ff4j-spring-boot-web-api"})
public class FeatureStoreResource {
    @NotNull
    private final FeatureStoreServices featureStoreService;

    public FeatureStoreResource(@Autowired @NotNull FeatureStoreServices featureStoreService) {
        Intrinsics.checkNotNullParameter((Object)featureStoreService, (String)"featureStoreService");
        this.featureStoreService = featureStoreService;
    }

    @NotNull
    public FeatureStoreServices getFeatureStoreService() {
        return this.featureStoreService;
    }

    @GetMapping(produces={"application/json"})
    @ApiOperation(value="Displays information regarding the FeaturesStore", response=FeatureStoreApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="status of current feature store", response=FeatureStoreApiBean.class)})
    @NotNull
    public FeatureStoreApiBean getFeatureStore() {
        return this.getFeatureStoreService().getFeatureStore();
    }

    @GetMapping(value={"/features"}, produces={"application/json"})
    @ApiOperation(value="Displays all the Features", response=FeatureApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="get all features")})
    @NotNull
    public Collection<FeatureApiBean> getAllFeatures() {
        return this.getFeatureStoreService().getAllFeatures();
    }

    @GetMapping(value={"/groups"}, produces={"application/json"})
    @ApiOperation(value="Display information regarding Groups", response=GroupDescApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Groups resource", response=GroupDescApiBean.class)})
    @NotNull
    public Collection<GroupDescApiBean> getAllGroups() {
        return this.getFeatureStoreService().getAllGroups();
    }

    @GetMapping(value={"/cache"}, produces={"application/json"})
    @ApiOperation(value="Display information related to Cache")
    @ApiResponses(value={@ApiResponse(code=200, message="Gets the cached features", response=CacheApiBean.class), @ApiResponse(code=404, message="feature store is not cached")})
    @NotNull
    public CacheApiBean getFeaturesFromCache() {
        return this.getFeatureStoreService().getFeaturesFromCache();
    }

    @DeleteMapping(value={"/clear"})
    @ApiOperation(value="Delete all Features in store")
    @ApiResponses(value={@ApiResponse(code=204, message="all feature have been deleted")})
    @NotNull
    public ResponseEntity<Object> deleteAllFeatures() {
        this.getFeatureStoreService().deleteAllFeatures();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @DeleteMapping(value={"//clearCache"})
    @ApiOperation(value="Clear cache", response=ResponseEntity.class)
    @ApiResponses(value={@ApiResponse(code=204, message="cache is cleared"), @ApiResponse(code=404, message="feature store is not cached")})
    @NotNull
    public ResponseEntity<Object> clearCachedFeatureStore() {
        this.getFeatureStoreService().clearCachedFeatureStore();
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

