/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.fluentlenium.configuration.BaseConfiguration;
import org.fluentlenium.configuration.CapabilitiesFactory;
import org.fluentlenium.configuration.CapabilitiesRegistry;
import org.fluentlenium.configuration.ConfigurationDefaults;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.CustomProperty;
import org.fluentlenium.configuration.DefaultConfigurationFactory;
import org.fluentlenium.configuration.FluentConfiguration;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonException;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class AnnotationConfiguration
extends BaseConfiguration
implements ConfigurationProperties {
    private final FluentConfiguration configuration;
    private final Map<String, String> customProperties = new HashMap<String, String>();
    private final JsonToBeanConverter jsonConverter = new JsonToBeanConverter();

    public AnnotationConfiguration(Class<?> containerClass) {
        this(containerClass == null ? null : containerClass.getAnnotation(FluentConfiguration.class));
    }

    public AnnotationConfiguration(FluentConfiguration configuration) {
        CustomProperty[] custom;
        this.configuration = configuration;
        if (this.configuration != null && (custom = this.configuration.custom()) != null) {
            for (CustomProperty customProperty : custom) {
                this.customProperties.put(customProperty.name(), customProperty.value());
            }
        }
    }

    private String getStringValue(String property) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            return null;
        }
        return property;
    }

    private <T extends ConfigurationFactory> Class<T> getConfigurationFactoryClassValue(Class<T> configurationFactoryClass) {
        if (configurationFactoryClass == DefaultConfigurationFactory.class) {
            return null;
        }
        return configurationFactoryClass;
    }

    private Class<? extends ConfigurationProperties> getConfigurationDefaultsClassValue(Class<? extends ConfigurationProperties> configurationDefaultsClass) {
        if (configurationDefaultsClass == ConfigurationDefaults.class) {
            return null;
        }
        return configurationDefaultsClass;
    }

    private Capabilities getCapabilitiesValue(String property) {
        if (StringUtils.isEmpty((CharSequence)property)) {
            return null;
        }
        try {
            URL url = new URL(property);
            InputStream stream = null;
            try {
                stream = url.openStream();
                property = IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new ConfigurationException("Can't read Capabilities defined at " + url, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        CapabilitiesFactory factory = CapabilitiesRegistry.INSTANCE.get(property);
        if (factory != null) {
            return factory.newCapabilities(this.getGlobalConfiguration());
        }
        try {
            return (Capabilities)this.jsonConverter.convert(DesiredCapabilities.class, (Object)property);
        }
        catch (JsonException e) {
            throw new ConfigurationException("Can't convert JSON Capabilities to Object.", e);
        }
    }

    @Override
    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        if (this.configuration == null) {
            return null;
        }
        return this.getConfigurationDefaultsClassValue(this.configuration.configurationDefaults());
    }

    private Long getLongValue(Long property) {
        if (property < 0L) {
            return null;
        }
        return property;
    }

    private ConfigurationProperties.TriggerMode getTriggerModeValue(ConfigurationProperties.TriggerMode triggerMode) {
        if (triggerMode == ConfigurationProperties.TriggerMode.DEFAULT) {
            return null;
        }
        return triggerMode;
    }

    private ConfigurationProperties.DriverLifecycle getDriverLifecycleValue(ConfigurationProperties.DriverLifecycle driverLifecycle) {
        if (driverLifecycle == ConfigurationProperties.DriverLifecycle.DEFAULT) {
            return null;
        }
        return driverLifecycle;
    }

    @Override
    public String getWebDriver() {
        if (this.configuration == null) {
            return null;
        }
        return this.getStringValue(this.configuration.webDriver());
    }

    @Override
    public String getRemoteUrl() {
        if (this.configuration == null) {
            return null;
        }
        return this.getStringValue(this.configuration.remoteUrl());
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.configuration == null) {
            return null;
        }
        return this.getCapabilitiesValue(this.configuration.capabilities());
    }

    @Override
    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        if (this.configuration == null) {
            return null;
        }
        return this.getConfigurationFactoryClassValue(this.configuration.configurationFactory());
    }

    @Override
    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        if (this.configuration == null) {
            return null;
        }
        return this.getDriverLifecycleValue(this.configuration.driverLifecycle());
    }

    @Override
    public Boolean getDeleteCookies() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.deleteCookies().asBoolean();
    }

    @Override
    public String getBaseUrl() {
        if (this.configuration == null) {
            return null;
        }
        return this.getStringValue(this.configuration.baseUrl());
    }

    @Override
    public Long getPageLoadTimeout() {
        if (this.configuration == null) {
            return null;
        }
        return this.getLongValue(this.configuration.pageLoadTimeout());
    }

    @Override
    public Long getImplicitlyWait() {
        if (this.configuration == null) {
            return null;
        }
        return this.getLongValue(this.configuration.implicitlyWait());
    }

    @Override
    public Long getScriptTimeout() {
        if (this.configuration == null) {
            return null;
        }
        return this.getLongValue(this.configuration.scriptTimeout());
    }

    @Override
    public Long getAwaitAtMost() {
        if (this.configuration == null) {
            return null;
        }
        return this.getLongValue(this.configuration.awaitAtMost());
    }

    @Override
    public Long getAwaitPollingEvery() {
        if (this.configuration == null) {
            return null;
        }
        return this.getLongValue(this.configuration.awaitPollingEvery());
    }

    @Override
    public Boolean getEventsEnabled() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.eventsEnabled().asBoolean();
    }

    @Override
    public String getScreenshotPath() {
        if (this.configuration == null) {
            return null;
        }
        return this.getStringValue(this.configuration.screenshotPath());
    }

    @Override
    public String getHtmlDumpPath() {
        if (this.configuration == null) {
            return null;
        }
        return this.getStringValue(this.configuration.htmlDumpPath());
    }

    @Override
    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        if (this.configuration == null) {
            return null;
        }
        return this.getTriggerModeValue(this.configuration.screenshotMode());
    }

    @Override
    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        if (this.configuration == null) {
            return null;
        }
        return this.getTriggerModeValue(this.configuration.htmlDumpMode());
    }

    @Override
    public String getCustomProperty(String propertyName) {
        return this.customProperties.get(propertyName);
    }
}

