/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.util.Arrays;
import java.util.List;
import org.fluentlenium.configuration.BaseConfiguration;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.configuration.ConfigurationFactory;
import org.fluentlenium.configuration.ConfigurationMutator;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.openqa.selenium.Capabilities;

public class ComposedConfiguration
implements Configuration {
    private final ConfigurationProperties[] configurations;
    private final ConfigurationMutator writableConfiguration;

    public ComposedConfiguration(ConfigurationMutator writableConfiguration, ConfigurationProperties ... configurations) {
        this.writableConfiguration = writableConfiguration;
        this.configurations = configurations;
        if (writableConfiguration instanceof BaseConfiguration) {
            ((BaseConfiguration)((Object)writableConfiguration)).setGlobalConfiguration(this);
        }
    }

    List<ConfigurationProperties> getConfigurations() {
        return Arrays.asList(this.configurations);
    }

    ConfigurationMutator getWritableConfiguration() {
        return this.writableConfiguration;
    }

    @Override
    public Class<? extends ConfigurationFactory> getConfigurationFactory() {
        for (ConfigurationProperties configuration : this.configurations) {
            Class<? extends ConfigurationFactory> configurationFactory = configuration.getConfigurationFactory();
            if (configurationFactory == null) continue;
            return configurationFactory;
        }
        return null;
    }

    @Override
    public Class<? extends ConfigurationProperties> getConfigurationDefaults() {
        for (ConfigurationProperties configuration : this.configurations) {
            Class<? extends ConfigurationProperties> configurationDefaults = configuration.getConfigurationDefaults();
            if (configurationDefaults == null) continue;
            return configurationDefaults;
        }
        return null;
    }

    @Override
    public String getWebDriver() {
        for (ConfigurationProperties configuration : this.configurations) {
            String webDriver = configuration.getWebDriver();
            if (webDriver == null) continue;
            return webDriver;
        }
        return null;
    }

    @Override
    public String getRemoteUrl() {
        for (ConfigurationProperties configuration : this.configurations) {
            String remoteUrl = configuration.getRemoteUrl();
            if (remoteUrl == null) continue;
            return remoteUrl;
        }
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        for (ConfigurationProperties configuration : this.configurations) {
            Capabilities capabilities = configuration.getCapabilities();
            if (capabilities == null) continue;
            return capabilities;
        }
        return null;
    }

    @Override
    public ConfigurationProperties.DriverLifecycle getDriverLifecycle() {
        for (ConfigurationProperties configuration : this.configurations) {
            ConfigurationProperties.DriverLifecycle driverLifecycle = configuration.getDriverLifecycle();
            if (driverLifecycle == null) continue;
            return driverLifecycle;
        }
        return null;
    }

    @Override
    public Boolean getDeleteCookies() {
        for (ConfigurationProperties configuration : this.configurations) {
            Boolean deleteCookies = configuration.getDeleteCookies();
            if (deleteCookies == null) continue;
            return deleteCookies;
        }
        return null;
    }

    @Override
    public String getBaseUrl() {
        for (ConfigurationProperties configuration : this.configurations) {
            String baseUrl = configuration.getBaseUrl();
            if (baseUrl == null) continue;
            return baseUrl;
        }
        return null;
    }

    @Override
    public Long getPageLoadTimeout() {
        for (ConfigurationProperties configuration : this.configurations) {
            Long pageLoadTimeout = configuration.getPageLoadTimeout();
            if (pageLoadTimeout == null) continue;
            return pageLoadTimeout;
        }
        return null;
    }

    @Override
    public Long getImplicitlyWait() {
        for (ConfigurationProperties configuration : this.configurations) {
            Long implicitlyWait = configuration.getImplicitlyWait();
            if (implicitlyWait == null) continue;
            return implicitlyWait;
        }
        return null;
    }

    @Override
    public Long getScriptTimeout() {
        for (ConfigurationProperties configuration : this.configurations) {
            Long scriptTimeout = configuration.getScriptTimeout();
            if (scriptTimeout == null) continue;
            return scriptTimeout;
        }
        return null;
    }

    @Override
    public Long getAwaitAtMost() {
        for (ConfigurationProperties configuration : this.configurations) {
            Long awaitAtMost = configuration.getAwaitAtMost();
            if (awaitAtMost == null) continue;
            return awaitAtMost;
        }
        return null;
    }

    @Override
    public Long getAwaitPollingEvery() {
        for (ConfigurationProperties configuration : this.configurations) {
            Long awaitPollingEvery = configuration.getAwaitPollingEvery();
            if (awaitPollingEvery == null) continue;
            return awaitPollingEvery;
        }
        return null;
    }

    @Override
    public Boolean getEventsEnabled() {
        for (ConfigurationProperties configuration : this.configurations) {
            Boolean eventsEnabled = configuration.getEventsEnabled();
            if (eventsEnabled == null) continue;
            return eventsEnabled;
        }
        return null;
    }

    @Override
    public String getScreenshotPath() {
        for (ConfigurationProperties configuration : this.configurations) {
            String screenshotPath = configuration.getScreenshotPath();
            if (screenshotPath == null) continue;
            return screenshotPath;
        }
        return null;
    }

    @Override
    public String getHtmlDumpPath() {
        for (ConfigurationProperties configuration : this.configurations) {
            String htmlDumpPath = configuration.getHtmlDumpPath();
            if (htmlDumpPath == null) continue;
            return htmlDumpPath;
        }
        return null;
    }

    @Override
    public ConfigurationProperties.TriggerMode getScreenshotMode() {
        for (ConfigurationProperties configuration : this.configurations) {
            ConfigurationProperties.TriggerMode screenshotMode = configuration.getScreenshotMode();
            if (screenshotMode == null) continue;
            return screenshotMode;
        }
        return null;
    }

    @Override
    public ConfigurationProperties.TriggerMode getHtmlDumpMode() {
        for (ConfigurationProperties configuration : this.configurations) {
            ConfigurationProperties.TriggerMode htmlDumpMode = configuration.getHtmlDumpMode();
            if (htmlDumpMode == null) continue;
            return htmlDumpMode;
        }
        return null;
    }

    @Override
    public String getCustomProperty(String propertyName) {
        for (ConfigurationProperties configuration : this.configurations) {
            String value = configuration.getCustomProperty(propertyName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void setWebDriver(String webDriver) {
        this.writableConfiguration.setWebDriver(webDriver);
    }

    @Override
    public void setRemoteUrl(String remoteUrl) {
        this.writableConfiguration.setRemoteUrl(remoteUrl);
    }

    @Override
    public void setCapabilities(Capabilities capabilities) {
        this.writableConfiguration.setCapabilities(capabilities);
    }

    @Override
    public void setConfigurationFactory(Class<? extends ConfigurationFactory> configurationFactory) {
        this.writableConfiguration.setConfigurationFactory(configurationFactory);
    }

    @Override
    public void setDriverLifecycle(ConfigurationProperties.DriverLifecycle driverLifecycle) {
        this.writableConfiguration.setDriverLifecycle(driverLifecycle);
    }

    @Override
    public void setDeleteCookies(Boolean deleteCookies) {
        this.writableConfiguration.setDeleteCookies(deleteCookies);
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.writableConfiguration.setBaseUrl(baseUrl);
    }

    @Override
    public void setPageLoadTimeout(Long pageLoadTimeout) {
        this.writableConfiguration.setPageLoadTimeout(pageLoadTimeout);
    }

    @Override
    public void setImplicitlyWait(Long implicitlyWait) {
        this.writableConfiguration.setImplicitlyWait(implicitlyWait);
    }

    @Override
    public void setAwaitAtMost(Long awaitAtMost) {
        this.writableConfiguration.setAwaitAtMost(awaitAtMost);
    }

    @Override
    public void setAwaitPollingEvery(Long awaitPollingEvery) {
        this.writableConfiguration.setAwaitPollingEvery(awaitPollingEvery);
    }

    @Override
    public void setScriptTimeout(Long scriptTimeout) {
        this.writableConfiguration.setScriptTimeout(scriptTimeout);
    }

    @Override
    public void setEventsEnabled(Boolean eventsEnabled) {
        this.writableConfiguration.setEventsEnabled(eventsEnabled);
    }

    @Override
    public void setScreenshotPath(String screenshotPath) {
        this.writableConfiguration.setScreenshotPath(screenshotPath);
    }

    @Override
    public void setScreenshotMode(ConfigurationProperties.TriggerMode screenshotMode) {
        this.writableConfiguration.setScreenshotMode(screenshotMode);
    }

    @Override
    public void setHtmlDumpPath(String htmlDumpPath) {
        this.writableConfiguration.setHtmlDumpPath(htmlDumpPath);
    }

    @Override
    public void setHtmlDumpMode(ConfigurationProperties.TriggerMode htmlDumpMode) {
        this.writableConfiguration.setHtmlDumpMode(htmlDumpMode);
    }

    @Override
    public void setCustomProperty(String key, String value) {
        this.writableConfiguration.setCustomProperty(key, value);
    }
}

