/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public final class UrlUtils {
    private UrlUtils() {
    }

    public static String concat(String baseUriSpec, String uriSpec) {
        if (baseUriSpec != null && !baseUriSpec.endsWith("/")) {
            baseUriSpec = baseUriSpec + "/";
        }
        URI baseUri = null;
        if (baseUriSpec != null) {
            baseUri = URI.create(baseUriSpec);
        }
        if (baseUri != null && uriSpec != null && uriSpec.startsWith("/")) {
            uriSpec = uriSpec.substring(1);
        }
        URI uri = null;
        if (uriSpec != null) {
            uri = URI.create(uriSpec);
        }
        if (baseUri != null && uri != null) {
            return baseUri.resolve(uri).toString();
        }
        if (baseUri != null) {
            return baseUri.toString();
        }
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    public static String sanitizeBaseUrl(String baseUriSpec, String uriSpec) {
        if (baseUriSpec == null) {
            return null;
        }
        URI baseUri = URI.create(baseUriSpec);
        try {
            String scheme;
            baseUri = UrlUtils.ensureScheme(baseUri, "http");
            URI uri = uriSpec == null ? null : URI.create(uriSpec);
            String string = scheme = uri == null || !Objects.equals(baseUri.getAuthority(), uri.getAuthority()) || !Arrays.asList("http", "https").contains(uri.getScheme()) ? baseUri.getScheme() : uri.getScheme();
            if (!scheme.equals(baseUri.getScheme())) {
                return new URIBuilder(baseUri).setScheme(scheme).build().toString();
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return baseUri.toString();
    }

    private static URI ensureScheme(URI uri, String defaultScheme) throws URISyntaxException {
        String fixedBaseUriSpec = uri.toString();
        if (uri.getScheme() == null) {
            while (!fixedBaseUriSpec.startsWith("//")) {
                fixedBaseUriSpec = "/" + fixedBaseUriSpec;
            }
            return new URIBuilder(fixedBaseUriSpec).setScheme(defaultScheme).build();
        }
        return uri;
    }
}

