/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.glassfish.api.embedded.ContainerBuilder;

public abstract class AbstractServerMojo
extends AbstractMojo {
    protected String serverID;
    protected int port;
    protected String installRoot;
    protected String instanceRoot;
    protected String configFile;
    protected Boolean autoDelete;
    protected MavenProject project;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactRepository localRepository;
    protected ArtifactResolver artifactResolver;
    private ArtifactFactory factory;
    protected String containerType;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    void setClassPathProperty() throws ProjectBuildingException {
        String prop = System.getProperty("java.class.path");
        String classPath = this.getEmbeddedDependenciesClassPath();
        if (classPath != null && classPath.length() > 0) {
            if (prop != null && prop.length() > 0) {
                prop = prop + File.pathSeparator;
            }
            System.setProperty("java.class.path", prop + classPath);
        }
    }

    private String getEmbeddedDependenciesClassPath() throws ProjectBuildingException {
        String classPath = "";
        for (Artifact a : this.project.getPluginArtifacts()) {
            String version = a.getVersion();
            if (version == null || version.equals("RELEASE")) {
                a.setVersion("3.0");
            }
            MavenProject pluginProject = this.projectBuilder.buildFromRepository(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            List ea = this.resolveEmbeddedArtifacts(pluginProject);
            for (Artifact artifact : ea) {
                File f = artifact.getFile();
                if (f == null || !f.getName().contains("glassfish-embedded")) continue;
                classPath = classPath + f + File.pathSeparator;
            }
        }
        return classPath;
    }

    private List resolveEmbeddedArtifacts(MavenProject project) {
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        List dependencies = project.getDependencies();
        HashSet<Artifact> dependencyArtifacts = new HashSet<Artifact>();
        for (Dependency dependency : dependencies) {
            VersionRange vr = VersionRange.createFromVersion((String)dependency.getVersion());
            Artifact artifact = this.factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), vr, dependency.getType(), dependency.getClassifier(), dependency.getScope());
            dependencyArtifacts.add(artifact);
        }
        for (Artifact artifact : dependencyArtifacts) {
            try {
                this.artifactResolver.resolve(artifact, Collections.EMPTY_LIST, this.localRepository);
                artifactList.add(artifact);
            }
            catch (ArtifactResolutionException e) {
            }
            catch (ArtifactNotFoundException e) {}
        }
        return artifactList;
    }

    ContainerBuilder.Type getContainerBuilderType() {
        if (this.containerType == null || this.containerType.equalsIgnoreCase("all")) {
            return ContainerBuilder.Type.all;
        }
        if (this.containerType.equalsIgnoreCase("web")) {
            return ContainerBuilder.Type.web;
        }
        if (this.containerType.equalsIgnoreCase("ejb")) {
            return ContainerBuilder.Type.ejb;
        }
        if (this.containerType.equalsIgnoreCase("jpa")) {
            return ContainerBuilder.Type.jpa;
        }
        if (this.containerType.equalsIgnoreCase("webservices")) {
            return ContainerBuilder.Type.webservices;
        }
        return ContainerBuilder.Type.all;
    }
}

