/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.Server;
import org.glassfish.maven.AbstractDeployMojo;
import org.glassfish.maven.Util;

public class RunMojo
extends AbstractDeployMojo {
    protected String app;
    Boolean cascade;
    Boolean dropTables;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File deployArchive = new File(this.app);
        if (!deployArchive.exists()) {
            throw new MojoExecutionException("", (Exception)new FileNotFoundException(this.app));
        }
        Server server = null;
        try {
            String str;
            super.setClassPathProperty();
            server = Server.getServer((String)this.serverID);
            if (server == null) {
                server = Util.getServer(this.serverID, this.installRoot, this.instanceRoot, this.configFile, this.autoDelete);
                server.addContainer(this.getContainerBuilderType());
            }
            if (this.port != -1) {
                server.createPort(this.port);
            }
            server.start();
            EmbeddedDeployer deployer = server.getDeployer();
            DeployCommandParameters cmdParams = new DeployCommandParameters();
            this.configureDeployCommandParameters(cmdParams);
            UndeployCommandParameters undeployCommandParameters = new UndeployCommandParameters();
            if (this.dropTables != null) {
                undeployCommandParameters.droptables = this.dropTables;
            }
            if (this.cascade != null) {
                undeployCommandParameters.cascade = this.cascade;
            }
            do {
                String appName = deployer.deploy(deployArchive, cmdParams);
                System.out.println("Hit ENTER to redeploy, X to exit");
                str = new BufferedReader(new InputStreamReader(System.in)).readLine();
                undeployCommandParameters.name = appName;
                deployer.undeploy(appName, undeployCommandParameters);
            } while (!str.equalsIgnoreCase("X"));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            if (server != null) {
                try {
                    server.stop();
                }
                catch (Exception ex) {}
            }
        }
    }
}

