/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.embedded.EmbeddedDeployer;
import org.glassfish.api.embedded.Server;
import org.glassfish.maven.AbstractServerMojo;

public class UndeployMojo
extends AbstractServerMojo {
    protected String name;
    Boolean cascade;
    Boolean dropTables;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Server server = Server.getServer((String)this.serverID);
        if (server == null) {
            throw new MojoExecutionException("Embedded Server[" + this.serverID + "] not running");
        }
        try {
            EmbeddedDeployer deployer = server.getDeployer();
            UndeployCommandParameters cmdParams = new UndeployCommandParameters();
            this.configureUndeployCommandParameters(cmdParams);
            if (this.name != null) {
                deployer.undeploy(this.name, cmdParams);
            } else {
                deployer.undeployAll();
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException(ex.getMessage(), ex);
        }
    }

    void configureUndeployCommandParameters(UndeployCommandParameters cmdParams) {
        if (this.name != null) {
            cmdParams.name = this.name;
        }
        if (this.dropTables != null) {
            cmdParams.droptables = this.dropTables;
        }
        if (this.cascade != null) {
            cmdParams.cascade = this.cascade;
        }
    }
}

