/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debugentry.CompiledMethodEntry;
import com.oracle.objectfile.debugentry.TypeEntry;
import com.oracle.objectfile.pecoff.PECoffObjectFile;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVTypeRecord;
import com.oracle.objectfile.pecoff.cv.CVTypeSectionBuilder;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.debug.DebugContext;

public final class CVTypeSectionImpl
extends CVSectionImpl {
    private static final int CV_RECORD_INITIAL_CAPACITY = 200;
    private int sequenceCounter = 4096;
    private final Map<CVTypeRecord, CVTypeRecord> typeMap = new LinkedHashMap<CVTypeRecord, CVTypeRecord>(200);
    private final CVTypeSectionBuilder builder = new CVTypeSectionBuilder(this);

    CVTypeSectionImpl(CVDebugInfo cvDebugInfo) {
        super(cvDebugInfo);
    }

    @Override
    public String getSectionName() {
        return ".debug$T";
    }

    @Override
    public void createContent(DebugContext debugContext) {
        int pos = 0;
        this.enableLog(debugContext);
        this.log("CVTypeSectionImpl.createContent() verifying that all types have been defined", new Object[0]);
        this.builder.verifyAllClassesDefined();
        this.log("CVTypeSectionImpl.createContent() start", new Object[0]);
        pos = CVUtil.putInt(4, null, pos);
        for (CVTypeRecord record : this.typeMap.values()) {
            pos = record.computeFullSize(pos);
        }
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
        this.log("CVTypeSectionImpl.createContent() end", new Object[0]);
    }

    @Override
    public void writeContent(DebugContext debugContext) {
        int pos = 0;
        this.enableLog(debugContext);
        this.log("CVTypeSectionImpl.writeContent() start", new Object[0]);
        byte[] buffer = this.getContent();
        this.verboseLog("  [0x%08x] CV_SIGNATURE_C13", pos);
        pos = CVUtil.putInt(4, buffer, pos);
        for (CVTypeRecord record : this.typeMap.values()) {
            this.verboseLog("  [0x%08x] 0x%06x %s", pos, record.getSequenceNumber(), record.toString());
            pos = record.computeFullContents(buffer, pos);
        }
        this.verboseLog("CVTypeSectionImpl.writeContent() end", new Object[0]);
    }

    <T extends CVTypeRecord> T addOrReference(T newRecord) {
        CVTypeRecord record;
        if (this.typeMap.containsKey(newRecord)) {
            record = this.typeMap.get(newRecord);
        } else {
            newRecord.setSequenceNumber(this.sequenceCounter++);
            this.typeMap.put(newRecord, newRecord);
            record = newRecord;
        }
        return (T)record;
    }

    @Override
    public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        Iterable deps = super.getDependencies((Map)decisions);
        PECoffObjectFile.PECoffSection targetSection = (PECoffObjectFile.PECoffSection)this.getElement().getOwner().elementForName(".debug$S");
        LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
        deps.add(BuildDependency.createOrGet(ourContent, decisions.get(targetSection).getDecision(LayoutDecision.Kind.CONTENT)));
        return deps;
    }

    CVTypeRecord addTypeRecords(CompiledMethodEntry entry) {
        return this.builder.buildFunction(entry);
    }

    CVTypeRecord addTypeRecords(TypeEntry entry) {
        return this.builder.buildType(entry);
    }

    CVTypeRecord.CVTypeStringIdRecord getStringId(String string) {
        CVTypeRecord.CVTypeStringIdRecord r = new CVTypeRecord.CVTypeStringIdRecord(string);
        return this.addOrReference(r);
    }

    int getIndexForPointer(TypeEntry typeEntry) {
        return this.builder.getIndexForPointerOrPrimitive(typeEntry);
    }
}

