/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.internal.regions.EhcacheTransactionalDataRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;

abstract class AbstractEhcacheAccessStrategy<T extends EhcacheTransactionalDataRegion> {
    private final T region;
    private final SessionFactoryOptions settings;

    AbstractEhcacheAccessStrategy(T region, SessionFactoryOptions settings) {
        this.region = region;
        this.settings = settings;
    }

    protected T region() {
        return this.region;
    }

    protected SessionFactoryOptions settings() {
        return this.settings;
    }

    public final boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.putFromLoad(session, key, value, txTimestamp, version, this.settings.isMinimalPutsEnabled());
    }

    public abstract boolean putFromLoad(SessionImplementor var1, Object var2, Object var3, long var4, Object var6, boolean var7) throws CacheException;

    public final SoftLock lockRegion() {
        return null;
    }

    public final void unlockRegion(SoftLock lock) throws CacheException {
        ((EhcacheTransactionalDataRegion)this.region).clear();
    }

    public void remove(SessionImplementor session, Object key) throws CacheException {
    }

    public final void removeAll() throws CacheException {
        ((EhcacheTransactionalDataRegion)this.region).clear();
    }

    public final void evict(Object key) throws CacheException {
        ((EhcacheTransactionalDataRegion)this.region).remove(key);
    }

    public final void evictAll() throws CacheException {
        ((EhcacheTransactionalDataRegion)this.region).clear();
    }
}

