/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import org.hibernate.ejb.event.CallbackHandlerConsumer;
import org.hibernate.ejb.event.EntityCallbackHandler;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;

public class EJB3PostUpdateEventListener
implements PostUpdateEventListener,
CallbackHandlerConsumer,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener {
    EntityCallbackHandler callbackHandler;

    @Override
    public void setCallbackHandler(EntityCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public EJB3PostUpdateEventListener() {
    }

    public EJB3PostUpdateEventListener(EntityCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    private void handlePostUpdate(Object entity, EventSource source) {
        EntityEntry entry = (EntityEntry)source.getPersistenceContext().getEntityEntries().get(entity);
        if (Status.DELETED != entry.getStatus()) {
            this.callbackHandler.postUpdate(entity);
        }
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }
}

