/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ejb.metamodel.AbstractType;

public abstract class AbstractManagedType<X>
extends AbstractType<X>
implements ManagedType<X>,
Serializable {
    private final AbstractManagedType<? super X> superType;
    private final Map<String, Attribute<X, ?>> declaredAttributes = new HashMap();
    private final Map<String, SingularAttribute<X, ?>> declaredSingularAttributes = new HashMap();
    private final Map<String, PluralAttribute<X, ?, ?>> declaredPluralAttributes = new HashMap();
    private boolean locked = false;

    protected AbstractManagedType(Class<X> javaType, AbstractManagedType<? super X> superType) {
        super(javaType);
        this.superType = superType;
    }

    protected AbstractManagedType<? super X> getSupertype() {
        return this.superType;
    }

    public Builder<X> getBuilder() {
        if (this.locked) {
            throw new IllegalStateException("Type has been locked");
        }
        return new Builder<X>(){

            @Override
            public void addAttribute(Attribute<X, ?> attribute) {
                AbstractManagedType.this.declaredAttributes.put(attribute.getName(), attribute);
                Bindable.BindableType bindableType = ((Bindable)attribute).getBindableType();
                switch (bindableType) {
                    case SINGULAR_ATTRIBUTE: {
                        AbstractManagedType.this.declaredSingularAttributes.put(attribute.getName(), (SingularAttribute)attribute);
                        break;
                    }
                    case PLURAL_ATTRIBUTE: {
                        AbstractManagedType.this.declaredPluralAttributes.put(attribute.getName(), (PluralAttribute)attribute);
                        break;
                    }
                    default: {
                        throw new AssertionFailure("unknown bindable type: " + bindableType);
                    }
                }
            }
        };
    }

    public void lock() {
        this.locked = true;
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        HashSet attributes = new HashSet(this.declaredAttributes.values());
        if (this.getSupertype() != null) {
            attributes.addAll(this.getSupertype().getAttributes());
        }
        return attributes;
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        return new HashSet(this.declaredAttributes.values());
    }

    public Attribute<? super X, ?> getAttribute(String name) {
        Attribute<X, ?> attribute = this.declaredAttributes.get(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = this.getSupertype().getAttribute(name);
        }
        return attribute;
    }

    public Attribute<X, ?> getDeclaredAttribute(String name) {
        Attribute attr = (Attribute)this.declaredSingularAttributes.get(name);
        this.checkNotNull("Attribute ", attr, name);
        return attr;
    }

    private void checkNotNull(String attributeType, Attribute<?, ?> attribute, String name) {
        if (attribute == null) {
            throw new IllegalArgumentException(attributeType + " named " + name + " is not present");
        }
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        HashSet attributes = new HashSet(this.declaredSingularAttributes.values());
        if (this.getSupertype() != null) {
            attributes.addAll(this.getSupertype().getSingularAttributes());
        }
        return attributes;
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        return new HashSet(this.declaredSingularAttributes.values());
    }

    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        SingularAttribute<X, ?> attribute = this.declaredSingularAttributes.get(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = this.getSupertype().getSingularAttribute(name);
        }
        return attribute;
    }

    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        SingularAttribute<X, ?> attr = this.declaredSingularAttributes.get(name);
        this.checkNotNull("SingularAttribute ", (Attribute<?, ?>)attr, name);
        return attr;
    }

    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, ?> attribute = this.declaredSingularAttributes.get(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = this.getSupertype().getSingularAttribute(name);
        }
        this.checkTypeForSingleAttribute("SingularAttribute ", attribute, name, type);
        return attribute;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> javaType) {
        SingularAttribute<X, ?> attr = this.declaredSingularAttributes.get(name);
        this.checkTypeForSingleAttribute("SingularAttribute ", attr, name, javaType);
        return attr;
    }

    private <Y> void checkTypeForSingleAttribute(String attributeType, SingularAttribute<?, ?> attribute, String name, Class<Y> javaType) {
        if (attribute == null || javaType != null && !attribute.getBindableJavaType().equals(javaType)) {
            if (this.isPrimitiveVariant(attribute, javaType)) {
                return;
            }
            throw new IllegalArgumentException(attributeType + " named " + name + (javaType != null ? " and of type " + javaType.getName() : "") + " is not present");
        }
    }

    protected <Y> boolean isPrimitiveVariant(SingularAttribute<?, ?> attribute, Class<Y> javaType) {
        if (attribute == null) {
            return false;
        }
        Class declaredType = attribute.getBindableJavaType();
        if (declaredType.isPrimitive()) {
            return Boolean.class.equals(javaType) && Boolean.TYPE.equals(declaredType) || Character.class.equals(javaType) && Character.TYPE.equals(declaredType) || Byte.class.equals(javaType) && Byte.TYPE.equals(declaredType) || Short.class.equals(javaType) && Short.TYPE.equals(declaredType) || Integer.class.equals(javaType) && Integer.TYPE.equals(declaredType) || Long.class.equals(javaType) && Long.TYPE.equals(declaredType) || Float.class.equals(javaType) && Float.TYPE.equals(declaredType) || Double.class.equals(javaType) && Double.TYPE.equals(declaredType);
        }
        if (javaType.isPrimitive()) {
            return Boolean.class.equals((Object)declaredType) && Boolean.TYPE.equals(javaType) || Character.class.equals((Object)declaredType) && Character.TYPE.equals(javaType) || Byte.class.equals((Object)declaredType) && Byte.TYPE.equals(javaType) || Short.class.equals((Object)declaredType) && Short.TYPE.equals(javaType) || Integer.class.equals((Object)declaredType) && Integer.TYPE.equals(javaType) || Long.class.equals((Object)declaredType) && Long.TYPE.equals(javaType) || Float.class.equals((Object)declaredType) && Float.TYPE.equals(javaType) || Double.class.equals((Object)declaredType) && Double.TYPE.equals(javaType);
        }
        return false;
    }

    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        HashSet attributes = new HashSet(this.declaredPluralAttributes.values());
        if (this.getSupertype() != null) {
            attributes.addAll(this.getSupertype().getPluralAttributes());
        }
        return attributes;
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        return new HashSet(this.declaredPluralAttributes.values());
    }

    public CollectionAttribute<? super X, ?> getCollection(String name) {
        PluralAttribute<X, ?, ?> attribute = this.getPluralAttribute(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.basicCollectionCheck(attribute, name);
        return (CollectionAttribute)attribute;
    }

    private PluralAttribute<? super X, ?, ?> getPluralAttribute(String name) {
        return this.declaredPluralAttributes.get(name);
    }

    private void basicCollectionCheck(PluralAttribute<? super X, ?, ?> attribute, String name) {
        this.checkNotNull("CollectionAttribute", (Attribute<?, ?>)attribute, name);
        if (!CollectionAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a CollectionAttribute: " + attribute.getClass());
        }
    }

    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.basicCollectionCheck(attribute, name);
        return (CollectionAttribute)attribute;
    }

    public SetAttribute<? super X, ?> getSet(String name) {
        PluralAttribute<X, ?, ?> attribute = this.getPluralAttribute(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.basicSetCheck(attribute, name);
        return (SetAttribute)attribute;
    }

    private void basicSetCheck(PluralAttribute<? super X, ?, ?> attribute, String name) {
        this.checkNotNull("SetAttribute", (Attribute<?, ?>)attribute, name);
        if (!SetAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a SetAttribute: " + attribute.getClass());
        }
    }

    public SetAttribute<X, ?> getDeclaredSet(String name) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.basicSetCheck(attribute, name);
        return (SetAttribute)attribute;
    }

    public ListAttribute<? super X, ?> getList(String name) {
        PluralAttribute<X, ?, ?> attribute = this.getPluralAttribute(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.basicListCheck(attribute, name);
        return (ListAttribute)attribute;
    }

    private void basicListCheck(PluralAttribute<? super X, ?, ?> attribute, String name) {
        this.checkNotNull("ListAttribute", (Attribute<?, ?>)attribute, name);
        if (!ListAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a ListAttribute: " + attribute.getClass());
        }
    }

    public ListAttribute<X, ?> getDeclaredList(String name) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.basicListCheck(attribute, name);
        return (ListAttribute)attribute;
    }

    public MapAttribute<? super X, ?, ?> getMap(String name) {
        PluralAttribute<X, ?, ?> attribute = this.getPluralAttribute(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.basicMapCheck(attribute, name);
        return (MapAttribute)attribute;
    }

    private void basicMapCheck(PluralAttribute<? super X, ?, ?> attribute, String name) {
        this.checkNotNull("MapAttribute", (Attribute<?, ?>)attribute, name);
        if (!MapAttribute.class.isAssignableFrom(attribute.getClass())) {
            throw new IllegalArgumentException(name + " is not a MapAttribute: " + attribute.getClass());
        }
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.basicMapCheck(attribute, name);
        return (MapAttribute)attribute;
    }

    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.checkCollectionElementType(attribute, name, elementType);
        return (CollectionAttribute)attribute;
    }

    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.checkCollectionElementType(attribute, name, elementType);
        return (CollectionAttribute)attribute;
    }

    private <E> void checkCollectionElementType(PluralAttribute<?, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("CollectionAttribute", attribute, name, elementType, PluralAttribute.CollectionType.COLLECTION);
    }

    private <E> void checkTypeForPluralAttributes(String attributeType, PluralAttribute<?, ?, ?> attribute, String name, Class<E> elementType, PluralAttribute.CollectionType collectionType) {
        if (attribute == null || elementType != null && !attribute.getBindableJavaType().equals(elementType) || attribute.getCollectionType() != collectionType) {
            throw new IllegalArgumentException(attributeType + " named " + name + (elementType != null ? " and of element type " + elementType : "") + " is not present");
        }
    }

    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.checkSetElementType(attribute, name, elementType);
        return (SetAttribute)attribute;
    }

    private <E> void checkSetElementType(PluralAttribute<? super X, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("SetAttribute", attribute, name, elementType, PluralAttribute.CollectionType.SET);
    }

    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.checkSetElementType(attribute, name, elementType);
        return (SetAttribute)attribute;
    }

    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.checkListElementType(attribute, name, elementType);
        return (ListAttribute)attribute;
    }

    private <E> void checkListElementType(PluralAttribute<? super X, ?, ?> attribute, String name, Class<E> elementType) {
        this.checkTypeForPluralAttributes("ListAttribute", attribute, name, elementType, PluralAttribute.CollectionType.LIST);
    }

    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.checkListElementType(attribute, name, elementType);
        return (ListAttribute)attribute;
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralAttribute<X, ?, ?> attribute = this.getPluralAttribute(name);
        if (attribute == null && this.getSupertype() != null) {
            attribute = super.getPluralAttribute(name);
        }
        this.checkMapValueType(attribute, name, valueType);
        MapAttribute mapAttribute = (MapAttribute)attribute;
        this.checkMapKeyType(mapAttribute, name, keyType);
        return mapAttribute;
    }

    private <V> void checkMapValueType(PluralAttribute<? super X, ?, ?> attribute, String name, Class<V> valueType) {
        this.checkTypeForPluralAttributes("MapAttribute", attribute, name, valueType, PluralAttribute.CollectionType.MAP);
    }

    private <K, V> void checkMapKeyType(MapAttribute<? super X, K, V> mapAttribute, String name, Class<K> keyType) {
        if (mapAttribute.getKeyJavaType() != keyType) {
            throw new IllegalArgumentException("MapAttribute named " + name + " does not support a key of type " + keyType);
        }
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        PluralAttribute<X, ?, ?> attribute = this.declaredPluralAttributes.get(name);
        this.checkMapValueType(attribute, name, valueType);
        MapAttribute mapAttribute = (MapAttribute)attribute;
        this.checkMapKeyType(mapAttribute, name, keyType);
        return mapAttribute;
    }

    public static interface Builder<X> {
        public void addAttribute(Attribute<X, ?> var1);
    }
}

