/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.path;

import java.io.Serializable;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.ListAttribute;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.CriteriaSubqueryImpl;
import org.hibernate.jpa.criteria.FromImplementor;
import org.hibernate.jpa.criteria.ListJoinImplementor;
import org.hibernate.jpa.criteria.PathImplementor;
import org.hibernate.jpa.criteria.PathSource;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.ListIndexExpression;
import org.hibernate.jpa.criteria.path.PluralAttributeJoinSupport;

public class ListAttributeJoin<O, E>
extends PluralAttributeJoinSupport<O, List<E>, E>
implements ListJoinImplementor<O, E>,
Serializable {
    public ListAttributeJoin(CriteriaBuilderImpl criteriaBuilder, Class<E> javaType, PathSource<O> pathSource, ListAttribute<? super O, E> joinAttribute, JoinType joinType) {
        super(criteriaBuilder, javaType, pathSource, joinAttribute, joinType);
    }

    public Expression<Integer> index() {
        return new ListIndexExpression(this.criteriaBuilder(), this, this.getAttribute());
    }

    @Override
    public ListAttribute<? super O, E> getAttribute() {
        return (ListAttribute)super.getAttribute();
    }

    public ListAttribute<? super O, E> getModel() {
        return this.getAttribute();
    }

    @Override
    public final ListAttributeJoin<O, E> correlateTo(CriteriaSubqueryImpl subquery) {
        return (ListAttributeJoin)super.correlateTo(subquery);
    }

    @Override
    protected FromImplementor<O, E> createCorrelationDelegate() {
        return new ListAttributeJoin(this.criteriaBuilder(), this.getJavaType(), (PathImplementor)this.getParentPath(), this.getAttribute(), this.getJoinType());
    }

    @Override
    public ListAttributeJoin<O, E> on(Predicate ... restrictions) {
        return (ListAttributeJoin)super.on(restrictions);
    }

    @Override
    public ListAttributeJoin<O, E> on(Expression<Boolean> restriction) {
        return (ListAttributeJoin)super.on((Expression)restriction);
    }

    @Override
    public <T extends E> ListAttributeJoin<O, T> treatAs(Class<T> treatAsType) {
        return new TreatedListAttributeJoin(this, treatAsType);
    }

    public static class TreatedListAttributeJoin<O, T>
    extends ListAttributeJoin<O, T> {
        private final ListAttributeJoin<O, ? super T> original;
        private final Class<T> treatAsType;

        public TreatedListAttributeJoin(ListAttributeJoin<O, ? super T> original, Class<T> treatAsType) {
            super(original.criteriaBuilder(), treatAsType, original.getPathSource(), original.getAttribute(), original.getJoinType());
            this.original = original;
            this.treatAsType = treatAsType;
        }

        @Override
        public String getAlias() {
            return this.original.getAlias();
        }

        @Override
        public void prepareAlias(RenderingContext renderingContext) {
        }

        @Override
        public String render(RenderingContext renderingContext) {
            return "treat(" + this.original.render(renderingContext) + " as " + this.treatAsType.getName() + ")";
        }
    }
}

