/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.impl.String2FieldBridgeAdaptor;
import org.hibernate.search.engine.impl.DocumentBuilderHelper;

public class TwoWayString2FieldBridgeAdaptor
extends String2FieldBridgeAdaptor
implements TwoWayFieldBridge {
    private final TwoWayStringBridge stringBridge;

    public TwoWayString2FieldBridgeAdaptor(TwoWayStringBridge stringBridge) {
        super(stringBridge);
        this.stringBridge = stringBridge;
    }

    @Override
    public String objectToString(Object object) {
        return this.stringBridge.objectToString(object);
    }

    @Override
    public Object get(String name, Document document) {
        Fieldable field = document.getFieldable(name);
        if (field == null) {
            return this.stringBridge.stringToObject(null);
        }
        String stringValue = DocumentBuilderHelper.extractStringFromFieldable(field);
        return this.stringBridge.stringToObject(stringValue);
    }

    public TwoWayStringBridge unwrap() {
        return this.stringBridge;
    }
}

