/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx;

import java.util.concurrent.atomic.AtomicLong;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.jmx.IndexingProgressMonitorMBean;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IndexingProgressMonitor
implements IndexingProgressMonitorMBean,
MassIndexerProgressMonitor {
    private static final Log log = LoggerFactory.make();
    private final AtomicLong documentsDoneCounter = new AtomicLong();
    private final AtomicLong documentsBuiltCounter = new AtomicLong();
    private final AtomicLong totalCounter = new AtomicLong();
    private final AtomicLong entitiesLoadedCounter = new AtomicLong();
    private final String registeredName;

    public IndexingProgressMonitor() {
        String name = "org.hibernate.search.jmx:type=IndexingProgressMBean";
        if (JMXRegistrar.isNameRegistered(name)) {
            name = name + "@" + Integer.toHexString(this.hashCode());
        }
        this.registeredName = JMXRegistrar.registerMBean(this, name);
    }

    @Override
    public final void documentsAdded(long increment) {
        this.documentsDoneCounter.addAndGet(increment);
    }

    @Override
    public final void documentsBuilt(int number) {
        this.documentsBuiltCounter.addAndGet(number);
    }

    @Override
    public final void entitiesLoaded(int size) {
        this.entitiesLoadedCounter.addAndGet(size);
    }

    @Override
    public final void addToTotalCount(long count) {
        this.totalCounter.addAndGet(count);
    }

    @Override
    public final void indexingCompleted() {
        log.indexingCompletedAndMBeanUnregistered(this.totalCounter.get());
        JMXRegistrar.unRegisterMBean(this.registeredName);
    }

    @Override
    public final long getLoadedEntitiesCount() {
        return this.entitiesLoadedCounter.get();
    }

    @Override
    public final long getDocumentsAddedCount() {
        return this.documentsDoneCounter.get();
    }

    @Override
    public final long getNumberOfEntitiesToIndex() {
        return this.totalCounter.get();
    }
}

