/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;

public class RAMDirectoryProvider
implements DirectoryProvider<RAMDirectory> {
    private final RAMDirectory directory = new RAMDirectory();
    private String indexName;
    private Properties properties;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.indexName = directoryProviderName;
        this.properties = properties;
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
        try {
            this.directory.setLockFactory(DirectoryProviderHelper.createLockFactory(null, this.properties));
            this.properties = null;
            DirectoryProviderHelper.initializeIndexIfNeeded((Directory)this.directory);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + this.indexName, e);
        }
    }

    @Override
    public RAMDirectory getDirectory() {
        return this.directory;
    }

    @Override
    public void stop() {
        this.directory.close();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RAMDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((RAMDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 7;
        return 29 * hash + this.indexName.hashCode();
    }
}

