/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter.impl;

import java.util.Properties;
import org.apache.lucene.search.Filter;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.SoftLimitMRUCache;

public class MRUFilterCachingStrategy
implements FilterCachingStrategy {
    private static final int DEFAULT_SIZE = 128;
    private SoftLimitMRUCache cache;
    private static final String SIZE = "hibernate.search.filter.cache_strategy.size";
    private static final int HARD_TO_SOFT_RATIO = 15;

    @Override
    public void initialize(Properties properties) {
        int size = ConfigurationParseHelper.getIntValue(properties, SIZE, 128);
        this.cache = new SoftLimitMRUCache(size, size * 15);
    }

    @Override
    public Filter getCachedFilter(FilterKey key) {
        return (Filter)this.cache.get(key);
    }

    @Override
    public void addCachedFilter(FilterKey key, Filter filter) {
        this.cache.put(key, filter);
    }
}

