/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.DoubleNumericFieldBridge;
import org.hibernate.search.bridge.builtin.FloatNumericFieldBridge;
import org.hibernate.search.bridge.builtin.IntegerNumericFieldBridge;
import org.hibernate.search.bridge.builtin.LongNumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.query.fieldcache.impl.FieldCacheLoadingType;

public final class ClassLoadingStrategySelector {
    private ClassLoadingStrategySelector() {
    }

    public static FieldCacheLoadingType guessAppropriateCollectorType(TwoWayFieldBridge fieldBridge) {
        if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
            NullEncodingTwoWayFieldBridge encoding = (NullEncodingTwoWayFieldBridge)fieldBridge;
            return ClassLoadingStrategySelector.guessAppropriateCollectorType(encoding.unwrap());
        }
        if (fieldBridge instanceof TwoWayString2FieldBridgeAdaptor) {
            return FieldCacheLoadingType.STRING;
        }
        if (fieldBridge instanceof IntegerNumericFieldBridge) {
            return FieldCacheLoadingType.INT;
        }
        if (fieldBridge instanceof LongNumericFieldBridge) {
            return FieldCacheLoadingType.LONG;
        }
        if (fieldBridge instanceof DoubleNumericFieldBridge) {
            return FieldCacheLoadingType.DOUBLE;
        }
        if (fieldBridge instanceof FloatNumericFieldBridge) {
            return FieldCacheLoadingType.FLOAT;
        }
        return null;
    }

    public static TwoWayStringBridge getTwoWayStringBridge(TwoWayFieldBridge fieldBridge) {
        if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
            NullEncodingTwoWayFieldBridge encoding = (NullEncodingTwoWayFieldBridge)fieldBridge;
            return ClassLoadingStrategySelector.getTwoWayStringBridge(encoding.unwrap());
        }
        if (fieldBridge instanceof TwoWayString2FieldBridgeAdaptor) {
            TwoWayString2FieldBridgeAdaptor adaptor = (TwoWayString2FieldBridgeAdaptor)fieldBridge;
            return adaptor.unwrap();
        }
        return null;
    }
}

