/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import java.util.Collection;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;

public class MapBridge
implements FieldBridge {
    private final FieldBridge bridge;

    public MapBridge(FieldBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public void set(String fieldName, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            this.indexNotNullMap(fieldName, value, document, luceneOptions);
        }
    }

    protected void indexNotNullMap(String name, Object value, Document document, LuceneOptions luceneOptions) {
        Collection collection = ((Map)value).values();
        for (Object entry : collection) {
            this.indexEntry(name, entry, document, luceneOptions);
        }
    }

    protected void indexEntry(String fieldName, Object entry, Document document, LuceneOptions luceneOptions) {
        this.bridge.set(fieldName, entry, document, luceneOptions);
    }
}

