/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;

public class DocumentFieldMetadata {
    private final String fieldName;
    private final Store store;
    private final Field.Index index;
    private final Field.TermVector termVector;
    private final FieldBridge fieldBridge;
    private final Float boost;
    private final Analyzer analyzer;
    private final boolean isId;
    private final String nullToken;
    private final boolean isNumeric;
    private final int precisionStep;

    private DocumentFieldMetadata(Builder builder) {
        this.fieldName = builder.fieldName;
        this.store = builder.store;
        this.index = builder.index;
        this.termVector = builder.termVector;
        this.fieldBridge = builder.fieldBridge;
        this.boost = builder.boost;
        this.analyzer = builder.analyzer;
        this.isId = builder.isId;
        this.nullToken = builder.nullToken;
        this.isNumeric = builder.isNumeric;
        this.precisionStep = builder.precisionStep;
    }

    public String getName() {
        return this.fieldName;
    }

    public boolean isId() {
        return this.isId;
    }

    public Store getStore() {
        return this.store;
    }

    public Field.Index getIndex() {
        return this.index;
    }

    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    public FieldBridge getFieldBridge() {
        return this.fieldBridge;
    }

    public Float getBoost() {
        return this.boost;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public String indexNullAs() {
        return this.nullToken;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public Integer getPrecisionStep() {
        return this.precisionStep;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DocumentFieldMetadata{");
        sb.append("fieldName='").append(this.fieldName).append('\'');
        sb.append(", store=").append((Object)this.store);
        sb.append(", index=").append(this.index);
        sb.append(", termVector=").append(this.termVector);
        sb.append(", fieldBridge=").append(this.fieldBridge);
        sb.append(", boost=").append(this.boost);
        sb.append(", analyzer=").append(this.analyzer);
        sb.append(", isId=").append(this.isId);
        sb.append(", nullToken='").append(this.nullToken).append('\'');
        sb.append(", numeric=").append(this.isNumeric);
        sb.append(", precisionStep=").append(this.precisionStep);
        sb.append('}');
        return sb.toString();
    }

    public static class Builder {
        private final String fieldName;
        private final Store store;
        private final Field.Index index;
        private final Field.TermVector termVector;
        private FieldBridge fieldBridge;
        private Float boost;
        private Analyzer analyzer;
        private boolean isId;
        private String nullToken;
        private boolean isNumeric;
        private int precisionStep = 4;

        public Builder(String fieldName, Store store, Field.Index index, Field.TermVector termVector) {
            this.fieldName = fieldName;
            this.store = store;
            this.index = index;
            this.termVector = termVector;
        }

        public Builder fieldBridge(FieldBridge fieldBridge) {
            this.fieldBridge = fieldBridge;
            return this;
        }

        public Builder boost(Float boost) {
            this.boost = boost;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder id() {
            this.isId = true;
            return this;
        }

        public Builder indexNullAs(String nullToken) {
            this.nullToken = nullToken;
            return this;
        }

        public Builder numeric() {
            this.isNumeric = true;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public DocumentFieldMetadata build() {
            return new DocumentFieldMetadata(this);
        }
    }
}

