/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.IndexingMode;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.impl.ExtendedSearchIntegratorWithShareableState;
import org.hibernate.search.spi.impl.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.impl.SearchFactoryState;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;

public class MutableSearchFactoryState
implements SearchFactoryState {
    private Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities;
    private Map<Class<?>, EntityIndexBinding> indexBindingsPerEntity;
    private IndexingMode indexingMode;
    private Worker worker;
    private BackendQueueProcessor backendQueueProcessor;
    private Map<String, FilterDef> filterDefinitions = new ConcurrentHashMap<String, FilterDef>();
    private FilterCachingStrategy filterCachingStrategy;
    private Map<String, AnalyzerReference> analyzerReferences = new ConcurrentHashMap<String, AnalyzerReference>();
    private int cacheBitResultsSize;
    private Properties configurationProperties;
    private PolymorphicIndexHierarchy indexHierarchy;
    private ServiceManager serviceManager;
    private boolean transactionManagerExpected;
    private IndexManagerHolder allIndexesManager;
    private ErrorHandler errorHandler;
    private TimeoutExceptionFactory defaultTimeoutExceptionFactory;
    private InstanceInitializer instanceInitializer;
    private TimingSource timingSource;
    private SearchMapping mapping;
    private boolean indexMetadataIsComplete;
    private boolean deleteByTermEnforced;
    private boolean isIdProvidedImplicit;
    private boolean isMultitenancyEnabled;
    private IndexManagerFactory indexManagerFactory;
    private boolean enlistWorkerInTransaction;
    private Statistics statistics;
    private LuceneWorkSerializer workSerializer;

    public void copyStateFromOldFactory(SearchFactoryState oldFactoryState) {
        this.indexingMode = oldFactoryState.getIndexingMode();
        this.indexBindingsPerEntity = oldFactoryState.getIndexBindings();
        this.documentBuildersContainedEntities = oldFactoryState.getDocumentBuildersContainedEntities();
        this.worker = oldFactoryState.getWorker();
        this.filterDefinitions = oldFactoryState.getFilterDefinitions();
        this.filterCachingStrategy = oldFactoryState.getFilterCachingStrategy();
        this.analyzerReferences = oldFactoryState.getAnalyzerReferences();
        this.cacheBitResultsSize = oldFactoryState.getCacheBitResultsSize();
        this.configurationProperties = oldFactoryState.getConfigurationProperties();
        this.indexHierarchy = oldFactoryState.getIndexHierarchy();
        this.serviceManager = oldFactoryState.getServiceManager();
        this.transactionManagerExpected = oldFactoryState.isTransactionManagerExpected();
        this.allIndexesManager = oldFactoryState.getAllIndexesManager();
        this.errorHandler = oldFactoryState.getErrorHandler();
        this.defaultTimeoutExceptionFactory = oldFactoryState.getDefaultTimeoutExceptionFactory();
        this.instanceInitializer = oldFactoryState.getInstanceInitializer();
        this.timingSource = oldFactoryState.getTimingSource();
        this.mapping = oldFactoryState.getProgrammaticMapping();
        this.indexMetadataIsComplete = oldFactoryState.isIndexMetadataComplete();
        this.deleteByTermEnforced = oldFactoryState.isDeleteByTermEnforced();
        this.isIdProvidedImplicit = oldFactoryState.isIdProvidedImplicit();
        this.isMultitenancyEnabled = oldFactoryState.isMultitenancyEnabled();
        this.indexManagerFactory = oldFactoryState.getIndexManagerFactory();
        this.enlistWorkerInTransaction = oldFactoryState.enlistWorkerInTransaction();
        this.statistics = oldFactoryState.getStatistics();
        this.workSerializer = oldFactoryState.getWorkSerializerState();
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public Map<Class<?>, EntityIndexBinding> getIndexBindings() {
        return this.indexBindingsPerEntity;
    }

    @Override
    public IndexingMode getIndexingMode() {
        return this.indexingMode;
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    public BackendQueueProcessor getBackendQueueProcessor() {
        return this.backendQueueProcessor;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<String, AnalyzerReference> getAnalyzerReferences() {
        return this.analyzerReferences;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.indexHierarchy;
    }

    public void setDocumentBuildersContainedEntities(Map<Class<?>, DocumentBuilderContainedEntity> documentBuildersContainedEntities) {
        this.documentBuildersContainedEntities = documentBuildersContainedEntities;
    }

    public void setDocumentBuildersIndexedEntities(Map<Class<?>, EntityIndexBinding> documentBuildersIndexedEntities) {
        this.indexBindingsPerEntity = documentBuildersIndexedEntities;
    }

    public void setIndexingMode(IndexingMode indexingMode) {
        this.indexingMode = indexingMode;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public void setBackendQueueProcessor(BackendQueueProcessor backendQueueProcessor) {
        this.backendQueueProcessor = backendQueueProcessor;
    }

    public void addFilterDefinitions(Map<String, FilterDef> filterDefinitions) {
        this.filterDefinitions.putAll(filterDefinitions);
    }

    public void setFilterCachingStrategy(FilterCachingStrategy filterCachingStrategy) {
        this.filterCachingStrategy = filterCachingStrategy;
    }

    public void addAnalyzerReferences(Map<String, AnalyzerReference> analyzerReferences) {
        this.analyzerReferences.putAll(analyzerReferences);
    }

    public void setCacheBitResultsSize(int cacheBitResultsSize) {
        this.cacheBitResultsSize = cacheBitResultsSize;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        this.enlistWorkerInTransaction = ConfigurationParseHelper.getBooleanValue(configurationProperties, "hibernate.search.worker.enlist_in_transaction", false);
    }

    public void setIndexHierarchy(PolymorphicIndexHierarchy indexHierarchy) {
        this.indexHierarchy = indexHierarchy;
    }

    @Override
    public boolean isTransactionManagerExpected() {
        return this.transactionManagerExpected;
    }

    public void setTransactionManagerExpected(boolean transactionManagerExpected) {
        this.transactionManagerExpected = transactionManagerExpected;
    }

    public void setAllIndexesManager(IndexManagerHolder indexesFactory) {
        this.allIndexesManager = indexesFactory;
    }

    @Override
    public IndexManagerHolder getAllIndexesManager() {
        return this.allIndexesManager;
    }

    public void setActiveSearchIntegrator(ExtendedSearchIntegratorWithShareableState factory) {
        this.allIndexesManager.setActiveSearchIntegrator(factory);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public InstanceInitializer getInstanceInitializer() {
        return this.instanceInitializer;
    }

    public void setInstanceInitializer(InstanceInitializer instanceInitializer) {
        this.instanceInitializer = instanceInitializer;
    }

    @Override
    public TimeoutExceptionFactory getDefaultTimeoutExceptionFactory() {
        return this.defaultTimeoutExceptionFactory;
    }

    public void setDefaultTimeoutExceptionFactory(TimeoutExceptionFactory defaultTimeoutExceptionFactory) {
        this.defaultTimeoutExceptionFactory = defaultTimeoutExceptionFactory;
    }

    @Override
    public TimingSource getTimingSource() {
        return this.timingSource;
    }

    public void setTimingSource(TimingSource timingSource) {
        this.timingSource = timingSource;
    }

    public void setProgrammaticMapping(SearchMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public SearchMapping getProgrammaticMapping() {
        return this.mapping;
    }

    public void setSearchMapping(SearchMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    public boolean isIndexMetadataComplete() {
        return this.indexMetadataIsComplete;
    }

    @Override
    public boolean isDeleteByTermEnforced() {
        return this.deleteByTermEnforced;
    }

    public void setIndexMetadataComplete(boolean indexMetadataIsComplete) {
        this.indexMetadataIsComplete = indexMetadataIsComplete;
    }

    public void setDeleteByTermEnforced(boolean deleteByTermEnforced) {
        this.deleteByTermEnforced = deleteByTermEnforced;
    }

    @Override
    public boolean isIdProvidedImplicit() {
        return this.isIdProvidedImplicit;
    }

    public void setIdProvidedImplicit(boolean idProvidedImplicit) {
        this.isIdProvidedImplicit = idProvidedImplicit;
    }

    @Override
    public boolean isMultitenancyEnabled() {
        return this.isMultitenancyEnabled;
    }

    public void setMultitenancyEnabled(boolean isMultitenancyEnabled) {
        this.isMultitenancyEnabled = isMultitenancyEnabled;
    }

    @Override
    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    @Override
    public boolean enlistWorkerInTransaction() {
        return this.enlistWorkerInTransaction;
    }

    public void setIndexManagerFactory(IndexManagerFactory indexManagerFactory) {
        this.indexManagerFactory = indexManagerFactory;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    @Override
    public LuceneWorkSerializer getWorkSerializerState() {
        return this.workSerializer;
    }
}

