/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.sort.impl;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.sort.impl.NativeSortField;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.DistanceSortField;

public class SortFieldStates {
    private static final Object MISSING_VALUE_LAST = new Object();
    private static final Object MISSING_VALUE_FIRST = new Object();
    private static final Map<SortField.Type, Object> SCALAR_MINIMUMS = new EnumMap<SortField.Type, Object>(SortField.Type.class);
    private static final Map<SortField.Type, Object> SCALAR_MAXIMUMS = new EnumMap<SortField.Type, Object>(SortField.Type.class);
    private final QueryBuildingContext queryContext;
    private SortField.Type currentType;
    private String currentName;
    private SortOrder currentOrder;
    private Object currentMissingValue;
    private SortField currentSortFieldNativeSortDescription;
    private Coordinates coordinates;
    private Double currentLatitude;
    private Double currentLongitude;
    private String currentStringNativeSortFieldDescription;
    public List<SortField> sortFields = new ArrayList<SortField>(3);

    private static void initScalarMinMax(SortField.Type type, Object minValue, Object maxValue) {
        SCALAR_MINIMUMS.put(type, minValue);
        SCALAR_MAXIMUMS.put(type, maxValue);
    }

    public SortFieldStates(QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
    }

    public void setCurrentType(SortField.Type currentType) {
        this.currentType = currentType;
    }

    public void setCurrentName(String fieldName) {
        this.currentName = fieldName;
    }

    public void setCurrentMissingValue(Object currentMissingValue) {
        this.currentMissingValue = currentMissingValue;
    }

    public void setCurrentMissingValueLast() {
        this.currentMissingValue = MISSING_VALUE_LAST;
    }

    public void setCurrentMissingValueFirst() {
        this.currentMissingValue = MISSING_VALUE_FIRST;
    }

    public void setAsc() {
        this.currentOrder = SortOrder.ASC;
    }

    public boolean isAsc() {
        return SortOrder.ASC.equals((Object)this.currentOrder);
    }

    public void setDesc() {
        this.currentOrder = SortOrder.DESC;
    }

    public boolean isDesc() {
        return SortOrder.DESC.equals((Object)this.currentOrder);
    }

    public void setCurrentSortFieldNativeSortDescription(SortField currentSortField) {
        this.currentSortFieldNativeSortDescription = currentSortField;
    }

    public void closeSortField() {
        SortField sortField;
        if (this.currentSortFieldNativeSortDescription != null) {
            sortField = this.currentSortFieldNativeSortDescription;
        } else if (this.currentType == SortField.Type.SCORE) {
            sortField = new SortField(null, SortField.Type.SCORE, this.isAsc());
        } else if (this.currentType == SortField.Type.DOC) {
            sortField = new SortField(null, SortField.Type.DOC, this.isDesc());
        } else if (this.coordinates != null) {
            sortField = new DistanceSortField(this.coordinates, this.currentName, this.isDesc());
            if (this.hasMissingValue()) {
                throw new SearchException("Missing values substitutes are not supported for distance sorting yet");
            }
        } else if (this.currentLatitude != null) {
            sortField = new DistanceSortField(this.currentLatitude, this.currentLongitude, this.currentName, this.isDesc());
            if (this.hasMissingValue()) {
                throw new SearchException("Missing values substitutes are not supported for distance sorting yet");
            }
        } else {
            sortField = this.currentStringNativeSortFieldDescription != null ? new NativeSortField(this.currentName, this.currentStringNativeSortFieldDescription) : new SortField(this.currentName, this.currentType, this.isDesc());
        }
        this.processMissingValue(sortField);
        this.sortFields.add(sortField);
        this.reset();
    }

    public void determineCurrentSortFieldTypeAutomaticaly() {
        this.currentType = this.getCurrentSortFieldTypeFromMetamodel();
    }

    private SortField.Type getCurrentSortFieldTypeFromMetamodel() {
        FieldDescriptor fieldDescriptor = this.queryContext.getFactory().getIndexedTypeDescriptor(this.queryContext.getEntityType()).getIndexedField(this.currentName);
        switch (fieldDescriptor.getType()) {
            case SPATIAL: {
                throw new SearchException("Field '" + this.currentName + "' is a spatial field. For spatial fields, use .byDistance() and not .byField().");
            }
            case NUMERIC: {
                NumericFieldSettingsDescriptor nfd = fieldDescriptor.as(NumericFieldSettingsDescriptor.class);
                switch (nfd.encodingType()) {
                    case DOUBLE: {
                        return SortField.Type.DOUBLE;
                    }
                    case FLOAT: {
                        return SortField.Type.FLOAT;
                    }
                    case LONG: {
                        return SortField.Type.LONG;
                    }
                    case INTEGER: {
                        return SortField.Type.INT;
                    }
                }
                break;
            }
            case BASIC: {
                return SortField.Type.STRING;
            }
        }
        throw new SearchException("Cannot automatically determine the field type for field '" + this.currentName + "'. Use byField(String, Sort.Type) to provide the sort type explicitly.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processMissingValue(SortField sortField) {
        if (this.currentMissingValue == null || sortField.getType() == null) return;
        if (sortField.getType() == SortField.Type.STRING || sortField.getType() == SortField.Type.STRING_VAL) {
            if (this.currentMissingValue == MISSING_VALUE_LAST) {
                sortField.setMissingValue(SortField.STRING_LAST);
                return;
            } else {
                if (this.currentMissingValue != MISSING_VALUE_FIRST) throw new SearchException("Unsupported 'use(Object)' for the field type: '" + this.currentType + "'. Only 'sortFirst()' and 'sortLast()' are supported.");
                sortField.setMissingValue(SortField.STRING_FIRST);
            }
            return;
        } else {
            boolean reverse = sortField.getReverse();
            if (this.currentMissingValue == MISSING_VALUE_FIRST && !reverse || this.currentMissingValue == MISSING_VALUE_LAST && reverse) {
                Object min = SCALAR_MINIMUMS.get(sortField.getType());
                if (min == null) throw new SearchException("Unsupported 'sortFirst()'/'sortLast()' for the field type: '" + this.currentType + "'. Only 'use(Object)' is supported.");
                sortField.setMissingValue(min);
                return;
            } else if (this.currentMissingValue == MISSING_VALUE_LAST && !reverse || this.currentMissingValue == MISSING_VALUE_FIRST && reverse) {
                Object max = SCALAR_MAXIMUMS.get(sortField.getType());
                if (max == null) throw new SearchException("Unsupported 'sortFirst()'/'sortLast()' for the field type: '" + this.currentType + "'. Only 'use(Object)' is supported.");
                sortField.setMissingValue(max);
                return;
            } else {
                sortField.setMissingValue(this.currentMissingValue);
            }
        }
    }

    public Sort createSort() {
        return new Sort(this.sortFields.toArray(new SortField[this.sortFields.size()]));
    }

    private boolean hasMissingValue() {
        return this.currentMissingValue != null;
    }

    private void reset() {
        this.currentType = null;
        this.currentName = null;
        this.currentOrder = null;
        this.currentMissingValue = null;
        this.currentSortFieldNativeSortDescription = null;
        this.coordinates = null;
        this.currentLatitude = null;
        this.currentLongitude = null;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.coordinates = coordinates;
    }

    public void setCurrentLatitude(double latitude) {
        this.currentLatitude = latitude;
    }

    public void setCurrentLongitude(double longitude) {
        this.currentLongitude = longitude;
    }

    public void setCurrentStringNativeSortFieldDescription(String nativeSortFieldDescription) {
        this.currentStringNativeSortFieldDescription = nativeSortFieldDescription;
    }

    static {
        SortFieldStates.initScalarMinMax(SortField.Type.DOUBLE, Double.MIN_VALUE, Double.MAX_VALUE);
        SortFieldStates.initScalarMinMax(SortField.Type.FLOAT, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        SortFieldStates.initScalarMinMax(SortField.Type.LONG, Long.MIN_VALUE, Long.MAX_VALUE);
        SortFieldStates.initScalarMinMax(SortField.Type.INT, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static enum SortOrder {
        ASC,
        DESC;

    }
}

