/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.DistanceFilter;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;
import org.hibernate.search.spatial.impl.SpatialHashFilter;
import org.hibernate.search.spatial.impl.SpatialHelper;

public abstract class SpatialQueryBuilderFromCoordinates {
    public static Filter buildSpatialHashFilter(Coordinates center, double radius, String fieldName) {
        int bestSpatialHashLevel = SpatialHelper.findBestSpatialHashLevelForSearchRange(2.0 * radius);
        if (bestSpatialHashLevel > 16) {
            bestSpatialHashLevel = 16;
        }
        List<String> spatialHashCellsIds = SpatialHelper.getSpatialHashCellsIds(center, radius, bestSpatialHashLevel);
        return new SpatialHashFilter(spatialHashCellsIds, SpatialHelper.formatFieldName(bestSpatialHashLevel, fieldName));
    }

    public static Filter buildDistanceFilter(Filter previousFilter, Coordinates center, double radius, String coordinatesField) {
        return new DistanceFilter(previousFilter, center, radius, coordinatesField);
    }

    public static Filter buildDistanceFilter(Filter previousFilter, Coordinates center, double radius, String latitudeField, String longitudeField) {
        return new DistanceFilter(previousFilter, center, radius, latitudeField, longitudeField);
    }

    public static Query buildSpatialHashQuery(Coordinates center, double radius, String fieldName) {
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildSpatialHashFilter(center, radius, fieldName));
    }

    public static Query buildDistanceQuery(Coordinates center, double radius, String fieldName) {
        QueryWrapperFilter allFilter = new QueryWrapperFilter((Query)new MatchAllDocsQuery());
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildDistanceFilter((Filter)allFilter, center, radius, fieldName));
    }

    public static Query buildSpatialQueryByHash(Coordinates center, double radius, String fieldName) {
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildDistanceFilter(SpatialQueryBuilderFromCoordinates.buildSpatialHashFilter(center, radius, fieldName), center, radius, fieldName));
    }

    public static Query buildSpatialQueryByRange(Coordinates centerCoordinates, double radius, String fieldName) {
        Point center = Point.fromCoordinates(centerCoordinates);
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        String latitudeFieldName = fieldName + "_HSSI_Latitude";
        String longitudeFieldName = fieldName + "_HSSI_Longitude";
        NumericRangeQuery latQuery = NumericRangeQuery.newDoubleRange((String)latitudeFieldName, (Double)boundingBox.getLowerLeft().getLatitude(), (Double)boundingBox.getUpperRight().getLatitude(), (boolean)true, (boolean)true);
        Object longQuery = null;
        longQuery = boundingBox.getLowerLeft().getLongitude() <= boundingBox.getUpperRight().getLongitude() ? NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)boundingBox.getLowerLeft().getLongitude(), (Double)boundingBox.getUpperRight().getLongitude(), (boolean)true, (boolean)true) : new BooleanQuery.Builder().add((Query)NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)boundingBox.getLowerLeft().getLongitude(), (Double)180.0, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD).add((Query)NumericRangeQuery.newDoubleRange((String)longitudeFieldName, (Double)-180.0, (Double)boundingBox.getUpperRight().getLongitude(), (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD).build();
        BooleanQuery boxQuery = new BooleanQuery.Builder().add((Query)latQuery, BooleanClause.Occur.FILTER).add((Query)longQuery, BooleanClause.Occur.FILTER).build();
        return new FilteredQuery((Query)new MatchAllDocsQuery(), SpatialQueryBuilderFromCoordinates.buildDistanceFilter((Filter)new QueryWrapperFilter((Query)boxQuery), center, radius, latitudeFieldName, longitudeFieldName));
    }
}

